/*
 * ArrayDataSet.java
 *
 * Created on April 2, 2007, 9:47 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.virbo.dataset;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;

/**
 * dataset backed by an array.
 *
 * Mutable datasets warning: No dataset should be mutable once it is accessible to the
 * rest of the system.  This would require clients make defensive copies which would 
 * seriously degrade performance.  
 * @author jbf
 * @deprecated, DDataSet subsumes functionality and allows for higher rank.
 */
public class ArrayDataSet extends AbstractDataSet implements WritableDataSet {
    double[] data;
    
    /**
     * creates an ArrayDataSet that is a copy of rank 1 dataset <tt>ds</tt>.  In some future
     * version, all properties will be copied, but for now just UNITS and DEPEND_0 are copied.
     * The depend_0 dataset is not a copy, it is the original.
     */
    public static ArrayDataSet copy( DataSet ds ) {
        if ( ds.rank()>1 ) throw new IllegalArgumentException("only rank 1 supported");
        ArrayDataSet result= new ArrayDataSet( new double[ ds.length() ] );
        for ( int i=0; i<ds.length(); i++ ) {
            double d= ds.value( i );
            result.putValue( i, d );
        }
        result.putProperty( DataSet.UNITS, ds.property( DataSet.UNITS ) );
        result.putProperty( DataSet.DEPEND_0, ds.property( DataSet.DEPEND_0 ) );
        result.putProperty( "plane0", ds.property( "plane0" ) );
        return result;
    }
    
    public ArrayDataSet( double[] data ) {
        this.data= data;
    }
    public int rank() {
        return 1;
    }
    public double value(int i) {
        return data[i];
    }
    public int length() {
        return data.length;
    }
    /* danger
     */
    public void putProperty( String name, Object o ) {
        properties.put( name, o );
    }
    
    public void putValue(int i, double d) {
        data[i]= d;
    }
    
    public void putValue(int i0, int i1, double d) {
        throw new IllegalArgumentException("rank error, expected "+rank());
    }
    
    public void putValue(int i0, int i1, int i2, double d) {
        throw new IllegalArgumentException("rank error, expected "+rank());
    }
    
    public String toString( ) {
        return DataSetUtil.toString( this );
    }
    
}
