/*
 * DataSet.java
 *
 * Created on January 25, 2007, 9:12 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.virbo.dataset;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;

/**
 *
 * @author jbf
 */
public interface DataSet {
    
    public final static String DEPEND_0="DEPEND_0";
    public final static String DEPEND_1="DEPEND_1";
    public final static String DEPEND_2="DEPEND_2";
    
    /* correlated datasets */
    public final static String PLANE_0= "PLANE_0";
    
    /**
     * Units
     */
    public final static String UNITS="UNITS";
    
    /**
     * DatumRange
     */
    public final static String VALID_RANGE="VALID_RANGE";
    
    /**
     * DatumRange
     */    
    public final static String TYPICAL_RANGE="TYPICAL_RANGE";
    
    /**
     * String "linear" or "log"
     */
    public final static String SCALE_TYPE="SCALE_TYPE";
    
    /**
     * String, Concise Human-consumable label suitable for a plot label.
     */
    public final static String LABEL="LABEL";
    
    /**
     * Double, Double value to be considered fill (invalid) data.
     */
    public final static String FILL="FILL";
    
    /**
     * Boolean, Boolean.true if dataset is monotonically increasing.  Also, the data contains no invalid values.
     */
    public final static String MONOTONIC="MONOTONIC";
            
    /**
     * DataSet, dataset of same geometry that indicates the weights for each point.  Often weights are computed
     * in processing, and this is where they should be stored for other routines.  Furthermore, averages of averages
     * will compute accurately.
     */
    public final static String WEIGHTS_PLANE="WEIGHTS";
    
    /**
     * Double, the expected distance between successive measurements where it is valid to make inferences about the data.
     * This property only makes sense with a tags dataset.
     */
    public final static String CADENCE="CADENCE";
    
    int rank();
    
    double value( int i );
    double value( int i0, int  i1 );
    double value( int i0, int  i1, int i2 );
    
    Object property( String name );
    Object property( String name, int i );
    Object property( String name, int i0, int i1 );
    
    /**
     * return the length of the first dimension
     */
    int length( );
    
    /**
     *return the length of the second dimension, for the ith element of the first dimension
     */
    int length( int i );

    /**
     *return the length of the third dimension, for the ith element of the first dimension and jth element of the second dimension.
     */
    int length( int i, int j );
        
}