/*
 * DataSetOps.java
 *
 * Created on January 29, 2007, 9:48 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.virbo.dataset;

import edu.uiowa.physics.pw.das.datum.Units;
import java.util.Arrays;
import java.util.Comparator;

/**
 *
 * @author jbf
 */
public class DataSetOps {
    
    /**
     *slice on the first dimension
     */
    public static DataSet slice0( final DataSet ds, final int index ) {
        return new Slice0DataSet( ds, index );
    }
    
    /**
     * this strange dataset operator assumes a square or qube dataset
     * by picking the index-th element of dataset's second dimension, without
     * regard to tags.
     */
    public static DataSet slice1( final DataSet ds, final int index ) {
        if ( ds.rank()>2 ) {
            throw new IllegalArgumentException("rank limit > 2");
        }
        
        return new DataSet() {
            public int rank() {
                return ds.rank()-1;
            }

            public double value(int i) {
                return ds.value(i,index);
            }

            public double value(int i0, int i1) {
                return ds.value( i0,index,i1);
            }

            public double value(int i0, int i1, int i2) {
                throw new IllegalArgumentException("rank limit");
            }

            public Object property(String name) {
                return ds.property(name);
            }

            public Object property(String name, int i) {
                throw new IllegalArgumentException("rank limit");
            }

            public Object property(String name, int i0, int i1) {
                throw new IllegalArgumentException("rank limit");
            }

            public int length() {
                return ds.length();
            }

            public int length(int i) {
                throw new IllegalArgumentException("rank limit");
            }

            public int length(int i, int j) {
                throw new IllegalArgumentException("rank limit");
            }
            
            public String toString( ) {
                return DataSetUtil.toString(this);
            }
        };
    }
    
    /**
     * pull out a subset of the dataset by reducing the number of columns in the
     * last dimension.  This does not reduce rank.  This assumes the dataset has no
     * row with length>end.
     *
     */
    public static DataSet leafTrim( final DataSet ds, final int start, final int end ) {
        
        if ( ds.rank()>3 ) {
            throw new IllegalArgumentException("rank limit > 3");
        }
        
        return new DataSet() {
            public int rank() {
                return ds.rank();
            }

            public double value(int i) {
                return ds.value(i+start);
            }

            public double value(int i0, int i1) {
                return ds.value( i0, i1+start );
            }

            public double value(int i0, int i1, int i2) {
                return ds.value( i0, i1, i2+start );
            }

            public Object property(String name) {
                String depNName= "DEPEND_"+(ds.rank()-1);
                if ( name.equals( depNName ) ) {
                    DataSet depN= (DataSet) ds.property( depNName );
                    if ( depN!=null ) {
                        depN= leafTrim( depN, start, end );
                    }
                    return depN;
                } else {
                    return ds.property(name);
                }
            }

            public Object property(String name, int i) {
                return ds.property(name,i+start);
            }

            public Object property(String name, int i0, int i1) {
                return ds.property(name,i0,i1+start);
            }

            public int length() {
                return ds.rank()==1 ? end-start : ds.length();
            }

            public int length(int i) {
                return ds.rank()==2 ? end-start : ds.length();
            }

            public int length(int i, int j) {
                return ds.rank()==3 ? end-start : ds.length();
            }
            
            public String toString( ) {
                return DataSetUtil.toString(this);
            }
        };
        
    }
    
    /**
     * @deprecated use DataSetUtil.toString instead
     */
    public static String toString( DataSet ds ) {
        return DataSetUtil.toString(ds);
    }
    
    /**
     * returns a list of indeces that sort the dataset.  I don't like this implementation, because 
     * it requires that an array of Integers be created.  Invalid measurements are not indexed in 
     * the returned dataset.
     */
    public static DataSet sort( final DataSet ds ) {
        if ( ds.rank()>1 ) throw new IllegalArgumentException();
        Integer[] indeces= new Integer[ds.length()];
        int i0=0;
        final Units u= (Units) ds.property(DataSet.UNITS);
        for ( int i=0;i<ds.length(); i++ ) {
            if ( u==null || ! u.isFill( ds.value(i) ) ) {
              indeces[i0]= new Integer(i);
              i0++;
            }
        }
        Comparator c= new Comparator() {
            public int compare( Object o1, Object o2 ) {
                int i1= ( (Integer)o1).intValue();
                int i2= ( (Integer)o2).intValue();
                return Double.compare( ds.value(i1), ds.value(i2) );
            }
        };
        Arrays.sort( indeces, 0, i0, c );
        final int[] data= new int[i0];
        for ( int i=0;i<i0; i++ ) data[i]= indeces[i].intValue();
        return new IndexGenDataSet(i0) {
            public double value( int i ) {
                return data[i];
            }
        };
    }
    
    public static DataSet histogram( DataSet ds, final double min, final double max, final double binsize ) {
        int n=(int) Math.ceil( (  max - min ) / binsize );
        DataSet tags= DataSetUtil.tagGenDataSet( n, min, binsize );
        final Units u= (Units)ds.property( DataSet.UNITS );
        final int[] hits= new int[n];
        for ( int i=0; i<ds.length(); i++ ) {
            if ( u==null || !u.isFill( ds.value(i) ) ) {
                int ibin= (int)(( ds.value(i) - min ) / binsize);
                if ( ibin>=0 && ibin < n ) hits[ibin]++;
            }
        }
        IndexGenDataSet result= new IndexGenDataSet(n) {
            public double value(int i) {
                return hits[i];
            }
        };
        result.putProperty( DataSet.DEPEND_0, tags );
        return result;
    }
    
    
}
