/*
 * Rank1ViewDataSet.java
 *
 * Created on August 17, 2007, 9:16 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.virbo.dataset;

/**
 *
 * @author jbf
 */
public abstract class Rank1ViewDataSet implements DataSet {
    
    DataSet source;
    
    public DataSet newDataSet( DataSet source ) {
        if ( source.rank()==1 ) {
            return source;
        } else if ( source.rank()==2 ) {
            return new Rank2(source);
        } else if ( source.rank()==3 ) {
            //return new Rank3(source);
            throw new IllegalArgumentException("not implemented");
        } else {
            throw new IllegalArgumentException("not implemented");
        }
    }
    
    /** Creates a new instance of Rank1ViewDataSet */
    private Rank1ViewDataSet( DataSet source ) {
        this.source= source;
    }
    
    public int rank() {
        return 1;
    }
    
    public abstract double value(int i);
    
    public double value(int i0, int i1) {
        throw new IllegalArgumentException("only rank1 access");
    }
    
    public double value(int i0, int i1, int i2) {
        throw new IllegalArgumentException("only rank1 access");
    }
    
    public Object property(String name) {
        return source.property(name);
    }
    
    public Object property(String name, int i) {
        throw new IllegalArgumentException("only rank1 access");
    }
    
    public Object property(String name, int i0, int i1) {
        throw new IllegalArgumentException("only rank1 access");
    }
    
    public abstract int length();
    
    public int length(int i) {
        throw new IllegalArgumentException("only rank1 access");
    }
    
    public int length(int i, int j) {
        throw new IllegalArgumentException("only rank1 access");
    }
    
    private class Rank2 extends Rank1ViewDataSet {
        int colStart;  // i at column beg.
        int col=0; // current col;
        int length;
                
        Rank2( DataSet ds ) {
            super(ds);
            col= 0;
            length=0;
            for ( int i=0; i<ds.length(); i++ ) {
                length+= ds.length(i);
            }
        }
        
        public double value(int i) {
            int j= i-colStart;
            while ( j>source.length(col) ) {
                colStart+= source.length(col);
                col+=1;
                j= i-colStart;
            }
            return source.value(col,j);
        }
        
        public int length() {
            return length;
        }
        
    }
    
/*     private class Rank3 extends Rank1ViewDataSet {
        int col0Start;  // i at column beg.
        int col0=0; // current col;
        int col1Start;  // i at column beg.
        int col1=0; // current col;
        int length;
                
        Rank3( DataSet ds ) {
            super(ds);
            col0= 0;
            col1= 0;
            length= 0;
            for ( int i=0; i<ds.length(); i++ ) {
                for ( int j=0; j<ds.length(i); j++ ) {
                    length+= ds.length(i,j);
                }
            }
        }
        
        public double value(int i) {
            int k= i-col1Start;
            int i=col0;
            while ( j>source.length(col0,col1) &&  ) {
                while ( col1>source.length(col0) ) {
                    length+= ds.length(i,j);
                }
            }
            while ( j>source.length(col0,0) ) {
                col0Start+= source.length(col);
                col0+=1;
                j= i-col0Start;
            }
            return source.value(col,j);
        }
        
        public int length() {
            return length;
        }
        
    }*/
}
