/*
 * DataSetBuilder.java
 *
 * Created on May 25, 2007, 7:04 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.virbo.dsutil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DataSet;

/**
 * allows dataset of unknown length to be built. Presently, this only builds QUBES, but should allow for geometry changes.
 * TODO: consider using WritableDataSet interface.
 * @author jbf
 */
public class DataSetBuilder {
    
    int rank;
    
    ArrayList<DDataSet> finished;
    DDataSet current;
    int recCount;
    int dim1, dim2;
    int index;
    int offset;
    HashMap<String,Object> properties;
    
    /**
     * recCount is the guess of dim0 size.  Bad guesses will result in extra copies or size.
     */
    public DataSetBuilder( int rank, int recCount, int dim1, int dim2 ) {
        this.rank= rank;
        this.recCount= recCount;
        this.dim1= dim1;
        this.dim2= dim2;
        newCurrent();
        index=0;
        properties= new HashMap<String,Object>();
    }
    
    private void newCurrent() {
        if ( rank==1 ) {
            current= DDataSet.createRank1(recCount);
        } else if ( rank==2 ) {
            current= DDataSet.createRank2(recCount,dim1);
        } else if ( rank==3 ) {
            current= DDataSet.createRank3( recCount, dim1, dim2 );
        }
    }
    
    /**
     * index0 is ignored!!!
     */
    public void putValue( int index0, double d ) {
        current.putValue( this.index, d );
    }
    
    /**
     * index0 is ignored!!!
     */
    public void putValue( int index0, int index1, double d ) {
        current.putValue( this.index, index1, d );
    }
    
    /**
     * index0 is ignored!!!
     */
    public void putValue( int index0, int index1, int index2, double d ) {
        current.putValue( this.index, index1, index2, d );
    }
    
    public void nextRecord() {
        index++;
        if ( index == current.length() ) {
            if ( finished==null ) finished= new ArrayList<DDataSet>(4);
            finished.add( current );
            offset += current.length();
            index -= current.length();
            newCurrent();
        }
    }
    
    /**
     * returns the result dataset, concatenating all the datasets it's built
     * thus far.
     */
    public DDataSet getDataSet() {
        DDataSet result;
        int len;
        
        switch (rank ) {
            case 1: result= DDataSet.createRank1(index+offset); break;
            case 2: result= DDataSet.createRank2(index+offset,dim1); break;
            case 3: result= DDataSet.createRank3(index+offset,dim1,dim2); break;
            default: throw new RuntimeException("bad rank");
        }
        
        int dsindex=0; // dim0 index to copy dataset
        if ( finished!=null ) {
            for ( int i=0; i<finished.size(); i++ ) {
                DDataSet f1= finished.get(i);
                DDataSet.copyElements( f1, 0, result, dsindex, f1.length() );
                dsindex+= f1.length();
            }
            DDataSet.copyElements( current, 0, result, dsindex, index );
        } else {
            result= DDataSet.copy(current);
        }
        result.putLength( index+offset );
        
        for ( Iterator<String> i= properties.keySet().iterator(); i.hasNext();  ) {
            String key= i.next();
            result.putProperty( key, properties.get(key) );
        }
        
        return result;
    }

    public void putProperty( String string, Object o ) {
        properties.put( string, o );
    }
}
