/*
 * AggregatingDataSource.java
 *
 * Created on October 25, 2007, 10:29 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.virbo.aggragator;

import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.datum.DatumRangeUtil;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import edu.uiowa.physics.pw.das.util.SubTaskMonitor;
import edu.uiowa.physics.pw.das.util.fileSystem.FileStorageModel;
import edu.uiowa.physics.pw.das.util.fileSystem.FileSystem;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.Map;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DataSet;
import org.virbo.datasource.AbstractDataSource;
import org.virbo.datasource.DataSetURL;
import org.virbo.datasource.DataSourceFactory;

/**
 *
 * http://www.papco.org:8080/opendap/cdf/polar/hyd_h0/%Y/po_h0_hyd_%Y%m%d_v...cdf.dds?ELECTRON_DIFFERENTIAL_ENERGY_FLUX
 * @author jbf
 */
public class AggregatingDataSource extends AbstractDataSource {
    
    private FileStorageModel fsm;
    DataSourceFactory delegateDataSourceFactory;
    
    
    /** Creates a new instance of AggregatingDataSource */
    public AggregatingDataSource( URL url ) throws MalformedURLException, FileSystem.FileSystemOfflineException, IOException, ParseException {
        super(url);
        String surl= url.toString();
        delegateDataSourceFactory= AggregatingDataSourceFactory.getDelegateDataSourceFactory(surl);
    }
    
    public DataSet getDataSet(DasProgressMonitor mon) throws Exception {
        String[] ss= getFsm().getNamesFor(viewRange);
        
        DDataSet result=null;
        mon.setTaskSize(ss.length*10);
        mon.started();
        for ( int i=0; i<ss.length; i++ ) {
            String scompUrl= getFsm().getFileSystem().getRootURL() + ss[i];
            if ( !params.equals("") ) scompUrl+= "?"+params;
            URL compUrl= new URL(  scompUrl );
            DataSet ds1= delegateDataSourceFactory.getDataSource(compUrl).getDataSet( SubTaskMonitor.create(mon,i*10,10*(i+1)) );
            if ( result==null ) {
                result= DDataSet.copy( ds1 );
            } else {
                result.join( DDataSet.copy(ds1) );
            }
        }
        
        return result;
        
    }
    
    /**
     * Holds value of property viewRange.
     */
    private DatumRange viewRange= DatumRangeUtil.parseTimeRangeValid("2006-07-03 to 2006-07-05");
    
    /**
     * Utility field used by bound properties.
     */
    private java.beans.PropertyChangeSupport propertyChangeSupport =  new java.beans.PropertyChangeSupport(this);
    
    /**
     * Adds a PropertyChangeListener to the listener list.
     * @param l The listener to add.
     */
    public void addPropertyChangeListener(java.beans.PropertyChangeListener l) {
        propertyChangeSupport.addPropertyChangeListener(l);
    }
    
    /**
     * Removes a PropertyChangeListener from the listener list.
     * @param l The listener to remove.
     */
    public void removePropertyChangeListener(java.beans.PropertyChangeListener l) {
        propertyChangeSupport.removePropertyChangeListener(l);
    }
    
    /**
     * Getter for property viewRange.
     * @return Value of property viewRange.
     */
    public DatumRange getViewRange() {
        return this.viewRange;
    }
    
    /**
     * Setter for property viewRange.
     * @param viewRange New value of property viewRange.
     */
    public void setViewRange(DatumRange viewRange) {
        DatumRange oldViewRange = this.viewRange;
        this.viewRange = viewRange;
        propertyChangeSupport.firePropertyChange("viewRange", oldViewRange, viewRange);
    }

    public FileStorageModel getFsm() {
        return fsm;
    }

    public void setFsm(FileStorageModel fsm) {
        this.fsm = fsm;
    }

    /**
     * Holds value of property params.
     */
    private String params="";

    /**
     * Getter for property args.
     * @return Value of property args.
     */
    public String getParams() {
        return this.params;
    }

    /**
     * Setter for property args.
     * @param args New value of property args.
     */
    public void setParams(String params) {
        String oldParams = this.params;
        this.params = params;
        propertyChangeSupport.firePropertyChange ("args", oldParams, params);
    }
    
}
