/*
 * AggregatingDataSourceFactory.java
 *
 * Created on October 25, 2007, 11:02 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.virbo.aggragator;

import edu.uiowa.physics.pw.das.datum.DatumRangeUtil;
import edu.uiowa.physics.pw.das.util.fileSystem.FileStorageModel;
import edu.uiowa.physics.pw.das.util.fileSystem.FileSystem;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.virbo.datasource.DataSetURL;
import org.virbo.datasource.DataSource;
import org.virbo.datasource.DataSourceFactory;

/**
 *
 * @author jbf
 */
public class AggregatingDataSourceFactory implements DataSourceFactory {
    
    /** Creates a new instance of AggregatingDataSourceFactory */
    public AggregatingDataSourceFactory() {
    }
    
    public DataSource getDataSource(URL url) throws Exception {
        String surl= url.toString();
        AggregatingDataSource ads= new AggregatingDataSource(url);
        FileStorageModel fsm= getFileStorageModel(surl);
        ads.setFsm(fsm);
        DataSetURL.URLSplit split= DataSetURL.parse( surl );
        Map parms= DataSetURL.parseParams( split.params );
        ads.setViewRange( DatumRangeUtil.parseTimeRange( (String) parms.get( "timerange" ) ) );
        
        parms.remove("timerange");
        if ( parms.size()>0 ) ads.setParams( DataSetURL.formatParams( parms ) );
        
        return ads;
    }
    
    public String[] getCompletions(String surl) throws Exception {
        
        DataSourceFactory f= getDelegateDataSourceFactory( surl );
        return f.getCompletions(surl);
    }
    
    private static int splitIndex( String surl ) {
        int i= surl.indexOf('%');
        i= surl.lastIndexOf('/',i);
        return i;
    }
    
    public static FileStorageModel getFileStorageModel( String surl ) throws IOException {
        int i= surl.indexOf('?');
        
        String sansArgs= surl.substring(0,i);
        
        i= splitIndex( sansArgs );
        FileSystem fs= FileSystem.create( new URL( sansArgs.substring(0,i) ) );
        FileStorageModel fsm= FileStorageModel.create( fs, sansArgs.substring(i) );
        
        return fsm;
    }
    
    public static String getDelegateDataSourceFactoryUrl( String surl ) throws IOException {
        FileStorageModel fsm= getFileStorageModel(surl);
        
        String[] ss= fsm.getNamesFor( DatumRangeUtil.parseTimeRangeValid("1960-2030") );
        
        DataSetURL.URLSplit split= DataSetURL.parse( surl );
        
        Map parms= DataSetURL.parseParams( split.params );
        parms.remove("timerange");
        split.params= DataSetURL.formatParams( parms );
        
        
        try {
            String scompUrl= fsm.getFileSystem().getRootURL()+ss[0];
            if ( split.params.length()>0 ) scompUrl+="?"+split.params;
            URL compUrl= new URL( scompUrl );
            return compUrl.toString();
        } catch ( MalformedURLException ex ) {
            throw new RuntimeException(ex);
        }
    }
    
    public static DataSourceFactory getDelegateDataSourceFactory( String surl )  throws IOException {
        return DataSetURL.getDataSourceFactory( new URL( getDelegateDataSourceFactoryUrl( surl ) ) );
    }
    
}
