/*
 * AsciiTableDataSource.java
 *
 * Created on March 31, 2007, 8:22 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.virbo.ascii;


import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.dataset.parser.VectorDataSetParser;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import edu.uiowa.physics.pw.das.util.SubTaskMonitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.TreeModel;
import org.virbo.dataset.AbstractDataSet;
import org.virbo.dataset.DDataSet;
import org.virbo.dataset.DataSet;
import org.virbo.dataset.DataSetAdapter;
import org.virbo.dataset.DataSetOps;
import org.virbo.dataset.DataSetUtil;
import org.virbo.datasource.AbstractDataSource;
import org.virbo.datasource.DataSetURL;
import org.virbo.datasource.DataSource;
import org.virbo.datasource.DataSourceFactory;
import org.virbo.dsutil.AsciiParser;
import org.virbo.metatree.NameValueTreeModel;

/**
 *
 * @author jbf
 */
public class AsciiTableDataSource extends AbstractDataSource {
    
    AsciiParser parser;
    File file;
    String column= "field0";
    String depend0= null;
    
    DDataSet ds=null;
    
    /**
     * non-null indicates the columns should be interpretted as rank2.  rank2[0] is first column, rank2[1] is last column exclusive.
     */
    int[] rank2=null;
    
    /** Creates a new instance of AsciiTableDataSource */
    public AsciiTableDataSource( URL url ) throws FileNotFoundException, IOException {
        super(url);
        
    }
    
    public DataSet getDataSet(DasProgressMonitor mon) throws IOException {
        ds = doReadFile(mon); //DANGER
        
        DataSet vds=null;
        DataSet dep0=null;
        
        for ( int i=0; i<ds.length(0); i++ ) {
            if ( ("field"+i).equals(column) ) {
                vds= DataSetOps.slice1( ds, i );
            }
            if ( ("field"+i).equals(depend0) ) {
                dep0= DataSetOps.slice1( ds, i );
            }
        }
        
        if ( dep0!=null ) ds.putProperty( DataSet.DEPEND_0, dep0 );
        
        if ( rank2!=null ) {
            // TODO: implement trim
            return ds;
        } else {
            if ( vds==null ) throw new IllegalArgumentException("didn't find column: "+column);
            return vds;
        }
        
    }

    private DDataSet doReadFile(final DasProgressMonitor mon) throws NumberFormatException, IOException, FileNotFoundException {
        
        Map params= DataSetURL.parseParams( url.getQuery() );
        Object o;
        file= DataSetURL.getFile( url , mon  );
        
        int columnCount=0;
        
        o=params.get("fixedColumns");
        if ( o!=null ) {
            columnCount= Integer.parseInt( (String) o );
        }
        
        o= params.get( "columnCount" );
        if ( columnCount==0 ) {
            if (  o!=null ) {
                columnCount= Integer.parseInt( (String) o );
            } else {
                columnCount= AsciiParser.guessFieldCount( file.toString() );
            }
        }
        
        parser= AsciiParser.newParser( columnCount );
        
        parser.setPropertyPattern( parser.NAME_COLON_VALUE_PATTERN );

        o= params.get( "skip" );
        if ( o!=null ) {
            parser.setSkipLines( Integer.parseInt( (String) o ) );
        }
                
        o=params.get("fixedColumns");
        if ( o!=null ) {
            parser.setFixedColumnsParser( file.toString(), "\\s+" );
            parser.setPropertyPattern(null);
        }
        
        o= params.get("column");
        if ( o!=null ) {
            column= (String)o;
        }
        
        o= params.get("depend0");
        if ( o!=null ) {
            depend0= (String)o;
        }
        
        o= params.get("rank2" );
        if ( o!=null ) {
            rank2= new int[] { 0,columnCount };
        }
        
        DDataSet ds= (DDataSet) parser.readFile( file.toString(), mon ); //DANGER
        return ds;
    }
    
    public static DataSourceFactory getFactory() {
        return new DataSourceFactory() {
            public DataSource getDataSource(URL url) throws FileNotFoundException, IOException {
                return new AsciiTableDataSource( url );
            }
            public String[] getCompletions(String surl) throws MalformedURLException, FileNotFoundException, IOException {
                File file= DataSetURL.getFile( DataSetURL.getURL(surl), DasProgressMonitor.NULL );
                String[] result= new String[1];
                result[0]= DataSetURL.getURL(file.toString())+"?skip=0&column=field0&fixedColumns=2";
                //for ( int i=0; i<columnCount; i++  ) result[i]= DataSetURL.getURL(file.toString()) +"?column=field" + i;
                return result;
            }
        };
    }

    public TreeModel getMetaData() throws Exception {
        if ( ds==null ) return NameValueTreeModel.create( "no metadata", new HashMap() );
        Map props= ds.getProperties();
        TreeModel retValue= NameValueTreeModel.create("metadata",props);
        
        return retValue;
    }
    
}
