/*
 * AbstractDataSource.java
 *
 * Created on April 1, 2007, 7:12 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.virbo.datasource;

import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import java.io.IOException;
import java.net.URL;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.virbo.dataset.DataSet;

/**
 *
 * @author jbf
 */
public abstract class AbstractDataSource implements DataSource {
    
    protected URL url;
    
    public AbstractDataSource( URL url ) {
        this.url= url;
    }
    
    public abstract DataSet getDataSet(DasProgressMonitor mon) throws Exception;
    
    public boolean asynchronousLoad() {
        return true;
    }
    
    public DatumRange getXRange() {
        return DatumRange.newDatumRange( 0, 100, Units.dimensionless );
    }
    
    public DatumRange getYRange() {
        return DatumRange.newDatumRange( 0, 100, Units.dimensionless );
    }
    
    public String getLabel() {
        return url.toString();
    }
    
    public String toString() {
        return url.toString();
    }
    
    public String getURL() {
        return url.toString();
    }
    
    public DataSourceFactory getFactory() {
        try {
            return DataSetURL.getDataSourceFactory(this.url);
        } catch ( IOException e ) {
            throw new RuntimeException(e);  // we should be able to make a factory
        }
    }
    
    /**
     * abstract class version returns an empty tree.  Override this method
     * to provide metadata.
     */
    public TreeModel getMetaData() throws Exception {
        final Object ROOT= "(no metadata provided)";
        
        return new TreeModel() {
            public Object getRoot() {
                return ROOT;
            }

            public Object getChild(Object parent, int index) {
                return null;
            }

            public int getChildCount(Object parent) {
                return 0;
            }

            public boolean isLeaf(Object node) {
                return node!=ROOT;
            }
            
            public void valueForPathChanged(TreePath path, Object newValue) {
            }

            public int getIndexOfChild(Object parent, Object child) {
                return 0;
            }
            
            public void addTreeModelListener(TreeModelListener l) {
            }
            
            public void removeTreeModelListener(TreeModelListener l) {
            }
            
        };
    }
    
}
