/*
 * DataSetSelector.java
 *
 * Created on November 5, 2007, 6:04 AM
 */

package org.virbo.datasource;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import edu.uiowa.physics.pw.das.util.fileSystem.FileSystem;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputMap;
import javax.swing.JFileChooser;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

/**
 *
 * @author  jbf
 */
public class DataSetSelector extends javax.swing.JPanel {
    
    /** Creates new form DataSetSelector */
    public DataSetSelector() {
        initComponents();
        addCompletionKeys();
        dataSetSelector.addKeyListener( new KeyListener() {
            public void keyPressed(KeyEvent e) {
                System.err.println(e);
                System.err.println( "  "+e.getModifiers() );
            }
            public void keyReleased(KeyEvent e) {
            }
            public void keyTyped(KeyEvent e) {
            }
        } );
    }
    
    /**
     * current completions task
     */
    Runnable completionsRunnable=null;
    DasProgressMonitor completionsMonitor=null;
    JPopupMenu completionsPopupMenu= null;
    
    private void showCompletions() {
        
        final String surl= (String) dataSetSelector.getEditor().getItem();
        if ( surl.contains("?") ) {
            
            if ( completionsRunnable !=null ) {
                System.err.println("cancel existing completion task");
                completionsMonitor.cancel();
                completionsRunnable= null;
            }
            
            completionsMonitor = DasApplication.getDefaultApplication().getMonitorFactory().getMonitor("getting completions", "getting completions by delegate");
            completionsRunnable= new Runnable() {
                public void run() {
                    completionsPopupMenu = new JPopupMenu();
                    
                    String[] completions;
                    try {
                        completions = DataSetURL.getCompletions( surl, completionsMonitor );
                    } catch (Exception ex) {
                        completions = new String[]{ex.getClass().getName(), ex.getMessage()};
                    }
                    
                    for (int i = 0; i < completions.length; i++) {
                        final String comp1 = completions[i];
                        completionsPopupMenu.add(new AbstractAction(completions[i]) {
                            public void actionPerformed(ActionEvent ev) {
                                dataSetSelector.setSelectedItem(comp1);
                            }
                        });
                    }
                    SwingUtilities.invokeLater( new Runnable() {
                        public void run() {
                            completionsPopupMenu.show(dataSetSelector, 0, 0);
                            completionsRunnable= null;
                            
                        }
                    } );
                }
            };
            
            new Thread( completionsRunnable, "completionsThread" ).start();
            
        } else {
            try {
                JPopupMenu popupMenu = new JPopupMenu();
                DasProgressMonitor mon = DasApplication.getDefaultApplication().getMonitorFactory().getMonitor("getting completions", "getting remote listing");
                DataSetURL.URLSplit split= DataSetURL.parse( surl );
                System.err.println(split);
                
                FileSystem fs= FileSystem.create( new URL( split.path ) );
                String prefix= split.file.substring( split.path.length() );
                String surlDir= split.path;
                
                String[] s= fs.listDirectory("/");
                boolean foldCase= Boolean.TRUE.equals( fs.getProperty( fs.PROP_CASE_INSENSITIVE ) );
                if ( foldCase ) prefix= prefix.toLowerCase();
                
                List<String> completions= new ArrayList<String>(s.length);
                for ( int j=0; j<s.length; j++ ) {
                    String scomp= foldCase ? s[j].toLowerCase() : s[j];
                    if ( scomp.startsWith(prefix) ) {
                        if ( s[j].endsWith("contents.html") ) s[j]= s[j].substring(0,s[j].length()-"contents.html".length()); // kludge for dods
                        completions.add(surlDir+s[j]);
                    }
                }
                for (int i = 0; i < completions.size(); i++) {
                    final String comp1 = completions.get(i);
                    popupMenu.add(new AbstractAction(completions.get(i)) {
                        public void actionPerformed(ActionEvent ev) {
                            dataSetSelector.setSelectedItem(comp1);
                        }
                    });
                }
                popupMenu.show(dataSetSelector, 0, 0);
            } catch ( Exception e ) {
                throw new RuntimeException(e);
                // TODO: something smart.
            }
        }
        
    }
    
    private void addCompletionKeys() {
        ActionMap map = dataSetSelector.getActionMap();
        map.put("complete", new AbstractAction("completionsPopup") {
            public void actionPerformed(ActionEvent ev) {
                showCompletions();
            }
        });
        map.put("plot", new AbstractAction("plotUrl") {
            public void actionPerformed(ActionEvent ev) {
                ActionEvent e= new ActionEvent( this, 123, "dataSetSelect" );
                fireActionListenerActionPerformed( e );
            }
        });
        dataSetSelector.setActionMap(map);
        
        InputMap imap = dataSetSelector.getInputMap(dataSetSelector.WHEN_IN_FOCUSED_WINDOW);
        imap.put(KeyStroke.getKeyStroke( KeyEvent.VK_SPACE, InputEvent.CTRL_MASK ), "complete" );
        //imap.put(KeyStroke.getKeyStroke( KeyEvent.VK_ENTER, 0 ), "plot" );
        imap.put(KeyStroke.getKeyStroke( KeyEvent.VK_ENTER, InputEvent.CTRL_MASK ), "plot" );
        imap.put(KeyStroke.getKeyStroke( KeyEvent.VK_P, InputEvent.CTRL_MASK ), "plot" );
        dataSetSelector.setInputMap(dataSetSelector.WHEN_FOCUSED, imap);
        
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        browseButton = new javax.swing.JButton();
        plotItButton = new javax.swing.JButton();
        dataSetSelector = new javax.swing.JComboBox();

        browseButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/virbo/datasource/file.png")));
        browseButton.setToolTipText("browse for resource");
        browseButton.setMargin(new java.awt.Insets(2, 2, 2, 2));
        browseButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                browseButtonActionPerformed(evt);
            }
        });

        plotItButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/virbo/datasource/go.png")));
        plotItButton.setToolTipText("plot this URL");
        plotItButton.setMargin(new java.awt.Insets(0, 0, 0, 0));
        plotItButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                plotItButtonActionPerformed(evt);
            }
        });

        dataSetSelector.setEditable(true);
        dataSetSelector.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "http://cdaweb.gsfc.nasa.gov/cgi-bin/opendap/nph-dods/istp_public/data/genesis/3dl2_gim/2003/genesis_3dl2_gim_20030501_v01.cdf.dds?Proton_Density", "file://C:/iowaCitySales2004-2006.latlong.xls?column=M[1:]", "file://c:/Documents and Settings/jbf/My Documents/xx.d2s", "L:/fun/realEstate/to1960.latlon.xls?column=C[1:]&depend0=H[1:]", "L:/fun/realEstate/to1960.latlon.xls?column=M[1:]&depend0=N[1:]&plane0=C[1:]", "L:/ct/virbo/autoplot/data/610008002FE00410.20060901.das2Stream", "P:/poes/poes_n15_20060212.nc?proton-6_dome_16_MeV", "L:/ct/virbo/autoplot/data/asciiTab.dat", "L:/ct/virbo/autoplot/data/2490lintest90005.dat" }));
        dataSetSelector.setToolTipText("enter data source URL");
        dataSetSelector.setMinimumSize(new java.awt.Dimension(20, 20));
        dataSetSelector.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                dataSetSelectorActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(dataSetSelector, 0, 665, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(plotItButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 23, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(browseButton))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                .add(dataSetSelector, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(plotItButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 25, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(browseButton))
        );
    }// </editor-fold>//GEN-END:initComponents
    
    private void dataSetSelectorActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_dataSetSelectorActionPerformed
        
        
    }//GEN-LAST:event_dataSetSelectorActionPerformed
    
    private void plotItButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_plotItButtonActionPerformed
        ActionEvent e= new ActionEvent( this, 123, "dataSetSelect" );
        fireActionListenerActionPerformed( e );
    }//GEN-LAST:event_plotItButtonActionPerformed
    
    private void browseButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_browseButtonActionPerformed
        String context= (String) dataSetSelector.getSelectedItem() ;
        
        try {
            URL url = Util.newURL( new URL("file://"), context );
            if ( url.getProtocol().equals("file") ) {
                JFileChooser chooser= new JFileChooser(url.getPath());
                int result= chooser.showOpenDialog(this);
                if ( result==JFileChooser.APPROVE_OPTION ) {
                    dataSetSelector.setSelectedItem(chooser.getSelectedFile());
                }
            } else {
                showCompletions();
            }
        } catch ( MalformedURLException e ) {
            DasExceptionHandler.handle(e);
        }
        
    }//GEN-LAST:event_browseButtonActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton browseButton;
    private javax.swing.JComboBox dataSetSelector;
    private javax.swing.JButton plotItButton;
    // End of variables declaration//GEN-END:variables
    
    /**
     * Utility field used by bound properties.
     */
    private java.beans.PropertyChangeSupport propertyChangeSupport =  new java.beans.PropertyChangeSupport(this);
    
    /**
     * Adds a PropertyChangeListener to the listener list.
     * @param l The listener to add.
     */
    public void addPropertyChangeListener(java.beans.PropertyChangeListener l) {
        propertyChangeSupport.addPropertyChangeListener(l);
    }
    
    /**
     * Removes a PropertyChangeListener from the listener list.
     * @param l The listener to remove.
     */
    public void removePropertyChangeListener(java.beans.PropertyChangeListener l) {
        propertyChangeSupport.removePropertyChangeListener(l);
    }
    
    /**
     * Getter for property value.
     * @return Value of property value.
     */
    public String getValue() {
        return (String)this.dataSetSelector.getSelectedItem();
    }
    
    /**
     * Setter for property value.
     * @param value New value of property value.
     */
    public void setValue(String value) {
        String oldValue = getValue();
        this.dataSetSelector.setSelectedItem(value);
        propertyChangeSupport.firePropertyChange("value", oldValue, value);
    }
    
    /**
     * Holds value of property browseTypeExt.
     */
    private String browseTypeExt;
    
    /**
     * Getter for property browseTypeExt.
     * @return Value of property browseTypeExt.
     */
    public String getBrowseTypeExt() {
        return this.browseTypeExt;
    }
    
    /**
     * Setter for property browseTypeExt.
     * @param browseTypeExt New value of property browseTypeExt.
     */
    public void setBrowseTypeExt(String browseTypeExt) {
        String oldBrowseTypeExt = this.browseTypeExt;
        this.browseTypeExt = browseTypeExt;
        propertyChangeSupport.firePropertyChange("browseTypeExt", oldBrowseTypeExt, browseTypeExt);
    }
    
    /**
     * Utility field holding list of ActionListeners.
     */
    private transient java.util.ArrayList actionListenerList;
    
    /**
     * Registers ActionListener to receive events.
     * @param listener The listener to register.
     */
    public synchronized void addActionListener(java.awt.event.ActionListener listener) {
        if (actionListenerList == null ) {
            actionListenerList = new java.util.ArrayList();
        }
        actionListenerList.add(listener);
    }
    
    /**
     * Removes ActionListener from the list of listeners.
     * @param listener The listener to remove.
     */
    public synchronized void removeActionListener(java.awt.event.ActionListener listener) {
        if (actionListenerList != null ) {
            actionListenerList.remove(listener);
        }
    }
    
    /**
     * Notifies all registered listeners about the event.
     *
     * @param event The event to be fired
     */
    private void fireActionListenerActionPerformed( java.awt.event.ActionEvent event ) {
        java.util.ArrayList list;
        synchronized (this) {
            if (actionListenerList == null) return;
            list = (java.util.ArrayList)actionListenerList.clone();
        }
        for (int i = 0; i < list.size(); i++) {
            ((java.awt.event.ActionListener)list.get(i)).actionPerformed(event);
        }
    }
    
    /**
     * Holds value of property recent.
     */
    private List<String> recent;
    
    /**
     * Getter for property recent.
     * @return Value of property recent.
     */
    public List<String> getRecent() {
        return this.recent;
    }
    
    /**
     * Setter for property recent.
     * @param recent New value of property recent.
     */
    public void setRecent(List<String> recent) {
        List<String> oldRecent = this.recent;
        this.recent = recent;
        dataSetSelector.setModel(new DefaultComboBoxModel( recent.toArray()) );
        propertyChangeSupport.firePropertyChange("recent", oldRecent, recent);
    }
    
    
}
