/*
 * DataSource.java
 *
 * Created on March 31, 2007, 7:56 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.virbo.datasource;

import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import javax.swing.tree.TreeModel;
import org.virbo.dataset.DataSet;

/**
 * Like the DataLoader of das2, but provides minimal dataset discovery metadata
 * @author jbf
 */
public interface DataSource {
    
    /**
     * retrieve the dataset.  This allowed to be sub-interactive or batch time scale, and will block until the dataset is produced.  
     */
    DataSet getDataSet( DasProgressMonitor mon ) throws Exception;
    
    /**
     *loading the data is slow, so load the data asynchronously (on a separate thread).  This
     *should return true if getDataSet will take more than 100 milliseconds (interactive time).
     */
    boolean asynchronousLoad();
    
    /**
     * discovery range for the dataset.
     */
    DatumRange getXRange();
    
    /**
     * discovery range for the dataset.
     */
    DatumRange getYRange();
    
    String getLabel();
    
    TreeModel getMetaData() throws Exception ;

    String getURL();
    
    DataSourceFactory getFactory();
     
}
