/*
 * DodsDataSetSource.java
 *
 * Created on April 4, 2007, 9:37 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.virbo.dods;

import dods.dap.AttributeTable;
import dods.dap.DAS;
import dods.dap.DASException;
import dods.dap.DDSException;
import dods.dap.DODSException;
import dods.dap.parser.ParseException;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.tree.TreeModel;
import org.virbo.dataset.DataSet;
import org.virbo.dataset.WritableDataSet;
import org.virbo.datasource.AbstractDataSource;
import org.virbo.datasource.DataSourceFactory;
import org.virbo.metatree.NameValueTreeModel;
import dods.dap.Attribute;
import java.util.HashMap;

/**
 *
 * @author jbf
 */
public class DodsDataSource extends AbstractDataSource {
    
    DodsAdapter adapter;
    String variable;
    String sMyUrl;
    /**
     * null if not specfied in url.
     */
    String constraint;
    
    /**
     * Creates a new instance of DodsDataSetSource
     *
     * http://cdaweb.gsfc.nasa.gov/cgi-bin/opendap/nph-dods/istp_public/data/genesis/3dl2_gim/2003/genesis_3dl2_gim_20030501_v01.cdf.dds?Proton_Density
     * http://www.cdc.noaa.gov/cgi-bin/nph-nc/Datasets/kaplan_sst/sst.mean.anom.nc.dds?sst
     * http://cdaweb.gsfc.nasa.gov/cgi-bin/opendap/nph-dods/istp_public/data/polar/hyd_h0/1997/po_h0_hyd_19970102_v01.cdf.dds?ELECTRON_DIFFERENTIAL_ENERGY_FLUX
     *
     */
    
    public DodsDataSource( URL url ) throws IOException  {
        
        super( url );
        
        parseUrl();
        
        URL myUrl;
        try {
            myUrl = new URL(sMyUrl);
            adapter= new DodsAdapter( myUrl, variable );
            if ( constraint!=null ) adapter.setConstraint( constraint );
        } catch (MalformedURLException ex) {
            throw new RuntimeException( ex );
        }
        
    }
    
    private void parseUrl() {
        // remove the .dds (or .html) extension.
        String surl= url.toString();
        int i= surl.lastIndexOf('.');
        URL myUrl;
        sMyUrl= surl.substring(0, i);
        
        // get the variable
        i= surl.indexOf('?');
        variable= surl.substring( i+1 );
        
        final int ib= variable.indexOf('[');
        if ( ib != -1 ) {
            constraint= "?"+variable;
            variable= variable.substring( 0, ib );
        }
    }
    
    public DataSet getDataSet(DasProgressMonitor mon) throws FileNotFoundException, MalformedURLException, IOException, ParseException, DDSException, DODSException  {
        //if ( sMyUrl.endsWith(".cdf") ) {
        //    SPDFUtil.interpretAttributes( adapter );
        //} else {
        MyDDSParser parser= new MyDDSParser();
        parser.parse( new URL( adapter.getSource().toString()+".dds" ).openStream() );
        
        if ( this.constraint==null ) {
            StringBuffer constraint= new StringBuffer("?");
            constraint.append( adapter.getVariable() );
            if ( ! adapter.getVariable() .contains("[" ) ) {
                int[] ii= parser.getRecDims( adapter.getVariable() );
                for ( int i=0; i<ii.length; i++ ) {
                    constraint.append( "[0:1:"+ii[i]+"]" );
                }
            }
            adapter.setConstraint( constraint.toString() );
        }
        //}
        
        adapter.loadDataset( mon );
        WritableDataSet ds= (WritableDataSet)adapter.getDataSet();
        //ds.putProperty( DataSet.UNITS, null );
        //ds.putProperty( DataSet.DEPEND_0, null );
        return ds;
        
    }
    
    
    
    public boolean asynchronousLoad() {
        return true;
    }
    
    public static DataSourceFactory getFactory() {
        return new DodsDataSourceFactory();
    }
    
    public TreeModel getMetaData() throws IOException, dods.dap.parser.ParseException, DASException {
        MyDASParser parser= new MyDASParser();
        parser.parse( new URL( adapter.getSource().toString()+".das" ).openStream() );
        
        DAS result= parser.getDAS();
        AttributeTable at= result.getAttributeTable( adapter.getVariable() );
        if ( at==null ) {
            return NameValueTreeModel.create( "variable metadata", new HashMap() );
        }
        
        Enumeration n= at.getNames();
        
        ArrayList names= new ArrayList( );
        ArrayList values= new ArrayList();
        
        while ( n.hasMoreElements() ) {
            Object key= n.nextElement();
            Attribute att= at.getAttribute( (String)key );
            names.add( att.getName() );
            values.add( att.getValueAt(0) );
        }
         
        return NameValueTreeModel.create( "variable metadata", names, values );
    }
}
