/*
 * DodsDataSourceFactory.java
 *
 * Created on May 14, 2007, 10:04 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.virbo.dods;

import java.io.IOException;
import java.net.URL;
import org.virbo.datasource.DataSource;
import org.virbo.datasource.DataSourceFactory;

/**
 *
 * @author jbf
 */
public class DodsDataSourceFactory implements DataSourceFactory {
    
    /** Creates a new instance of DodsDataSourceFactory */
    public DodsDataSourceFactory() {
    }
    
    public DataSource getDataSource(URL url) throws IOException {
        return new DodsDataSource( url );
    }
    
    public String[] getCompletions(String surl) {
        
        // cut-n-paste code from DodsDataSource
        // remove the .dds (or .html) extension.
        int i= surl.lastIndexOf('.');
        URL myUrl;
        String sMyUrl= surl.substring(0, i);
        
        // get the variable
        i= surl.indexOf('?');
        String variable= surl.substring( i+1 );
        
        surl= surl.substring(0,i+1);
        
        URL url;
        try {
            url = new URL(sMyUrl + ".dds");
            
            MyDDSParser parser= new MyDDSParser();
            parser.parse( url.openStream() );
            
            String[] vars= parser.getVariableNames();
            for ( int j=0; j<vars.length;j++ ) {
                vars[j]= surl + vars[j];
            }
            return vars;
            
        } catch ( Exception ex) {
            return new String[] { ex.getMessage() };
        }
        
    }
}
