/*
 * NameValueTreeModel.java
 *
 * Created on July 31, 2007, 11:45 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.virbo.metatree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

/**
 *
 * @author jbf
 */
public class NameValueTreeModel implements TreeModel {
    
    final Object root;
    
    List nodes;
    
    static class PropertyNode {
        String name;
        String value;
        boolean hasKids;
        
        PropertyNode( String name, String value ) {
            this.name= name;
            this.value= value;
            this.hasKids= value.length()>50;
        }
        
        public String toString() {
            if ( ! hasKids ) {
                return "" + name + "=" + value;
            } else {
                return "" + name + "=" + value.substring(0,50)+" ...";
            }
        }
        
        public int childCount( ) {
            return hasKids ? value.length() / 50 + 1 : 0;
        }
        
        public Object getChild( int i ) {
            int i0= i * 50;
            int i1= Math.min( (i+1) * 50, value.length() );
            while ( i0>0 && i0<value.length() && !Character.isWhitespace(value.charAt(i0-1)) ) i0++;
            while ( i1<value.length() && !Character.isWhitespace(value.charAt(i1)) )i1++;
            return value.substring( i0, i1 );
        }
        
        public boolean isLeaf() {
            return ! hasKids;
        }
    }
    
    public Object getRoot() {
        return root;
    }
    
    public Object getChild(Object parent, int index) {
        if ( parent==root ) {
            return nodes.get(index);
        } else {
            PropertyNode p= (PropertyNode)parent;
            return p.getChild(index);
        }
    }
    
    public int getChildCount(Object parent) {
        if ( parent==root ) {
            return nodes.size();
        } else {
            PropertyNode p= (PropertyNode)parent;
            return p.childCount();
        }
    }
    
    public boolean isLeaf(Object parent) {
        if ( parent==root ) {
            return false;
        } else if ( parent instanceof PropertyNode ) {
            PropertyNode p= (PropertyNode)parent;
            return p.isLeaf();
        } else {
            return true;
        }
    }
    
    public void valueForPathChanged(TreePath path, Object newValue) {
    }
    
    public int getIndexOfChild(Object parent, Object child) {
        return 0;
    }
    
    public void addTreeModelListener(TreeModelListener l) {
    }
    
    public void removeTreeModelListener(TreeModelListener l) {
    }
    
    
    
    /** Creates a new instance of NameValueTreeModel */
    public NameValueTreeModel( Object root, List nodes ) {
        this.nodes= nodes;
        this.root= root;
    }
    
    public static NameValueTreeModel create( Object root, List names, List values ) {
        ArrayList nodes= new ArrayList( names.size() );
        for ( int i= 0; i<names.size(); i++ ) {
            nodes.add( new PropertyNode( (String)names.get(i), String.valueOf( values.get(i) ) ) );
        }
        return new NameValueTreeModel( root, nodes );
    }
    
    public static NameValueTreeModel create( Object root, Map map ) {
        ArrayList nodes= new ArrayList( map.size() );
        
        for ( Iterator i= map.keySet().iterator(); i.hasNext(); ) {
            Object key= i.next();
            nodes.add( new PropertyNode((String)key, String.valueOf(map.get(key)) ) );
        }
        
        return new NameValueTreeModel( root, nodes );
    }
    
    public String toString() {
        return String.valueOf(this.root)+ "("+nodes.size()+"key/value pairs)";
    }
}
