/*
 * NetCDFDataSource.java
 *
 * Created on April 4, 2007, 7:03 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.virbo.netCDF;

import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.virbo.dataset.DataSet;
import org.virbo.datasource.AbstractDataSource;
import org.virbo.datasource.DataSource;
import org.virbo.datasource.DataSourceFactory;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;

/**
 *
 * @author jbf
 */
public class NetCDFDataSource extends AbstractDataSource {
    
    Variable variable;
    String sMyUrl;
    String svariable;
    
    /** Creates a new instance of NetCDFDataSource */
    public NetCDFDataSource( URL url ) throws IOException {
        super(url);
        System.err.println("URL="+url);
        parseUrl();
        
    }
    
    private void parseUrl() {
        String surl= url.toString();
        int i= surl.lastIndexOf('?');
        URL myUrl;
        sMyUrl= surl.substring(0, i);
        
        // get the variable
        i= surl.indexOf('?');
        svariable= surl.substring( i+1 );
        
    }
    
    public DataSet getDataSet( DasProgressMonitor mon) throws IOException {
        System.err.println(sMyUrl);
        NetcdfFile f= NetcdfFile.open( sMyUrl );
        NetcdfDataset dataset= new NetcdfDataset( f );
        List<Variable> variables= (List<Variable>)dataset.getVariables();
        
        for ( int i=0; i<variables.size(); i++ ) {
            Variable v= variables.get(i);
            if ( v.getName().equals( svariable ) ) {
                variable= v;
            }
        }
        
        return new NetCdfVarDataSet( variable );
    }
    
    public boolean asynchronousLoad() {
        return true;
    }
    
    public static DataSourceFactory getFactory() {
        return new NetCDFDataSourceFactory();
    }
    
}
