/*
 * NetCDFDataSourceFactory.java
 *
 * Created on May 14, 2007, 11:27 AM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.virbo.netCDF;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.virbo.datasource.DataSource;
import org.virbo.datasource.DataSourceFactory;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;

/**
 *
 * @author jbf
 */
public class NetCDFDataSourceFactory implements DataSourceFactory {
    
    /** Creates a new instance of NetCDFDataSourceFactory */
    public NetCDFDataSourceFactory() {
    }
    
    public DataSource getDataSource(URL url) throws IOException {
        return new NetCDFDataSource( url );
    }
    
    public String[] getCompletions(String surl) throws IOException {
        NetcdfFile f= NetcdfFile.open( surl );
        NetcdfDataset dataset= new NetcdfDataset( f );
        List<Variable> variables= (List<Variable>)dataset.getVariables();
        String[] result= new String[ variables.size() ];
        for ( int i=0; i<variables.size(); i++ ) {
            result[i]= surl + "?" + variables.get(i).getName();
        }
        return result;
    }
    
}
