/*
 * NetCdfVarDataSet.java
 *
 * Created on April 4, 2007, 12:22 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.virbo.netCDF;

import edu.uiowa.physics.pw.das.datum.DatumRange;
import edu.uiowa.physics.pw.das.datum.Units;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.virbo.dataset.AbstractDataSet;
import org.virbo.dataset.DataSet;
import org.virbo.dods.SPDFUtil;
import ucar.nc2.Variable;
import ucar.nc2.Attribute;

/**
 * wraps a rank 1 netCDF variable to present it as a DataSet.
 *
 * unit  "matlab datenum" are decimal days. 1 corresponds to 1-Jan-0000.
 *
 * @author jbf
 */
public class NetCdfVarDataSet extends AbstractDataSet {
    Variable v;
    double[] data;
    
    public NetCdfVarDataSet( Variable variable ) throws IOException {
        this.v= variable;
        ucar.ma2.Array a = v.read();
        data= (double[])a.get1DJavaArray( Double.class );
        ucar.nc2.Dimension d= v.getDimension(0);
        List l= d.getCoordinateVariables();
        if ( l.size()>1 ) throw new IllegalArgumentException("Huh?");
        for ( int i=0; i<l.size(); i++ ) {
            Variable dv= (Variable) l.get(0);
            if ( dv!=variable ) {
                DataSet depend0= new NetCdfVarDataSet( dv );
                properties.put( DataSet.DEPEND_0, depend0 );
            }
        }
        
        Map attributes= new HashMap();
        
        List attrs= v.getAttributes();
        for ( Iterator i= attrs.iterator(); i.hasNext(); ) {
            Attribute attr= (Attribute) i.next();
            if ( !attr.isArray() ) {
                if ( attr.isString() ) {
                    attributes.put( attr.getName(), attr.getStringValue() );
                } else {
                    attributes.put( attr.getName(), String.valueOf( attr.getNumericValue() ) );
                }
            }
        }
        
        Map p= SPDFUtil.interpretProps( attributes );
        properties.putAll( p );
        
        DatumRange dr= (DatumRange) properties.get( DataSet.VALID_RANGE );
        if ( dr!=null ) {
            Units u= dr.getUnits();
            double vmin= dr.min().doubleValue(u);
            double vmax= dr.max().doubleValue(u);
            for ( int i=0; i<data.length; i++ ) {
                if ( data[i]<=vmin || data[i]>=vmax ) data[i]= u.getFillDouble();
            }
        }
    }
    
    
    public int rank() {
        return v.getRank();
    }
    
    public double value(int i) {
        return data[i];
    }
    
    public int length() {
        return data.length;
    }
    
    
    
    
}
