/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.client;

import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.TableDataSetBuilder;
import edu.uiowa.physics.pw.das.dataset.VectorDataSetBuilder;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.stream.PacketDescriptor;
import edu.uiowa.physics.pw.das.stream.SkeletonDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamException;
import edu.uiowa.physics.pw.das.stream.StreamHandler;
import edu.uiowa.physics.pw.das.stream.StreamMultiYDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamYScanDescriptor;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import java.util.HashMap;
import java.util.Map;

public class DataSetStreamHandler
implements StreamHandler {
    StreamHandlerDelegate delegate;
    StreamDescriptor sd;
    Map extraProperties;
    DasProgressMonitor monitor;
    static final int ntasks = 100;
    boolean[] taskStarted = new boolean[100];
    Datum start;
    Datum taskWidth;

    public DataSetStreamHandler(Map map, DasProgressMonitor dasProgressMonitor, Datum datum, Datum datum2) {
        int n = 0;
        while (n < this.taskStarted.length) {
            this.taskStarted[n] = false;
            ++n;
        }
        this.extraProperties = new HashMap(map);
    }

    public void packet(PacketDescriptor packetDescriptor, Datum datum, DatumVector[] datumVectorArray) throws StreamException {
        this.ensureNotNullDelegate();
        this.delegate.packet(packetDescriptor, datum, datumVectorArray);
    }

    private void updateMonitor() {
        int n = 0;
        int n2 = 0;
        while (n2 < 100) {
            if (this.taskStarted[n2]) {
                ++n;
            }
            ++n2;
        }
        this.monitor.setTaskProgress(n);
    }

    public void packetDescriptor(PacketDescriptor packetDescriptor) throws StreamException {
        if (this.delegate == null) {
            SkeletonDescriptor skeletonDescriptor = packetDescriptor.getYDescriptor(0);
            if (skeletonDescriptor instanceof StreamMultiYDescriptor) {
                this.delegate = new VectorDataSetStreamHandler(packetDescriptor);
            } else if (skeletonDescriptor instanceof StreamYScanDescriptor) {
                this.delegate = new TableDataSetStreamHandler(packetDescriptor);
            }
        } else {
            this.delegate.packetDescriptor(packetDescriptor);
        }
    }

    public void streamClosed(StreamDescriptor streamDescriptor) throws StreamException {
        if (this.delegate != null) {
            this.delegate.streamClosed(streamDescriptor);
        }
    }

    public void streamDescriptor(StreamDescriptor streamDescriptor) throws StreamException {
        this.sd = streamDescriptor;
    }

    public void streamException(StreamException streamException) throws StreamException {
    }

    public DataSet getDataSet() {
        if (this.delegate == null) {
            return null;
        }
        return this.delegate.getDataSet();
    }

    private void ensureNotNullDelegate() {
        if (this.delegate == null) {
            throw new IllegalStateException("Null delegate");
        }
    }

    private static double getXWithBase(Datum datum, Datum datum2) {
        if (datum == null) {
            return datum2.doubleValue(datum2.getUnits());
        }
        return datum.doubleValue(datum.getUnits()) + datum2.doubleValue(datum.getUnits().getOffsetUnits());
    }

    private class TableDataSetStreamHandler
    implements StreamHandlerDelegate {
        private TableDataSetBuilder builder;

        private TableDataSetStreamHandler(PacketDescriptor packetDescriptor) throws StreamException {
            StreamYScanDescriptor streamYScanDescriptor = (StreamYScanDescriptor)packetDescriptor.getYDescriptor(0);
            Datum datum = packetDescriptor.getXDescriptor().getBase();
            Units units = datum != null ? datum.getUnits() : packetDescriptor.getXDescriptor().getUnits();
            Units units2 = streamYScanDescriptor.getYUnits();
            Units units3 = streamYScanDescriptor.getZUnits();
            this.builder = new TableDataSetBuilder(units, units2, units3);
            this.packetDescriptor(packetDescriptor);
        }

        public void packet(PacketDescriptor packetDescriptor, Datum datum, DatumVector[] datumVectorArray) throws StreamException {
            StreamYScanDescriptor streamYScanDescriptor = (StreamYScanDescriptor)packetDescriptor.getYDescriptor(0);
            Datum datum2 = packetDescriptor.getXDescriptor().getBase();
            Datum datum3 = datum2 == null ? datum : datum2.add(datum);
            DatumVector datumVector = DatumVector.newDatumVector(streamYScanDescriptor.getYTags(), streamYScanDescriptor.getYUnits());
            String[] stringArray = new String[packetDescriptor.getYCount()];
            int n = 0;
            while (n < packetDescriptor.getYCount()) {
                stringArray[n] = ((StreamYScanDescriptor)packetDescriptor.getYDescriptor(n)).getName();
                ++n;
            }
            this.builder.insertYScan(datum3, datumVector, datumVectorArray, stringArray);
        }

        public void packetDescriptor(PacketDescriptor packetDescriptor) throws StreamException {
            StreamYScanDescriptor streamYScanDescriptor = (StreamYScanDescriptor)packetDescriptor.getYDescriptor(0);
            int n = 1;
            while (n < packetDescriptor.getYCount()) {
                streamYScanDescriptor = (StreamYScanDescriptor)packetDescriptor.getYDescriptor(n);
                this.builder.addPlane(streamYScanDescriptor.getName(), streamYScanDescriptor.getZUnits());
                ++n;
            }
        }

        public void streamClosed(StreamDescriptor streamDescriptor) throws StreamException {
        }

        public void streamDescriptor(StreamDescriptor streamDescriptor) throws StreamException {
        }

        public void streamException(StreamException streamException) throws StreamException {
        }

        public DataSet getDataSet() {
            this.builder.addProperties(DataSetStreamHandler.this.sd.getProperties());
            this.builder.addProperties(DataSetStreamHandler.this.extraProperties);
            return this.builder.toTableDataSet();
        }
    }

    private class VectorDataSetStreamHandler
    implements StreamHandlerDelegate {
        private VectorDataSetBuilder builder;
        private double[] doubles = new double[1];

        private VectorDataSetStreamHandler(PacketDescriptor packetDescriptor) throws StreamException {
            StreamMultiYDescriptor streamMultiYDescriptor = (StreamMultiYDescriptor)packetDescriptor.getYDescriptor(0);
            Datum datum = packetDescriptor.getXDescriptor().getBase();
            Units units = datum == null ? packetDescriptor.getXDescriptor().getUnits() : datum.getUnits();
            Units units2 = streamMultiYDescriptor.getUnits();
            this.builder = new VectorDataSetBuilder(units, units2);
            this.packetDescriptor(packetDescriptor);
        }

        public void packet(PacketDescriptor packetDescriptor, Datum datum, DatumVector[] datumVectorArray) throws StreamException {
            Datum datum2 = packetDescriptor.getXDescriptor().getBase();
            double d = DataSetStreamHandler.getXWithBase(datum2, datum);
            int n = 0;
            while (n < packetDescriptor.getYCount()) {
                if (packetDescriptor.getYDescriptor(n) instanceof StreamMultiYDescriptor) {
                    StreamMultiYDescriptor streamMultiYDescriptor = (StreamMultiYDescriptor)packetDescriptor.getYDescriptor(n);
                    double d2 = datumVectorArray[n].doubleValue(0, streamMultiYDescriptor.getUnits());
                    if (n != 0) {
                        this.builder.insertY(d, d2, streamMultiYDescriptor.getName());
                    } else {
                        this.builder.insertY(d, d2);
                    }
                } else {
                    throw new StreamException("Mixed data sets are not currently supported");
                }
                ++n;
            }
        }

        public void packetDescriptor(PacketDescriptor packetDescriptor) throws StreamException {
            int n = 1;
            while (n < packetDescriptor.getYCount()) {
                StreamMultiYDescriptor streamMultiYDescriptor = (StreamMultiYDescriptor)packetDescriptor.getYDescriptor(n);
                this.builder.addPlane(streamMultiYDescriptor.getName(), streamMultiYDescriptor.getUnits());
                ++n;
            }
        }

        public void streamClosed(StreamDescriptor streamDescriptor) throws StreamException {
        }

        public void streamDescriptor(StreamDescriptor streamDescriptor) throws StreamException {
        }

        public void streamException(StreamException streamException) throws StreamException {
        }

        public DataSet getDataSet() {
            this.builder.addProperties(DataSetStreamHandler.this.sd.getProperties());
            this.builder.addProperties(DataSetStreamHandler.this.extraProperties);
            return this.builder.toVectorDataSet();
        }
    }

    private static interface StreamHandlerDelegate
    extends StreamHandler {
        public DataSet getDataSet();
    }
}

