/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.client;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.DasIOException;
import edu.uiowa.physics.pw.das.client.Authenticator;
import edu.uiowa.physics.pw.das.client.DasServer;
import edu.uiowa.physics.pw.das.client.DasServerException;
import edu.uiowa.physics.pw.das.client.Key;
import edu.uiowa.physics.pw.das.client.MeteredInputStream;
import edu.uiowa.physics.pw.das.client.NoSuchDataSetException;
import edu.uiowa.physics.pw.das.client.StandardDataStreamSource;
import edu.uiowa.physics.pw.das.client.StreamDataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.AccessDeniedException;
import edu.uiowa.physics.pw.das.dataset.NoDataInIntervalException;
import edu.uiowa.physics.pw.das.dataset.NoKeyProvidedException;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.format.DatumFormatter;
import edu.uiowa.physics.pw.das.stream.StreamYScanDescriptor;
import edu.uiowa.physics.pw.das.util.DasDie;
import edu.uiowa.physics.pw.das.util.URLBuddy;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;

public class WebStandardDataStreamSource
implements StandardDataStreamSource {
    private DasServer server;
    private MeteredInputStream min;
    private boolean legacyStream = true;
    private String extraParameters;

    public WebStandardDataStreamSource(DasServer dasServer, URL uRL) {
        String[] stringArray;
        this.server = dasServer;
        String[] stringArray2 = stringArray = uRL.getQuery() == null ? new String[]{} : uRL.getQuery().split("&");
        if (stringArray.length >= 2) {
            this.extraParameters = stringArray[1];
        }
    }

    public boolean isLegacyStream() {
        return this.legacyStream;
    }

    public InputStream getInputStream(StreamDataSetDescriptor streamDataSetDescriptor, Datum datum, Datum datum2) throws DasException {
        String string = "dataset";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("server=").append(string);
        InputStream inputStream = this.openURLConnection(streamDataSetDescriptor, datum, datum2, stringBuffer);
        MeteredInputStream meteredInputStream = new MeteredInputStream(inputStream);
        meteredInputStream.setSpeedLimit(3300.0);
        return meteredInputStream;
    }

    public InputStream getReducedInputStream(StreamDataSetDescriptor streamDataSetDescriptor, Datum datum, Datum datum2, Datum datum3) throws DasException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = (String)streamDataSetDescriptor.getProperty("form");
        if ("x_tagged_y_scan".equals(string)) {
            stringBuffer.append("server=compactdataset");
            StreamYScanDescriptor streamYScanDescriptor = (StreamYScanDescriptor)streamDataSetDescriptor.getDefaultPacketDescriptor().getYDescriptors().get(0);
            stringBuffer.append("&nitems=").append(streamYScanDescriptor.getNItems() + 1);
            if (datum3 != null) {
                stringBuffer.append("&resolution=").append(datum3.doubleValue(Units.seconds));
            }
        } else if ("x_multi_y".equals(string) && streamDataSetDescriptor.getProperty("ny") != null) {
            stringBuffer.append("server=dataset");
        } else if ("x_multi_y".equals(string)) {
            stringBuffer.append("server=dataset");
            if (datum3 != null) {
                stringBuffer.append("&interval=").append(datum3.doubleValue(Units.seconds));
            }
        } else {
            stringBuffer.append("server=compactdataset");
            if (datum3 != null) {
                stringBuffer.append("&resolution=").append(datum3.doubleValue(Units.seconds));
            }
        }
        if (this.extraParameters != null) {
            stringBuffer.append("&params=").append(this.extraParameters);
        }
        boolean bl = false;
        if (this.min != null) {
            DasDie.println(DasDie.DEBUG, "last transfer speed (byte/sec)= " + this.min.calcTransmitSpeed());
            DasDie.println(DasDie.DEBUG, "   time to transfer (sec)= " + this.min.calcTransmitTime());
            DasDie.println(DasDie.DEBUG, "   total kbytes transferred= " + this.min.totalBytesTransmitted() / 1024L);
        }
        if (this.min != null && this.min.calcTransmitSpeed() > 30000.0) {
            bl = false;
        }
        if (bl) {
            stringBuffer.append("&compress=true");
        }
        InputStream inputStream = this.openURLConnection(streamDataSetDescriptor, datum, datum2, stringBuffer);
        this.min = new MeteredInputStream(inputStream);
        return this.min;
    }

    private String createFormDataString(String string, Datum datum, Datum datum2, StringBuffer stringBuffer) throws UnsupportedEncodingException {
        DatumFormatter datumFormatter = datum.getUnits().getDatumFormatterFactory().defaultFormatter();
        String string2 = datumFormatter.format(datum);
        String string3 = datumFormatter.format(datum2);
        StringBuffer stringBuffer2 = new StringBuffer("dataset=");
        stringBuffer2.append(URLBuddy.encodeUTF8(string));
        stringBuffer2.append("&start_time=").append(URLBuddy.encodeUTF8(string2));
        stringBuffer2.append("&end_time=").append(URLBuddy.encodeUTF8(string3));
        stringBuffer2.append("&").append(stringBuffer);
        return stringBuffer2.toString();
    }

    protected synchronized InputStream openURLConnection(StreamDataSetDescriptor streamDataSetDescriptor, Datum datum, Datum datum2, StringBuffer stringBuffer) throws DasException {
        String[] stringArray = streamDataSetDescriptor.getDataSetID().split("\\?|\\&");
        String string = stringArray[1];
        try {
            Object object;
            String string2 = this.createFormDataString(string, datum, datum2, stringBuffer);
            if (streamDataSetDescriptor.isRestrictedAccess() && (object = this.server.getKey("")) != null) {
                string2 = string2 + "&key=" + URLEncoder.encode(((Key)object).toString(), "UTF-8");
            }
            object = this.server.getURL(string2);
            DasApplication.getDefaultApplication().getLogger().info(((URL)object).toString());
            URLConnection uRLConnection = ((URL)object).openConnection();
            uRLConnection.connect();
            String string3 = uRLConnection.getContentType();
            if (!string3.equalsIgnoreCase("application/octet-stream")) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
                String string4 = bufferedReader.readLine();
                String string5 = "";
                while (string4 != null) {
                    string5 = string5.concat(string4);
                    string4 = bufferedReader.readLine();
                }
                throw new DasIOException(string5);
            }
            InputStream inputStream = ((URL)object).openStream();
            if (this.isLegacyStream()) {
                return this.processLegacyStream(inputStream);
            }
            throw new UnsupportedOperationException();
        }
        catch (IOException iOException) {
            throw new DasIOException(iOException.getMessage());
        }
    }

    private InputStream processLegacyStream(InputStream inputStream) throws IOException, DasException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        bufferedInputStream.mark(Integer.MAX_VALUE);
        String string = this.readServerResponse(bufferedInputStream);
        if (string.equals("")) {
            return bufferedInputStream;
        }
        if (string.equals("<noDataInInterval/>")) {
            throw new NoDataInIntervalException("no data in interval");
        }
        String string2 = "error";
        if (string.startsWith("<" + string2 + ">")) {
            int n = string.indexOf("</" + string2 + ">");
            String string3 = string.substring(string2.length() + 2, string.length() - (string2.length() + 3));
            DasDie.println("error=" + string3);
            if (string3.equals("<needKey/>")) {
                throw new NoKeyProvidedException("");
            }
            if (string3.equals("<accessDenied/>")) {
                this.server.setKey(null);
                this.server.getKey("");
                throw new AccessDeniedException("");
            }
            if (string3.equals("<invalidKey/>")) {
                throw new NoKeyProvidedException("invalid Key");
            }
            if (string3.equals("<noSuchDataSet/>")) {
                throw new NoSuchDataSetException("");
            }
            throw new DasServerException("Error response from server: " + string3);
        }
        return bufferedInputStream;
    }

    private String readServerResponse(InputStream inputStream) {
        String string;
        block5: {
            byte[] byArray = new byte[4096];
            int n = -1;
            int n2 = 0;
            try {
                int n3 = inputStream.read(byArray, n2, 4096 - n2);
                String string2 = "das2Response";
                if (n3 < string2.length() + 2) {
                    n2 += n3;
                    n3 = inputStream.read(byArray, n2, 4096 - n2);
                }
                if (new String(byArray, 0, 14, "UTF-8").equals("<" + string2 + ">")) {
                    while (new String(byArray, 0, n2, "UTF-8").indexOf("</" + string2 + ">") == -1 && n2 < 4096) {
                        n3 = inputStream.read(byArray, n2 += n3, 4096 - n2);
                    }
                    int n4 = new String(byArray, 0, n2, "UTF-8").indexOf("</" + string2 + ">");
                    string = new String(byArray, 14, n4 - 14);
                    DasDie.println("das2Response=" + string);
                    inputStream.reset();
                    inputStream.skip(string.length() + 2 * string2.length() + 5);
                    break block5;
                }
                inputStream.reset();
                string = "";
            }
            catch (IOException iOException) {
                string = "";
            }
        }
        return string;
    }

    public void reset() {
    }

    public void authenticate(String string) {
        Authenticator authenticator = new Authenticator(this.server, string);
        Key key = authenticator.authenticate();
        if (key != null) {
            this.server.setKey(key);
        }
    }
}

