/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.util.DasDie;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DasAxisSelector
extends JPanel
implements ActionListener {
    private DasAxis axis = null;
    JTextField idStart = null;
    JTextField idStop = null;

    private DasAxisSelector() {
        this.buildComponents();
    }

    private void buildComponents() {
        this.setLayout(new FlowLayout(2));
        this.idStart = new JTextField("");
        this.idStart.setSize(9, 1);
        this.idStart.addActionListener(this);
        this.idStart.setActionCommand("setMinimum");
        this.add(this.idStart);
        this.idStop = new JTextField("");
        this.idStop.setSize(9, 1);
        this.idStop.addActionListener(this);
        this.idStop.setActionCommand("setMaximum");
        this.add(this.idStop);
    }

    public DasAxisSelector(DasAxis dasAxis) {
        this();
        this.axis = dasAxis;
        this.update();
    }

    public double getStartTime() {
        double d = Double.valueOf(this.idStart.getText());
        return d;
    }

    public double getEndTime() {
        double d = Double.valueOf(this.idStop.getText());
        return d;
    }

    private void update() {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(2);
        this.idStart.setText(decimalFormat.format(this.axis.getDataMinimum()));
        this.idStop.setText(decimalFormat.format(this.axis.getDataMaximum()));
        this.idStart.setText("" + this.axis.getDataMinimum());
        this.idStop.setText("" + this.axis.getDataMaximum());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block5: {
            String string;
            block4: {
                string = actionEvent.getActionCommand();
                this.update();
                if (!string.equals("setMinimum")) break block4;
                try {
                    this.axis.setDataRange(Datum.create(Double.valueOf(this.idStart.getText()), this.axis.getUnits()), this.axis.getDataMaximum());
                }
                catch (NumberFormatException numberFormatException) {
                    DasDie.println(numberFormatException);
                }
                break block5;
            }
            if (!string.equals("setMaximum")) break block5;
            try {
                this.axis.setDataRange(this.axis.getDataMinimum(), Datum.create(Double.valueOf(this.idStop.getText()), this.axis.getUnits()));
            }
            catch (NumberFormatException numberFormatException) {
                DasDie.println(numberFormatException);
            }
        }
    }
}

