/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.TimeUtil;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.event.TimeRangeSelectionEvent;
import edu.uiowa.physics.pw.das.event.TimeRangeSelectionListener;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.EventListenerList;

public class DasTimeRangeSelector
extends JPanel
implements ActionListener,
TimeRangeSelectionListener {
    private Datum startTime = null;
    private Datum endTime = null;
    JTextField idStart = null;
    JTextField idStop = null;
    private EventListenerList listenerList = null;
    TimeRangeSelectionEvent lastEventProcessed = null;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener;

    public DasTimeRangeSelector() {
        this.buildComponents();
    }

    private void buildComponents() {
        this.setLayout(new FlowLayout());
        JButton jButton = new JButton("<<");
        jButton.addActionListener(this);
        jButton.setActionCommand("previous");
        jButton.setToolTipText("Scan back in time");
        this.add(jButton);
        this.idStart = new JTextField(18);
        this.idStart.addActionListener(this);
        this.idStart.setActionCommand("startTime");
        this.add(this.idStart);
        this.idStop = new JTextField(18);
        this.idStop.addActionListener(this);
        this.idStop.setActionCommand("endTime");
        this.add(this.idStop);
        jButton = new JButton(">>");
        jButton.addActionListener(this);
        jButton.setActionCommand("next");
        jButton.setToolTipText("Scan forward in time");
        this.add(jButton);
    }

    public DasTimeRangeSelector(Datum datum, Datum datum2) {
        this();
        this.setStartTime(datum);
        this.update();
        this.setEndTime(datum2);
        this.update();
    }

    public Datum getStartTime() {
        Datum datum;
        block2: {
            Datum datum2 = this.startTime;
            try {
                datum = TimeUtil.create(this.idStart.getText());
            }
            catch (ParseException parseException) {
                datum = datum2;
                if (datum2 == null) break block2;
                DasExceptionHandler.handle(parseException);
            }
        }
        return datum;
    }

    public Datum getEndTime() {
        Datum datum;
        block2: {
            Datum datum2 = this.endTime;
            try {
                datum = TimeUtil.create(this.idStop.getText());
            }
            catch (ParseException parseException) {
                datum = datum2;
                if (datum2 == null) break block2;
                DasExceptionHandler.handle(parseException);
            }
        }
        return datum;
    }

    private void update() {
        if (this.startTime != null) {
            this.idStart.setText(this.startTime.toString());
        }
        if (this.endTime != null) {
            this.idStop.setText(this.endTime.toString());
        }
    }

    public void setStartTime(Datum datum) {
        this.startTime = datum;
        this.endTime = this.getEndTime();
        if (this.endTime != null && this.startTime.compareTo(this.endTime) == 1) {
            this.endTime = this.startTime.add(1.0, Units.seconds);
        }
        this.update();
    }

    public void setEndTime(Datum datum) {
        this.endTime = datum;
        this.startTime = this.getStartTime();
        if (this.startTime != null && this.startTime.compareTo(this.endTime) == 1) {
            this.startTime = this.endTime.subtract(1.0, Units.seconds);
        }
        this.update();
    }

    public boolean isWithin(Datum datum, Datum datum2) {
        Datum datum3 = this.getStartTime();
        Datum datum4 = this.getEndTime();
        return datum.compareTo(datum3) <= 0 && datum4.compareTo(datum2) <= 0;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("previous")) {
            Datum datum = this.getEndTime().subtract(this.getStartTime());
            this.setStartTime(this.getStartTime().subtract(datum));
            this.setEndTime(this.getEndTime().subtract(datum));
            this.fireTimeRangeSelectionListenerTimeRangeSelected(new TimeRangeSelectionEvent(this, this.startTime, this.endTime));
        } else if (string.equals("next")) {
            Datum datum = this.getEndTime().subtract(this.getStartTime());
            this.setStartTime(this.getStartTime().add(datum));
            this.setEndTime(this.getEndTime().add(datum));
            this.fireTimeRangeSelectionListenerTimeRangeSelected(new TimeRangeSelectionEvent(this, this.startTime, this.endTime));
        } else if (string.equals("startTime")) {
            this.setStartTime(this.getStartTime());
            this.fireTimeRangeSelectionListenerTimeRangeSelected(new TimeRangeSelectionEvent(this, this.startTime, this.endTime));
        } else if (string.equals("endTime")) {
            this.setEndTime(this.getEndTime());
            this.fireTimeRangeSelectionListenerTimeRangeSelected(new TimeRangeSelectionEvent(this, this.startTime, this.endTime));
        }
    }

    public void TimeRangeSelected(TimeRangeSelectionEvent timeRangeSelectionEvent) {
        if (!timeRangeSelectionEvent.equals(this.lastEventProcessed)) {
            this.lastEventProcessed = timeRangeSelectionEvent;
            this.setStartTime(timeRangeSelectionEvent.getStartTime());
            this.setEndTime(timeRangeSelectionEvent.getEndTime());
            this.fireTimeRangeSelectionListenerTimeRangeSelected(timeRangeSelectionEvent);
        }
    }

    public synchronized void addTimeRangeSelectionListener(TimeRangeSelectionListener timeRangeSelectionListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener == null ? (class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener = DasTimeRangeSelector.class$("edu.uiowa.physics.pw.das.event.TimeRangeSelectionListener")) : class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener, timeRangeSelectionListener);
    }

    public synchronized void removeTimeRangeSelectionListener(TimeRangeSelectionListener timeRangeSelectionListener) {
        this.listenerList.remove(class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener == null ? (class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener = DasTimeRangeSelector.class$("edu.uiowa.physics.pw.das.event.TimeRangeSelectionListener")) : class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener, timeRangeSelectionListener);
    }

    private void fireTimeRangeSelectionListenerTimeRangeSelected(TimeRangeSelectionEvent timeRangeSelectionEvent) {
        if (this.listenerList == null) {
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener == null ? DasTimeRangeSelector.class$("edu.uiowa.physics.pw.das.event.TimeRangeSelectionListener") : class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener)) {
                ((TimeRangeSelectionListener)objectArray[n + 1]).TimeRangeSelected(timeRangeSelectionEvent);
            }
            n -= 2;
        }
    }

    public Dimension getMaximumSize() {
        return super.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return super.getPreferredSize();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

