/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components;

import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.DasProperties;
import edu.uiowa.physics.pw.das.components.DataPointReporter;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DataSetUpdateEvent;
import edu.uiowa.physics.pw.das.dataset.VectorDataSetBuilder;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumUtil;
import edu.uiowa.physics.pw.das.datum.TimeLocationUnits;
import edu.uiowa.physics.pw.das.datum.TimeUtil;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.format.DatumFormatter;
import edu.uiowa.physics.pw.das.datum.format.TimeDatumFormatterFactory;
import edu.uiowa.physics.pw.das.event.CommentDataPointSelectionEvent;
import edu.uiowa.physics.pw.das.event.DataPointSelectionEvent;
import edu.uiowa.physics.pw.das.event.DataPointSelectionListener;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class DataPointRecorder
extends JPanel
implements DataPointSelectionListener {
    protected JTable textArea;
    protected JScrollPane scrollPane;
    protected DataPointReporter reporter;
    protected ArrayList dataPoints = new ArrayList();
    protected Units[] unitsArray;
    protected DatumFormatter[] formatterArray;
    protected AbstractTableModel myTableModel = new MyTableModel();
    private MyDataSetDescriptor dataSetDescriptor;

    public void deleteRow(int n) {
        this.dataPoints.remove(n);
        this.update();
    }

    public DataSetDescriptor getDataSetDescriptor() {
        if (this.dataSetDescriptor == null) {
            this.dataSetDescriptor = new MyDataSetDescriptor();
        }
        return this.dataSetDescriptor;
    }

    public void saveToFile(File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
        int n = 0;
        while (n < this.dataPoints.size()) {
            DataPoint dataPoint = (DataPoint)this.dataPoints.get(n);
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < this.unitsArray.length) {
                stringBuffer.append(this.formatterArray[n2].format(Datum.create(dataPoint.get(n2), this.unitsArray[n2])) + "\t");
                ++n2;
            }
            stringBuffer.append("\"" + dataPoint.getComment() + "\"");
            bufferedWriter.write(stringBuffer.toString());
            bufferedWriter.newLine();
            DasProperties.getInstance().put("components.DataPointRecorder.lastFileSave", file.toString());
            ++n;
        }
        bufferedWriter.close();
    }

    public void loadFromFile(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        this.dataPoints.clear();
        String string = bufferedReader.readLine();
        while (string != null) {
            String[] stringArray = string.split("\t");
            int n = 0;
            while (n < stringArray.length - 1) {
                Serializable serializable;
                Datum datum = TimeUtil.isValidTime(stringArray[0]) ? TimeUtil.createValid(stringArray[0]) : DatumUtil.createValid(stringArray[0]);
                Datum datum2 = TimeUtil.isValidTime(stringArray[1]) ? TimeUtil.createValid(stringArray[1]) : DatumUtil.createValid(stringArray[1]);
                String string2 = "";
                if (stringArray.length > 2) {
                    string2 = stringArray[2];
                    serializable = Pattern.compile("\"(.*)\".*");
                    Matcher matcher = serializable.matcher(string2);
                    if (matcher.matches()) {
                        string2 = matcher.group(1);
                    }
                }
                serializable = string2.equals("") ? new DataPointSelectionEvent(this, datum, datum2) : CommentDataPointSelectionEvent.create(new DataPointSelectionEvent(this, datum, datum2), string2);
                this.DataPointSelected((DataPointSelectionEvent)serializable);
                ++n;
            }
            string = bufferedReader.readLine();
        }
        DasProperties.getInstance().put("components.DataPointRecorder.lastFileLoad", file.toString());
    }

    public DataPointRecorder() {
        this.setLayout(new BorderLayout());
        this.textArea = new JTable(this.myTableModel);
        this.textArea.addMouseListener(new MyMouseAdapter(this.textArea));
        this.scrollPane = new JScrollPane(this.textArea);
        this.add((Component)this.scrollPane, "Center");
        final JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JButton jButton = new JButton("Save...");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                block4: {
                    int n;
                    JFileChooser jFileChooser = new JFileChooser();
                    String string = (String)DasProperties.getInstance().get("components.DataPointRecorder.lastFileSave");
                    if (string == null) {
                        string = "";
                    }
                    File file = null;
                    if (string != "") {
                        file = new File(string);
                        jFileChooser.setSelectedFile(file);
                    }
                    if ((n = jFileChooser.showSaveDialog(jPanel)) != 0) break block4;
                    try {
                        DataPointRecorder.this.saveToFile(jFileChooser.getSelectedFile());
                    }
                    catch (IOException iOException) {
                        DasExceptionHandler.handle(iOException);
                    }
                }
            }
        });
        JButton jButton2 = new JButton("Load...");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                block4: {
                    int n;
                    JFileChooser jFileChooser = new JFileChooser();
                    String string = (String)DasProperties.getInstance().get("components.DataPointRecorder.lastFileLoad");
                    if (string == null) {
                        string = "";
                    }
                    File file = null;
                    if (string != "") {
                        file = new File(string);
                        jFileChooser.setSelectedFile(file);
                    }
                    if ((n = jFileChooser.showOpenDialog(jPanel)) != 0) break block4;
                    try {
                        DataPointRecorder.this.loadFromFile(jFileChooser.getSelectedFile());
                    }
                    catch (IOException iOException) {
                        DasExceptionHandler.handle(iOException);
                    }
                }
            }
        });
        jPanel.add(jButton);
        jPanel.add(jButton2);
        JButton jButton3 = new JButton("Update");
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DataPointRecorder.this.dataSetDescriptor != null) {
                    DataPointRecorder.this.dataSetDescriptor.fireUpdate();
                }
            }
        });
        jPanel.add(jButton3);
        this.add((Component)jPanel, "South");
    }

    public static DataPointRecorder createFramed() {
        JFrame jFrame = new JFrame("Data Point Recorder");
        DataPointRecorder dataPointRecorder = new DataPointRecorder();
        jFrame.getContentPane().add(dataPointRecorder);
        jFrame.pack();
        jFrame.setVisible(true);
        jFrame.setDefaultCloseOperation(2);
        return dataPointRecorder;
    }

    public static void main(String[] stringArray) {
        DataPointRecorder dataPointRecorder = DataPointRecorder.createFramed();
        dataPointRecorder.DataPointSelected(new DataPointSelectionEvent(dataPointRecorder, Datum.create(2), Datum.create(6)));
        dataPointRecorder.DataPointSelected(new DataPointSelectionEvent(dataPointRecorder, Datum.create(4), Datum.create(7)));
        dataPointRecorder.DataPointSelected(new DataPointSelectionEvent(dataPointRecorder, Datum.create(1), Datum.create(72)));
    }

    protected void update() {
        this.myTableModel.fireTableDataChanged();
        JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
        if (jScrollBar != null) {
            jScrollBar.setValue(jScrollBar.getMaximum());
        }
    }

    public void DataPointSelected(DataPointSelectionEvent dataPointSelectionEvent) {
        Datum[] datumArray;
        if (this.dataPoints.size() == 0) {
            datumArray = new Datum[]{dataPointSelectionEvent.getX(), dataPointSelectionEvent.getY()};
            this.unitsArray = new Units[]{dataPointSelectionEvent.getX().getUnits(), dataPointSelectionEvent.getY().getUnits()};
            this.formatterArray = new DatumFormatter[]{dataPointSelectionEvent.getX().getFormatter(), dataPointSelectionEvent.getY().getFormatter()};
            int n = 0;
            while (n < this.unitsArray.length) {
                if (this.unitsArray[n] instanceof TimeLocationUnits) {
                    this.formatterArray[n] = TimeDatumFormatterFactory.getInstance().defaultFormatter();
                }
                ++n;
            }
            this.myTableModel.fireTableStructureChanged();
        }
        datumArray = "";
        if (dataPointSelectionEvent instanceof CommentDataPointSelectionEvent) {
            datumArray = ((CommentDataPointSelectionEvent)dataPointSelectionEvent).getComment();
        }
        this.dataPoints.add(new DataPoint(dataPointSelectionEvent.getX().doubleValue(this.unitsArray[0]), dataPointSelectionEvent.getY().doubleValue(this.unitsArray[1]), (String)datumArray));
        this.update();
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        JPopupMenu popup;
        final JTable parent;
        MouseAdapter mm;

        MyMouseAdapter(final JTable jTable) {
            this.parent = jTable;
            this.popup = new JPopupMenu("Options");
            this.popup.addSeparator();
            JMenuItem jMenuItem = new JMenuItem("Delete Row");
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int[] nArray = jTable.getSelectedRows();
                    int n = 0;
                    while (n < nArray.length) {
                        DataPointRecorder.this.deleteRow(nArray[n]);
                        int n2 = n + 1;
                        while (n2 < nArray.length) {
                            int n3 = n2++;
                            nArray[n3] = nArray[n3] - 1;
                        }
                        ++n;
                    }
                }
            });
            this.popup.add(jMenuItem);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 3) {
                this.popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    class MyDataSetDescriptor
    extends DataSetDescriptor {
        MyDataSetDescriptor() {
            super(null);
        }

        public void fireUpdate() {
            this.fireDataSetUpdateEvent(new DataSetUpdateEvent(this));
        }

        protected DataSet getDataSetImpl(Datum datum, Datum datum2, Datum datum3, DasProgressMonitor dasProgressMonitor) throws DasException {
            if (DataPointRecorder.this.dataPoints.size() == 0) {
                return null;
            }
            VectorDataSetBuilder vectorDataSetBuilder = new VectorDataSetBuilder(DataPointRecorder.this.unitsArray[0], DataPointRecorder.this.unitsArray[1]);
            int n = 0;
            while (n < DataPointRecorder.this.dataPoints.size()) {
                DataPoint dataPoint = (DataPoint)DataPointRecorder.this.dataPoints.get(n);
                vectorDataSetBuilder.insertY(dataPoint.get(0), dataPoint.get(1));
                ++n;
            }
            return vectorDataSetBuilder.toVectorDataSet();
        }

        public Units getXUnits() {
            return DataPointRecorder.this.unitsArray[0];
        }
    }

    private class MyTableModel
    extends AbstractTableModel {
        private MyTableModel() {
        }

        public int getColumnCount() {
            if (DataPointRecorder.this.unitsArray == null) {
                return 3;
            }
            return DataPointRecorder.this.unitsArray.length + 1;
        }

        public String getColumnName(int n) {
            if (n + 1 == this.getColumnCount()) {
                return "comment";
            }
            if (DataPointRecorder.this.unitsArray != null) {
                Units units = DataPointRecorder.this.unitsArray[n];
                if (units instanceof TimeLocationUnits) {
                    return ((TimeLocationUnits)units).getTimeZone();
                }
                return DataPointRecorder.this.unitsArray[n].toString();
            }
            return "" + n;
        }

        public int getRowCount() {
            int n = DataPointRecorder.this.dataPoints.size();
            n = n > 0 ? n : 1;
            return DataPointRecorder.this.dataPoints.size();
        }

        public Object getValueAt(int n, int n2) {
            DataPoint dataPoint = (DataPoint)DataPointRecorder.this.dataPoints.get(n);
            if (n2 < dataPoint.data.length) {
                return DataPointRecorder.this.formatterArray[n2].format(Datum.create(dataPoint.get(n2), DataPointRecorder.this.unitsArray[n2]));
            }
            return dataPoint.getComment();
        }
    }

    protected class DataPoint {
        double[] data;
        String comment;

        public DataPoint(double d, double d2, String string) {
            this(new double[]{d, d2}, string);
        }

        public DataPoint(double[] dArray, String string) {
            this.data = dArray;
            this.comment = string;
        }

        double get(int n) {
            return this.data[n];
        }

        String getComment() {
            return this.comment;
        }

        public String toString() {
            return "" + this.data[0] + " " + this.data[1] + (this.comment.equals("") ? "" : " # " + this.comment);
        }
    }
}

