/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components;

import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.DasIOException;
import edu.uiowa.physics.pw.das.client.DasServer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DataSetBrowser
extends JPanel
implements DragSourceListener,
DragGestureListener {
    DasServer dasServer;
    JTree tree;
    TreeModel dataSetListTreeModel;

    public DataSetBrowser(DasServer dasServer) {
        this.dasServer = dasServer;
        try {
            this.dataSetListTreeModel = dasServer.getDataSetList();
        }
        catch (DasIOException dasIOException) {
            System.out.println(dasIOException);
        }
        catch (DasException dasException) {
            System.out.println(dasException);
        }
        this.setLayout(new BorderLayout());
        this.tree = new JTree(this.dataSetListTreeModel);
        DragSource dragSource = DragSource.getDefaultDragSource();
        DragGestureRecognizer dragGestureRecognizer = dragSource.createDefaultDragGestureRecognizer(this.tree, 3, this);
        this.add((Component)new JScrollPane(this.tree), "Center");
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add(new DataSetBrowser(DasServer.plasmaWaveGroup));
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        TreePath treePath = this.tree.getLeadSelectionPath();
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        if (treeNode.isLeaf()) {
            String string = this.dasServer.getURL() + "?" + treePath.getPathComponent(1);
            int n = 2;
            while (n < treePath.getPathCount()) {
                string = string + "/" + treePath.getPathComponent(n);
                ++n;
            }
            StringSelection stringSelection = new StringSelection(string);
            dragGestureEvent.startDrag(null, stringSelection, this);
        }
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }
}

