/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components;

import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DataSetUtil;
import edu.uiowa.physics.pw.das.dataset.DefaultVectorDataSet;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.TableUtil;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.TimeLocationUnits;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.format.DatumFormatter;
import edu.uiowa.physics.pw.das.datum.format.TimeDatumFormatter;
import edu.uiowa.physics.pw.das.event.DataPointSelectionEvent;
import edu.uiowa.physics.pw.das.event.DataPointSelectionListener;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasColorBar;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.graph.Psym;
import edu.uiowa.physics.pw.das.graph.PsymConnector;
import edu.uiowa.physics.pw.das.graph.SpectrogramRenderer;
import edu.uiowa.physics.pw.das.graph.SymbolLineRenderer;
import edu.uiowa.physics.pw.das.util.DasMath;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class HistogramSlicer
extends DasPlot
implements DataPointSelectionListener {
    private JDialog popupWindow;
    private Datum xValue;
    private SpectrogramRenderer renderer;

    private HistogramSlicer(SpectrogramRenderer spectrogramRenderer, DasAxis dasAxis, DasAxis dasAxis2) {
        super(dasAxis, dasAxis2);
        this.renderer = spectrogramRenderer;
        SymbolLineRenderer symbolLineRenderer = new SymbolLineRenderer((DataSetDescriptor)null);
        symbolLineRenderer.setPsymConnector(PsymConnector.PSYM10);
        symbolLineRenderer.setLineWidth(1.0f);
        symbolLineRenderer.setPsym(Psym.CROSS);
        this.addRenderer(symbolLineRenderer);
    }

    public static HistogramSlicer createSlicer(SpectrogramRenderer spectrogramRenderer) {
        DasColorBar dasColorBar = spectrogramRenderer.getColorBar();
        DasAxis dasAxis = new DasAxis(dasColorBar.getDataMinimum(), dasColorBar.getDataMaximum(), 2, dasColorBar.isLog());
        DasAxis dasAxis2 = new DasAxis(Datum.create(0.0), Datum.create(1.0), 3);
        return new HistogramSlicer(spectrogramRenderer, dasAxis, dasAxis2);
    }

    public void showPopup() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.showPopupImpl();
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    HistogramSlicer.this.showPopupImpl();
                }
            };
        }
    }

    private void showPopupImpl() {
        if (this.popupWindow == null) {
            this.createPopup();
        }
        this.popupWindow.setVisible(true);
    }

    private void createPopup() {
        int n = this.renderer.getParent().getCanvas().getWidth() / 2;
        int n2 = this.renderer.getParent().getCanvas().getHeight() / 2;
        DasCanvas dasCanvas = new DasCanvas(n, n2);
        DasRow dasRow = new DasRow(dasCanvas, 0.1, 0.9);
        DasColumn dasColumn = new DasColumn(dasCanvas, 0.1, 0.9);
        dasCanvas.add(this, dasRow, dasColumn);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        BoxLayout boxLayout = new BoxLayout(jPanel2, 0);
        JButton jButton = new JButton("Hide Window");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HistogramSlicer.this.popupWindow.setVisible(false);
            }
        });
        jPanel2.setLayout(boxLayout);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(jButton);
        jPanel.add((Component)dasCanvas, "Center");
        jPanel.add((Component)jPanel2, "South");
        Window window = SwingUtilities.getWindowAncestor(this.renderer.getParent());
        this.popupWindow = window instanceof Frame ? new JDialog((Frame)window) : (window instanceof Dialog ? new JDialog((Dialog)window) : new JDialog());
        this.popupWindow.setTitle("Histogram Slicer");
        this.popupWindow.setDefaultCloseOperation(2);
        this.popupWindow.setContentPane(jPanel);
        this.popupWindow.pack();
        Point point = new Point();
        SwingUtilities.convertPointToScreen(point, this.renderer.getParent().getCanvas());
        this.popupWindow.setLocation(point.x + this.renderer.getParent().getCanvas().getWidth(), point.y + n2);
    }

    public void DataPointSelected(DataPointSelectionEvent dataPointSelectionEvent) {
        DataSet dataSet = dataPointSelectionEvent.getDataSet();
        if (dataSet == null || !(dataSet instanceof TableDataSet)) {
            return;
        }
        Datum datum = dataPointSelectionEvent.getY();
        this.xValue = dataPointSelectionEvent.getX();
        TableDataSet tableDataSet = (TableDataSet)dataSet;
        int n = TableUtil.tableIndexAt(tableDataSet, DataSetUtil.closestColumn(tableDataSet, dataPointSelectionEvent.getX()));
        VectorDataSet vectorDataSet = tableDataSet.getYSlice(TableUtil.closestRow(tableDataSet, n, dataPointSelectionEvent.getY()), n);
        DasColorBar dasColorBar = this.renderer.getColorBar();
        DasAxis dasAxis = this.getXAxis();
        if (!dasAxis.getUnits().equals(dasColorBar.getUnits())) {
            dasAxis.setUnits(dasColorBar.getUnits());
            dasAxis.setDataRange(dasColorBar.getDataMinimum(), dasColorBar.getDataMaximum());
            dasAxis.setLog(dasColorBar.isLog());
        }
        VectorDataSet vectorDataSet2 = this.getHistogram(vectorDataSet);
        this.getRenderer(0).setDataSet(vectorDataSet2);
        if (this.xValue.getUnits() instanceof TimeLocationUnits) {
            TimeDatumFormatter timeDatumFormatter = TimeDatumFormatter.DEFAULT;
        } else {
            DatumFormatter datumFormatter = this.xValue.getFormatter();
        }
        if (this.popupWindow != null && !this.popupWindow.isVisible() || this.getCanvas() == null) {
            this.showPopup();
        } else {
            this.repaint();
        }
    }

    public VectorDataSet getHistogram(VectorDataSet vectorDataSet) {
        DasColorBar dasColorBar = this.renderer.getColorBar();
        Units units = dasColorBar.getUnits();
        double d = this.getXAxis().getDataMinimum(units);
        double d2 = this.getXAxis().getDataMaximum(units);
        int n = vectorDataSet.getXLength();
        if (dasColorBar.isLog()) {
            double d3 = Math.floor(DasMath.log10(d));
            double d4 = Math.ceil(DasMath.log10(d2));
            int n2 = (int)(d4 - d3) * 8;
            double[] dArray = new double[n2];
            int n3 = 0;
            while (n3 < vectorDataSet.getXLength()) {
                double d5 = vectorDataSet.getDouble(n3, units);
                if (units.isFill(d5) || Double.isNaN(d5)) {
                    --n;
                } else {
                    double[] dArray2;
                    int n4;
                    double d6 = DasMath.log10(d5);
                    if (d6 < d3) {
                        double d7 = Math.floor(d6);
                        n4 = (int)Math.floor(d3 - d7) * 8;
                        dArray2 = new double[n2 += n4];
                        System.arraycopy(dArray, 0, dArray2, n4, dArray.length);
                        d3 = d7;
                        dArray = dArray2;
                    } else if (d6 >= d4) {
                        double d8 = Math.ceil(d6 + 0.001);
                        n4 = (int)(d8 - d4) * 8;
                        dArray2 = new double[n2 += n4];
                        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
                        d4 = d8;
                        dArray = dArray2;
                    }
                    int n5 = (int)Math.floor((d6 - d3) * 8.0);
                    if (n5 >= 0 && n5 < dArray.length) {
                        int n6 = n5;
                        dArray[n6] = dArray[n6] + 1.0;
                    }
                }
                ++n3;
            }
            double[] dArray3 = new double[n2];
            int n7 = 0;
            while (n7 < n2) {
                dArray3[n7] = DasMath.exp10(d3 + (double)n7 / 8.0);
                dArray[n7] = dArray[n7] / (double)n;
                ++n7;
            }
            return new DefaultVectorDataSet(dArray3, units, dArray, Units.dimensionless, Collections.EMPTY_MAP);
        }
        d = Math.floor(d);
        d2 = Math.ceil(d2);
        int n8 = (int)(d2 - d);
        double[] dArray = new double[n8];
        int n9 = 0;
        while (n9 < vectorDataSet.getXLength()) {
            double d9 = vectorDataSet.getDouble(n9, units);
            if (units.isFill(d9) || Double.isNaN(d9)) {
                --n;
            } else {
                double[] dArray4;
                int n10;
                if (d9 < d) {
                    double d10 = Math.floor(d9);
                    n10 = (int)(d - d10);
                    dArray4 = new double[n8 += n10];
                    System.arraycopy(dArray, 0, dArray4, n10, dArray.length);
                    d = d10;
                    dArray = dArray4;
                } else if (d9 >= d2) {
                    double d11 = Math.ceil(d9 + 0.001);
                    n10 = (int)(d11 - d2);
                    dArray4 = new double[n8 += n10];
                    System.arraycopy(dArray, 0, dArray4, 0, dArray.length);
                    d2 = d11;
                    dArray = dArray4;
                }
                int n11 = (int)Math.floor(d9 - d);
                if (n11 >= 0 && n11 < dArray.length) {
                    int n12 = n11;
                    dArray[n12] = dArray[n12] + 1.0;
                }
            }
            ++n9;
        }
        double[] dArray5 = new double[n8];
        int n13 = 0;
        while (n13 < n8) {
            dArray5[n13] = d + (double)n13 + 0.5;
            dArray[n13] = dArray[n13] / (double)n;
            ++n13;
        }
        return new DefaultVectorDataSet(dArray5, units, dArray, Units.dimensionless, Collections.EMPTY_MAP);
    }

    protected void uninstallComponent() {
        super.uninstallComponent();
    }

    protected void installComponent() {
        super.installComponent();
    }
}

