/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components;

import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DataSetUtil;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.TableDataSetConsumer;
import edu.uiowa.physics.pw.das.dataset.TableUtil;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.TimeLocationUnits;
import edu.uiowa.physics.pw.das.datum.format.DatumFormatter;
import edu.uiowa.physics.pw.das.datum.format.TimeDatumFormatter;
import edu.uiowa.physics.pw.das.event.DasUpdateEvent;
import edu.uiowa.physics.pw.das.event.DataPointSelectionEvent;
import edu.uiowa.physics.pw.das.event.DataPointSelectionListener;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.graph.SymbolLineRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class HorizontalSpectrogramSlicer
extends DasPlot
implements DataPointSelectionListener {
    private JDialog popupWindow;
    private Datum xValue;
    private SymbolLineRenderer renderer;
    private DasPlot parentPlot;

    private HorizontalSpectrogramSlicer(DasPlot dasPlot, DasAxis dasAxis, DasAxis dasAxis2) {
        super(dasAxis, dasAxis2);
        this.parentPlot = dasPlot;
        this.renderer = new SymbolLineRenderer((DataSetDescriptor)null);
        this.addRenderer(this.renderer);
    }

    public static HorizontalSpectrogramSlicer createSlicer(DasPlot dasPlot, TableDataSetConsumer tableDataSetConsumer) {
        DasAxis dasAxis = dasPlot.getXAxis();
        DasAxis dasAxis2 = dasAxis.createAttachedAxis(2);
        DasAxis dasAxis3 = tableDataSetConsumer.getZAxis().createAttachedAxis(3);
        return new HorizontalSpectrogramSlicer(dasPlot, dasAxis2, dasAxis3);
    }

    public void showPopup() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.showPopupImpl();
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    HorizontalSpectrogramSlicer.this.showPopupImpl();
                }
            };
        }
    }

    private void showPopupImpl() {
        if (this.popupWindow == null) {
            this.createPopup();
        }
        this.popupWindow.setVisible(true);
    }

    private void createPopup() {
        int n = this.parentPlot.getCanvas().getWidth() / 2;
        int n2 = this.parentPlot.getCanvas().getHeight() / 2;
        DasCanvas dasCanvas = new DasCanvas(n, n2);
        DasRow dasRow = new DasRow(dasCanvas, 0.1, 0.9);
        DasColumn dasColumn = new DasColumn(dasCanvas, 0.1, 0.9);
        dasCanvas.add(this, dasRow, dasColumn);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        BoxLayout boxLayout = new BoxLayout(jPanel2, 0);
        JButton jButton = new JButton("Hide Window");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HorizontalSpectrogramSlicer.this.popupWindow.setVisible(false);
            }
        });
        jPanel2.setLayout(boxLayout);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(jButton);
        jPanel.add((Component)dasCanvas, "Center");
        jPanel.add((Component)jPanel2, "South");
        Window window = SwingUtilities.getWindowAncestor(this.parentPlot);
        this.popupWindow = window instanceof Frame ? new JDialog((Frame)window) : (window instanceof Dialog ? new JDialog((Dialog)window) : new JDialog());
        this.popupWindow.setTitle("Horizontal Slicer");
        this.popupWindow.setDefaultCloseOperation(2);
        this.popupWindow.setContentPane(jPanel);
        this.popupWindow.pack();
        Point point = new Point();
        SwingUtilities.convertPointToScreen(point, this.parentPlot.getCanvas());
        this.popupWindow.setLocation(point.x + this.parentPlot.getCanvas().getWidth(), point.y + n2);
    }

    public void DataPointSelected(DataPointSelectionEvent dataPointSelectionEvent) {
        DataSet dataSet = dataPointSelectionEvent.getDataSet();
        if (dataSet == null || !(dataSet instanceof TableDataSet)) {
            return;
        }
        Datum datum = dataPointSelectionEvent.getY();
        this.xValue = dataPointSelectionEvent.getX();
        TableDataSet tableDataSet = (TableDataSet)dataSet;
        int n = TableUtil.tableIndexAt(tableDataSet, DataSetUtil.closestColumn(tableDataSet, dataPointSelectionEvent.getX()));
        VectorDataSet vectorDataSet = tableDataSet.getYSlice(TableUtil.closestRow(tableDataSet, n, dataPointSelectionEvent.getY()), n);
        this.renderer.setDataSet(vectorDataSet);
        DatumFormatter datumFormatter = this.xValue.getUnits() instanceof TimeLocationUnits ? TimeDatumFormatter.DEFAULT : this.xValue.getFormatter();
        this.setTitle("x: " + datumFormatter.format(this.xValue) + " y: " + datum);
        if (this.popupWindow != null && !this.popupWindow.isVisible() || this.getCanvas() == null) {
            this.showPopup();
        }
    }

    public void drawContent(Graphics2D graphics2D) {
        super.drawContent(graphics2D);
        int n = this.getXAxis().transform(this.xValue);
        DasRow dasRow = this.getRow();
        int n2 = dasRow.getDMinimum();
        int n3 = dasRow.getDMaximum();
        graphics2D.drawLine(n + 3, n2, n, n2 + 3);
        graphics2D.drawLine(n - 3, n2, n, n2 + 3);
        graphics2D.drawLine(n + 3, n3, n, n3 - 3);
        graphics2D.drawLine(n - 3, n3, n, n3 - 3);
    }

    protected void uninstallComponent() {
        super.uninstallComponent();
    }

    protected void installComponent() {
        super.installComponent();
    }

    protected void processDasUpdateEvent(DasUpdateEvent dasUpdateEvent) {
        if (this.isDisplayable()) {
            this.updateImmediately();
            this.resize();
        }
    }
}

