/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components.propertyeditor;

import edu.uiowa.physics.pw.das.components.propertyeditor.Editable;
import edu.uiowa.physics.pw.das.components.propertyeditor.PropertyTreeNode;
import java.beans.IndexedPropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class IndexedPropertyItemTreeNode
extends PropertyTreeNode {
    private IndexedPropertyDescriptor indexedPropertyDescriptor;
    private int index;

    IndexedPropertyItemTreeNode(PropertyTreeNode propertyTreeNode, IndexedPropertyDescriptor indexedPropertyDescriptor, int n) {
        super(Array.get(propertyTreeNode.value, n));
        this.index = n;
        this.parent = propertyTreeNode;
        this.propertyDescriptor = indexedPropertyDescriptor;
        this.indexedPropertyDescriptor = indexedPropertyDescriptor;
    }

    public boolean getAllowsChildren() {
        return this.value instanceof Editable;
    }

    String getDisplayName() {
        return this.propertyDescriptor.getName() + "[" + this.index + "]";
    }

    void flush() throws InvocationTargetException {
        try {
            Object object;
            if (this.dirty) {
                object = this.indexedPropertyDescriptor.getIndexedWriteMethod();
                ((Method)object).invoke(this.parent.parent.value, new Integer(this.index), this.value);
                this.dirty = false;
            }
            if (this.childDirty) {
                object = this.children.iterator();
                while (object.hasNext()) {
                    PropertyTreeNode propertyTreeNode = (PropertyTreeNode)object.next();
                    propertyTreeNode.flush();
                }
                this.childDirty = false;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }
}

