/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components.propertyeditor;

import edu.uiowa.physics.pw.das.components.DatumEditor;
import edu.uiowa.physics.pw.das.components.propertyeditor.Enumeration;
import edu.uiowa.physics.pw.das.components.propertyeditor.FloatingPointFormatter;
import edu.uiowa.physics.pw.das.components.propertyeditor.PropertyCellRenderer;
import edu.uiowa.physics.pw.das.components.propertyeditor.PropertyTreeNode;
import edu.uiowa.physics.pw.das.components.treetable.TreeTableModel;
import edu.uiowa.physics.pw.das.dasml.CommandBlockEditor;
import edu.uiowa.physics.pw.das.dasml.OptionListEditor;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

class PropertyCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener,
CellEditorListener {
    private static Map enumerationMap = new HashMap();
    private JFormattedTextField integerField = new JFormattedTextField(new Integer(0));
    private JFormattedTextField floatField;
    private JTextField stringField;
    private DatumEditor datumEditor;
    private JCheckBox booleanBox;
    private JComboBox enumerationChoice;
    private CommandBlockEditor commandBlockEditor;
    private OptionListEditor optionListEditor;
    private static final int INTEGER = 1;
    private static final int LONG = 2;
    private static final int FLOAT = 4;
    private static final int DOUBLE = 8;
    private static final int STRING = 16;
    private static final int BOOLEAN = 32;
    private static final int EDITABLE = 64;
    private static final int ENUMERATION = 128;
    private static final int DATUM = 256;
    private static final int COMMAND_BLOCK = 512;
    private static final int LIST_OPTION = 1024;
    private int editorState = 1;
    private Object currentValue = null;
    private int currentRow;
    private JTree propertyTree;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$dasml$CommandBlock;
    static /* synthetic */ Class array$Ledu$uiowa$physics$pw$das$dasml$ListOption;

    static Object[] getEnumerationList(Class clazz) {
        Object[] objectArray = (Object[])enumerationMap.get(clazz);
        if (objectArray != null) {
            return objectArray;
        }
        Field[] fieldArray = clazz.getFields();
        int n = 0;
        int n2 = 0;
        while (n2 < fieldArray.length) {
            if (fieldArray[n2].getType() == clazz && Modifier.isStatic(fieldArray[n2].getModifiers())) {
                ++n;
            }
            ++n2;
        }
        objectArray = new Object[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < fieldArray.length) {
            if (fieldArray[n4].getType() == clazz && Modifier.isStatic(fieldArray[n4].getModifiers())) {
                try {
                    objectArray[n3] = fieldArray[n4].get(null);
                    ++n3;
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            ++n4;
        }
        enumerationMap.put(clazz, objectArray);
        return objectArray;
    }

    public PropertyCellEditor(JTree jTree) {
        this.integerField.addActionListener(this);
        FloatingPointFormatter floatingPointFormatter = new FloatingPointFormatter();
        this.floatField = new JFormattedTextField(floatingPointFormatter);
        this.floatField.addActionListener(this);
        this.stringField = new JTextField();
        this.stringField.addActionListener(this);
        this.datumEditor = new DatumEditor();
        this.datumEditor.addActionListener(this);
        this.booleanBox = new JCheckBox();
        this.booleanBox.addActionListener(this);
        this.propertyTree = jTree;
        this.enumerationChoice = new JComboBox();
        this.enumerationChoice.setRenderer(new PropertyCellRenderer());
        this.enumerationChoice.addActionListener(this);
        this.commandBlockEditor = new CommandBlockEditor();
        this.commandBlockEditor.addCellEditorListener(this);
        this.optionListEditor = new OptionListEditor();
        this.optionListEditor.addCellEditorListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.fireEditingStopped();
        if (actionEvent.getSource() instanceof JButton) {
            if (this.propertyTree.isCollapsed(this.currentRow)) {
                this.propertyTree.expandRow(this.currentRow);
            } else {
                this.propertyTree.collapseRow(this.currentRow);
            }
        }
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.currentValue = object;
        this.currentRow = n;
        TreeTableModel treeTableModel = (TreeTableModel)jTable.getModel();
        PropertyTreeNode propertyTreeNode = (PropertyTreeNode)treeTableModel.getNodeForRow(n);
        PropertyDescriptor propertyDescriptor = propertyTreeNode.getPropertyDescriptor();
        if (object instanceof Enumeration) {
            this.editorState = 128;
            Object[] objectArray = PropertyCellEditor.getEnumerationList(propertyDescriptor.getPropertyType());
            this.enumerationChoice.setModel(new DefaultComboBoxModel<Object>(objectArray));
            this.enumerationChoice.setSelectedItem(object);
            return this.enumerationChoice;
        }
        if (object instanceof Integer) {
            this.editorState = 1;
            this.integerField.setValue(object);
            return this.integerField;
        }
        if (object instanceof Long) {
            this.editorState = 2;
            this.integerField.setValue(object);
            return this.integerField;
        }
        if (object instanceof Float) {
            this.editorState = 4;
            this.floatField.setValue(object);
            return this.floatField;
        }
        if (object instanceof Double) {
            this.editorState = 8;
            this.floatField.setValue(object);
            return this.floatField;
        }
        if (object instanceof Boolean) {
            this.editorState = 32;
            this.booleanBox.setSelected((Boolean)object);
            this.booleanBox.setText(object.toString());
            return this.booleanBox;
        }
        if (object instanceof Datum) {
            this.editorState = 256;
            Datum datum = (Datum)object;
            this.datumEditor.setValue(datum);
            return this.datumEditor;
        }
        if (propertyDescriptor.getPropertyType().equals(class$edu$uiowa$physics$pw$das$dasml$CommandBlock == null ? (class$edu$uiowa$physics$pw$das$dasml$CommandBlock = PropertyCellEditor.class$("edu.uiowa.physics.pw.das.dasml.CommandBlock")) : class$edu$uiowa$physics$pw$das$dasml$CommandBlock)) {
            this.editorState = 512;
            return this.commandBlockEditor.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }
        if (propertyDescriptor.getPropertyType().equals(array$Ledu$uiowa$physics$pw$das$dasml$ListOption == null ? (array$Ledu$uiowa$physics$pw$das$dasml$ListOption = PropertyCellEditor.class$("[Ledu.uiowa.physics.pw.das.dasml.ListOption;")) : array$Ledu$uiowa$physics$pw$das$dasml$ListOption)) {
            this.editorState = 1024;
            return this.optionListEditor.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }
        this.editorState = 16;
        this.stringField.setText(object.toString());
        return this.stringField;
    }

    public Object getCellEditorValue() {
        if (this.editorState == 128) {
            return this.enumerationChoice.getSelectedItem();
        }
        if (this.editorState == 1) {
            Object object = this.integerField.getValue();
            if (object instanceof Integer) {
                return object;
            }
            if (object instanceof Number) {
                return new Integer(((Number)object).intValue());
            }
            throw new IllegalStateException("Value from textfield is not of type java.lang.Number");
        }
        if (this.editorState == 2) {
            Object object = this.integerField.getValue();
            if (object instanceof Long) {
                return object;
            }
            if (object instanceof Number) {
                return new Long(((Number)object).longValue());
            }
            throw new IllegalStateException("Value from textfield is not of type java.lang.Number");
        }
        if (this.editorState == 4) {
            Object object = this.floatField.getValue();
            if (object instanceof Float) {
                return object;
            }
            if (object instanceof Number) {
                return new Float(((Number)object).floatValue());
            }
            throw new IllegalStateException("Value from textfield is not of type java.lang.Number");
        }
        if (this.editorState == 8) {
            Object object = this.floatField.getValue();
            if (object instanceof Double) {
                return object;
            }
            if (object instanceof Number) {
                return new Double(((Number)object).doubleValue());
            }
            throw new IllegalStateException("Value from textfield is not of type java.lang.Number");
        }
        if (this.editorState == 64) {
            return this.currentValue;
        }
        if (this.editorState == 32) {
            return this.booleanBox.isSelected() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (this.editorState == 256) {
            try {
                return this.datumEditor.getValue();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DasExceptionHandler.handle(illegalArgumentException);
                return this.currentValue;
            }
            catch (ParseException parseException) {
                DasExceptionHandler.handle(parseException);
                return this.currentValue;
            }
        }
        if (this.editorState == 512) {
            return this.commandBlockEditor.getCellEditorValue();
        }
        if (this.editorState == 1024) {
            return this.optionListEditor.getCellEditorValue();
        }
        return this.stringField.getText();
    }

    public void editingCanceled(ChangeEvent changeEvent) {
        this.fireEditingCanceled();
    }

    public void editingStopped(ChangeEvent changeEvent) {
        this.fireEditingStopped();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

