/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components.propertyeditor;

import edu.uiowa.physics.pw.das.components.propertyeditor.Enumeration;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.text.DecimalFormat;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;

class PropertyCellRenderer
extends JLabel
implements TableCellRenderer,
TreeCellRenderer,
ListCellRenderer {
    private static DecimalFormat expFormat = new DecimalFormat("0.#######E0");
    JCheckBox booleanRenderer;

    public PropertyCellRenderer() {
        super("Label");
        this.setFont(this.getFont().deriveFont(0));
        this.setOpaque(true);
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.booleanRenderer = new JCheckBox();
        this.booleanRenderer.setBorder(new EmptyBorder(5, 5, 5, 5));
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        double d;
        if (object instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)object;
            this.setIcon(enumeration.getListIcon());
        } else {
            this.setIcon(null);
        }
        if (object instanceof Boolean) {
            this.booleanRenderer.setSelected((Boolean)object);
            this.booleanRenderer.setText(object.toString());
            this.booleanRenderer.setBackground(bl ? Color.gray : Color.lightGray);
            return this.booleanRenderer;
        }
        if ((object instanceof Double || object instanceof Float) && ((d = ((Number)object).doubleValue()) < 0.01 || d >= 100.0)) {
            object = expFormat.format(d);
        }
        this.setText(String.valueOf(object));
        this.setOpaque(true);
        this.setBackground(bl ? Color.gray : Color.lightGray);
        return this;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        this.setText(String.valueOf(object));
        this.setIcon(null);
        this.setOpaque(false);
        return this;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        if (object instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)object;
            this.setIcon(enumeration.getListIcon());
        } else {
            this.setIcon(null);
        }
        this.setText(String.valueOf(object));
        this.setOpaque(true);
        this.setBackground(bl ? Color.gray : Color.lightGray);
        return this;
    }
}

