/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.components.propertyeditor;

import edu.uiowa.physics.pw.das.components.propertyeditor.Editable;
import edu.uiowa.physics.pw.das.components.propertyeditor.IndexedPropertyTreeNode;
import edu.uiowa.physics.pw.das.components.treetable.TreeTableNode;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;

class PropertyTreeNode
implements TreeNode,
TreeTableNode {
    protected static final Object[] NULL_ARGS;
    protected List children;
    protected PropertyTreeNode parent;
    protected PropertyDescriptor propertyDescriptor;
    protected Object value;
    protected boolean dirty;
    protected boolean childDirty;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$components$propertyeditor$Editable;
    static /* synthetic */ Class class$java$lang$Object;

    PropertyTreeNode(Object object) {
        this.value = object;
    }

    PropertyTreeNode(PropertyTreeNode propertyTreeNode, PropertyDescriptor propertyDescriptor) throws InvocationTargetException {
        this.parent = propertyTreeNode;
        this.propertyDescriptor = propertyDescriptor;
        try {
            this.value = propertyDescriptor.getReadMethod().invoke(propertyTreeNode.value, NULL_ARGS);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }

    public Enumeration children() {
        this.maybeLoadChildren();
        return Collections.enumeration(this.children);
    }

    public boolean getAllowsChildren() {
        return this.value instanceof Editable;
    }

    public TreeNode getChildAt(int n) {
        this.maybeLoadChildren();
        return (TreeNode)this.children.get(n);
    }

    public int getChildCount() {
        this.maybeLoadChildren();
        return this.children.size();
    }

    public int getIndex(TreeNode treeNode) {
        this.maybeLoadChildren();
        return this.children.indexOf(treeNode);
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public boolean isLeaf() {
        this.maybeLoadChildren();
        return this.children.isEmpty();
    }

    PropertyDescriptor getPropertyDescriptor() {
        return this.propertyDescriptor;
    }

    protected void maybeLoadChildren() {
        if (this.children == null) {
            this.children = new ArrayList();
            if (this.value instanceof Editable) {
                try {
                    BeanInfo beanInfo = Introspector.getBeanInfo(this.value.getClass());
                    PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
                    int n = 0;
                    while (n < propertyDescriptorArray.length) {
                        if (propertyDescriptorArray[n].getReadMethod() != null) {
                            if (propertyDescriptorArray[n] instanceof IndexedPropertyDescriptor) {
                                this.children.add(new IndexedPropertyTreeNode(this, (IndexedPropertyDescriptor)propertyDescriptorArray[n]));
                            } else {
                                this.children.add(new PropertyTreeNode(this, propertyDescriptorArray[n]));
                            }
                        }
                        ++n;
                    }
                }
                catch (IntrospectionException introspectionException) {
                    throw new RuntimeException(introspectionException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    DasExceptionHandler.handle(invocationTargetException.getCause());
                }
            }
        }
    }

    Object getValue() {
        return this.value;
    }

    Object getDisplayValue() {
        if (this.getAllowsChildren()) {
            return "Click to expand/collapse";
        }
        return this.value;
    }

    String getDisplayName() {
        if (this.propertyDescriptor == null) {
            return "root";
        }
        return this.propertyDescriptor.getName();
    }

    void setValue(Object object) {
        if (object == this.value) {
            return;
        }
        if (object != null && object.equals(this.value)) {
            return;
        }
        this.value = object;
        this.setDirty();
    }

    void flush() throws InvocationTargetException {
        try {
            Object object;
            if (this.dirty) {
                object = this.propertyDescriptor.getWriteMethod();
                ((Method)object).invoke(this.parent.value, this.value);
                this.dirty = false;
            }
            if (this.childDirty) {
                object = this.children.iterator();
                while (object.hasNext()) {
                    PropertyTreeNode propertyTreeNode = (PropertyTreeNode)object.next();
                    propertyTreeNode.flush();
                }
                this.childDirty = false;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }

    private void setDirty() {
        this.dirty = true;
        if (this.parent != null) {
            this.parent.setChildDirty();
        }
    }

    public boolean isDirty() {
        return this.dirty || this.childDirty;
    }

    private void setChildDirty() {
        this.childDirty = true;
        if (this.parent != null) {
            this.parent.setChildDirty();
        }
    }

    public Object getValueAt(int n) {
        switch (n) {
            case 0: {
                return this.getDisplayName();
            }
            case 1: {
                return this.getDisplayValue();
            }
        }
        throw new IllegalArgumentException("No such column: " + n);
    }

    public void setValueAt(Object object, int n) {
        switch (n) {
            case 0: {
                throw new IllegalArgumentException("Cell is not editable");
            }
            case 1: {
                this.setValue(object);
                break;
            }
            default: {
                throw new IllegalArgumentException("No such column: " + n);
            }
        }
    }

    public boolean isCellEditable(int n) {
        return n == 1 && !(class$edu$uiowa$physics$pw$das$components$propertyeditor$Editable == null ? (class$edu$uiowa$physics$pw$das$components$propertyeditor$Editable = PropertyTreeNode.class$("edu.uiowa.physics.pw.das.components.propertyeditor.Editable")) : class$edu$uiowa$physics$pw$das$components$propertyeditor$Editable).isAssignableFrom(this.propertyDescriptor.getPropertyType());
    }

    public Class getColumnClass(int n) {
        return class$java$lang$Object == null ? (class$java$lang$Object = PropertyTreeNode.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "Propety name";
            }
            case 1: {
                return "Value";
            }
        }
        throw new IllegalArgumentException("No such column: " + n);
    }

    public String toString() {
        return this.getDisplayName();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String[] stringArray = new String[]{"edu.uiowa.physics.pw.das.beans", "sun.beans.infos"};
        Introspector.setBeanInfoSearchPath(stringArray);
        NULL_ARGS = new Object[0];
    }
}

