/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

import edu.uiowa.physics.pw.das.dataset.AbstractDataSet;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;
import java.util.Map;

public abstract class AbstractTableDataSet
extends AbstractDataSet
implements DataSet,
TableDataSet {
    private Units zUnits;

    public AbstractTableDataSet(double[] dArray, Units units, Units units2, Units units3, Map map) {
        super(dArray, units, units2, map);
        this.zUnits = units3;
    }

    public Units getZUnits() {
        return this.zUnits;
    }

    public VectorDataSet getXSlice(int n) {
        return new XSliceDataSet(this, n);
    }

    public VectorDataSet getYSlice(int n, int n2) {
        return new YSliceDataSet(this, n, n2);
    }

    protected static class YSliceDataSet
    extends AbstractDataSet.ViewDataSet
    implements VectorDataSet {
        private final int table;
        private final int jIndex;
        private final TableDataSet ds;

        protected YSliceDataSet(AbstractDataSet abstractDataSet, int n, int n2) {
            this.jIndex = n;
            this.table = n2;
            this.ds = (TableDataSet)((Object)abstractDataSet);
        }

        public DataSet getPlanarView(String string) {
            if ("".equals(string)) {
                return this;
            }
            return null;
        }

        public Datum getDatum(int n) {
            int n2 = this.ds.tableStart(this.table);
            return this.ds.getDatum(n + n2, this.jIndex);
        }

        public double getDouble(int n, Units units) {
            int n2 = this.ds.tableStart(this.table);
            return this.ds.getDouble(n + n2, this.jIndex, units);
        }

        public int getInt(int n, Units units) {
            int n2 = this.ds.tableStart(this.table);
            return this.ds.getInt(n + n2, this.jIndex, units);
        }

        public Datum getXTagDatum(int n) {
            int n2 = this.ds.tableStart(this.table);
            return this.ds.getXTagDatum(n + n2);
        }

        public int getXLength() {
            return this.ds.tableEnd(this.table) - this.ds.tableStart(this.table);
        }

        public double getXTagDouble(int n, Units units) {
            int n2 = this.ds.tableStart(this.table);
            return this.ds.getXTagDouble(n + n2, units);
        }

        public Units getYUnits() {
            return this.ds.getZUnits();
        }

        public int getXTagInt(int n, Units units) {
            int n2 = this.ds.tableStart(this.table);
            return this.ds.getXTagInt(n + n2, units);
        }

        public Object getProperty(String string) {
            return null;
        }
    }

    protected static class XSliceDataSet
    extends AbstractDataSet.ViewDataSet
    implements VectorDataSet {
        private int iIndex;
        private TableDataSet ds;

        protected XSliceDataSet(AbstractDataSet abstractDataSet, int n) {
            this.ds = (TableDataSet)((Object)abstractDataSet);
            this.iIndex = n;
        }

        public DataSet getPlanarView(String string) {
            return null;
        }

        public Datum getDatum(int n) {
            return this.ds.getDatum(this.iIndex, n);
        }

        public double getDouble(int n, Units units) {
            return this.ds.getDouble(this.iIndex, n, units);
        }

        public int getInt(int n, Units units) {
            return this.ds.getInt(this.iIndex, n, units);
        }

        public Datum getXTagDatum(int n) {
            int n2 = this.ds.tableOfIndex(this.iIndex);
            return this.ds.getYTagDatum(n2, n);
        }

        public int getXLength() {
            int n = this.ds.tableOfIndex(this.iIndex);
            return this.ds.getYLength(n);
        }

        public Units getXUnits() {
            return this.ds.getYUnits();
        }

        public double getXTagDouble(int n, Units units) {
            int n2 = this.ds.tableOfIndex(this.iIndex);
            return this.ds.getYTagDouble(n2, n, units);
        }

        public Units getYUnits() {
            return this.ds.getZUnits();
        }

        public int getXTagInt(int n, Units units) {
            int n2 = this.ds.tableOfIndex(this.iIndex);
            return this.ds.getYTagInt(n2, n, units);
        }

        public Object getProperty(String string) {
            return null;
        }
    }
}

