/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.dataset.ClippedTableDataSet;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetRebinner;
import edu.uiowa.physics.pw.das.dataset.DataSetUtil;
import edu.uiowa.physics.pw.das.dataset.DefaultTableDataSet;
import edu.uiowa.physics.pw.das.dataset.NoDataInIntervalException;
import edu.uiowa.physics.pw.das.dataset.RebinDescriptor;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.TableUtil;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;
import java.util.Collections;
import java.util.logging.Logger;

public class AverageTableRebinner
implements DataSetRebinner {
    private static Logger logger = DasApplication.getDefaultApplication().getLogger();
    private boolean interpolate = true;

    public DataSet rebin(DataSet dataSet, RebinDescriptor rebinDescriptor, RebinDescriptor rebinDescriptor2) throws IllegalArgumentException, DasException {
        int n;
        int n2;
        Object object;
        double[] dArray;
        if (!(dataSet instanceof TableDataSet)) {
            throw new IllegalArgumentException();
        }
        TableDataSet tableDataSet = (TableDataSet)dataSet;
        TableDataSet tableDataSet2 = (TableDataSet)dataSet.getPlanarView("weights");
        if (rebinDescriptor != null && tableDataSet.getXLength() > 0) {
            double d = tableDataSet.getXTagDouble(0, rebinDescriptor.getUnits());
            double d2 = tableDataSet.getXTagDouble(tableDataSet.getXLength() - 1, rebinDescriptor.getUnits());
            if (d > rebinDescriptor.end) {
                throw new NoDataInIntervalException("data starts after range");
            }
            if (d2 < rebinDescriptor.start) {
                throw new NoDataInIntervalException("data ends before range");
            }
        }
        long l = System.currentTimeMillis();
        Units units = rebinDescriptor.getUnits();
        int n3 = DataSetUtil.getPreviousColumn(tableDataSet, units.createDatum(rebinDescriptor.binStart(0, units)));
        int n4 = DataSetUtil.getNextColumn(tableDataSet, units.createDatum(rebinDescriptor.binStop(rebinDescriptor.numberOfBins() - 1, units)));
        RebinDescriptor rebinDescriptor3 = RebinDescriptor.createSubsumingRebinDescriptor(rebinDescriptor, tableDataSet.getXTagDatum(n3), tableDataSet.getXTagDatum(n4));
        Datum datum = TableUtil.getSmallestYTag(tableDataSet);
        Datum datum2 = TableUtil.getLargestYTag(tableDataSet);
        RebinDescriptor rebinDescriptor4 = RebinDescriptor.createSubsumingRebinDescriptor(rebinDescriptor2, datum, datum2);
        int n5 = rebinDescriptor3 == null ? tableDataSet.getXLength() : rebinDescriptor3.numberOfBins();
        int n6 = rebinDescriptor4 == null ? tableDataSet.getYLength(0) : rebinDescriptor4.numberOfBins();
        logger.finest("Allocating rebinData and rebinWeights: " + n5 + " x " + n6);
        double[][] dArray2 = new double[n5][n6];
        double[][] dArray3 = new double[n5][n6];
        AverageTableRebinner.average(tableDataSet, tableDataSet2, dArray2, dArray3, rebinDescriptor3, rebinDescriptor4);
        if (rebinDescriptor3 != null) {
            dArray = rebinDescriptor3.binCenters();
        } else {
            dArray = new double[n5];
            int n7 = 0;
            while (n7 < n5) {
                dArray[n7] = tableDataSet.getXTagDouble(n7, tableDataSet.getXUnits());
                ++n7;
            }
        }
        if (rebinDescriptor4 != null) {
            object = new double[][]{rebinDescriptor4.binCenters()};
        } else {
            object = new double[1][n6];
            int n8 = 0;
            while (n8 < n6) {
                object[0][n8] = tableDataSet.getYTagDouble(0, n8, tableDataSet.getYUnits());
                ++n8;
            }
        }
        Datum datum3 = (Datum)dataSet.getProperty("xTagWidth");
        if (datum3 == null) {
            datum3 = DataSetUtil.guessXTagWidth(tableDataSet);
        }
        double d = datum3.doubleValue(rebinDescriptor3.getUnits().getOffsetUnits());
        if (this.interpolate) {
            if (rebinDescriptor3 != null) {
                AverageTableRebinner.fillInterpolateX(dArray2, dArray3, dArray, d);
            }
            if (rebinDescriptor4 != null) {
                AverageTableRebinner.fillInterpolateY(dArray2, dArray3, object[0], Double.POSITIVE_INFINITY, rebinDescriptor4.isLog());
            }
        } else {
            this.enlargePixels(dArray2, dArray3);
        }
        double[][][] dArrayArray = new double[][][]{dArray2, dArray3};
        int[] nArray = new int[]{0};
        Units[] unitsArray = new Units[]{tableDataSet.getZUnits(), Units.dimensionless};
        String[] stringArray = new String[]{"", "weights"};
        Units units2 = rebinDescriptor3 == null ? tableDataSet.getXUnits() : rebinDescriptor3.getUnits();
        Units units3 = rebinDescriptor4 == null ? tableDataSet.getYUnits() : rebinDescriptor4.getUnits();
        DefaultTableDataSet defaultTableDataSet = new DefaultTableDataSet(dArray, units2, (double[][])object, units3, (double[][][])dArrayArray, unitsArray, stringArray, nArray, Collections.EMPTY_MAP);
        int n9 = rebinDescriptor3.whichBin(rebinDescriptor.binCenter(0), units);
        int n10 = rebinDescriptor.numberOfBins();
        if (rebinDescriptor4 != null) {
            Units units4 = rebinDescriptor2.getUnits();
            n2 = rebinDescriptor4.whichBin(rebinDescriptor2.binCenter(0), units4);
            n = rebinDescriptor2.numberOfBins();
        } else {
            n2 = 0;
            n = ((double[][])object).length;
        }
        return new ClippedTableDataSet((TableDataSet)defaultTableDataSet, n9, n10, n2, n);
    }

    static void average(TableDataSet tableDataSet, TableDataSet tableDataSet2, double[][] dArray, double[][] dArray2, RebinDescriptor rebinDescriptor, RebinDescriptor rebinDescriptor2) {
        int n;
        int n2;
        double[] dArray3;
        if (rebinDescriptor2 != null) {
            dArray3 = rebinDescriptor2.binCenters();
        } else {
            dArray3 = new double[tableDataSet.getYLength(0)];
            n2 = 0;
            while (n2 < dArray3.length) {
                dArray3[n2] = tableDataSet.getDouble(0, n2, tableDataSet.getYUnits());
                ++n2;
            }
        }
        n2 = rebinDescriptor == null ? tableDataSet.getXLength() : rebinDescriptor.numberOfBins();
        int n3 = rebinDescriptor2 == null ? tableDataSet.getYLength(0) : rebinDescriptor2.numberOfBins();
        int n4 = 0;
        while (n4 < tableDataSet.tableCount()) {
            int[] nArray = new int[tableDataSet.getYLength(n4)];
            n = 0;
            while (n < nArray.length) {
                nArray[n] = rebinDescriptor2 != null ? rebinDescriptor2.whichBin(tableDataSet.getYTagDouble(n4, n, tableDataSet.getYUnits()), tableDataSet.getYUnits()) : n;
                ++n;
            }
            int n5 = tableDataSet.tableStart(n4);
            while (n5 < tableDataSet.tableEnd(n4)) {
                int n6 = rebinDescriptor != null ? rebinDescriptor.whichBin(tableDataSet.getXTagDouble(n5, tableDataSet.getXUnits()), tableDataSet.getXUnits()) : n5;
                if (n6 >= 0 && n6 < n2) {
                    int n7 = 0;
                    while (n7 < tableDataSet.getYLength(n4)) {
                        if (nArray[n7] >= 0 && nArray[n7] < n3) {
                            if (tableDataSet2 != null) {
                                double d = tableDataSet2.getDouble(n5, n7, Units.dimensionless);
                                double[] dArray4 = dArray[n6];
                                int n8 = nArray[n7];
                                dArray4[n8] = dArray4[n8] + tableDataSet.getDouble(n5, n7, tableDataSet.getZUnits()) * d;
                                double[] dArray5 = dArray2[n6];
                                int n9 = nArray[n7];
                                dArray5[n9] = dArray5[n9] + d;
                            } else {
                                double d;
                                Units units = tableDataSet.getZUnits();
                                double d2 = units.isFill(d = tableDataSet.getDouble(n5, n7, units)) ? 0.0 : 1.0;
                                double[] dArray6 = dArray[n6];
                                int n10 = nArray[n7];
                                dArray6[n10] = dArray6[n10] + d * d2;
                                double[] dArray7 = dArray2[n6];
                                int n11 = nArray[n7];
                                dArray7[n11] = dArray7[n11] + d2;
                            }
                        }
                        ++n7;
                    }
                }
                ++n5;
            }
            ++n4;
        }
        int n12 = 0;
        while (n12 < dArray.length) {
            n = 0;
            while (n < dArray[n12].length) {
                dArray[n12][n] = dArray2[n12][n] > 0.0 ? dArray[n12][n] / dArray2[n12][n] : tableDataSet.getZUnits().getFillDouble();
                ++n;
            }
            ++n12;
        }
    }

    static void fillInterpolateX(double[][] dArray, double[][] dArray2, double[] dArray3, double d) {
        int n = dArray3.length;
        int n2 = dArray[0].length;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            int n5 = -1;
            int n6 = -1;
            int n7 = 0;
            while (n7 < n) {
                if (dArray2[n7][n3] > 0.0 && n5 == n7 - 1) {
                    nArray[n7] = -1;
                    nArray2[n7] = -1;
                    n5 = n7;
                } else if (dArray2[n7][n3] > 0.0 && n5 == -1) {
                    n5 = n7;
                } else if (dArray2[n7][n3] > 0.0 && n5 < n7 - 1) {
                    if (n5 > -1) {
                        nArray[n7] = -1;
                        nArray2[n7] = -1;
                        n4 = n7 - 1;
                        while (n4 >= n5) {
                            n6 = n7;
                            nArray[n4] = n5;
                            nArray2[n4] = n6;
                            --n4;
                        }
                        n5 = n7;
                    }
                } else {
                    nArray[n7] = -1;
                    nArray2[n7] = -1;
                }
                ++n7;
            }
            n4 = 0;
            while (n4 < n) {
                if (nArray[n4] != -1 && dArray3[nArray2[n4]] - dArray3[nArray[n4]] < d * 1.5) {
                    double d2 = (float)((dArray3[n4] - dArray3[nArray[n4]]) / (dArray3[nArray2[n4]] - dArray3[nArray[n4]]));
                    double d3 = 1.0 - d2;
                    dArray[n4][n3] = dArray[nArray[n4]][n3] * d3 + dArray[nArray2[n4]][n3] * d2;
                    dArray2[n4][n3] = dArray2[nArray[n4]][n3] * d3 + dArray2[nArray2[n4]][n3] * d2;
                }
                ++n4;
            }
            ++n3;
        }
    }

    static void fillInterpolateY(double[][] dArray, double[][] dArray2, double[] dArray3, double d, boolean bl) {
        int n;
        int n2 = dArray.length;
        int n3 = dArray3.length;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        double[] dArray4 = new double[dArray3.length];
        if (bl) {
            n = 0;
            while (n < n3) {
                dArray4[n] = Math.log(dArray3[n]);
                ++n;
            }
        } else {
            n = 0;
            while (n < n3) {
                dArray4[n] = dArray3[n];
                ++n;
            }
        }
        n = 0;
        while (n < n2) {
            int n4;
            int n5 = -1;
            int n6 = -1;
            int n7 = 0;
            while (n7 < n3) {
                if (dArray2[n][n7] > 0.0 && n5 == n7 - 1) {
                    nArray[n7] = -1;
                    nArray2[n7] = -1;
                    n5 = n7;
                } else if (dArray2[n][n7] > 0.0 && n5 == -1) {
                    n5 = n7;
                } else if (dArray2[n][n7] > 0.0 && n5 < n7 - 1) {
                    if (n5 > -1) {
                        nArray[n7] = -1;
                        nArray2[n7] = -1;
                        n4 = n7 - 1;
                        while (n4 >= n5) {
                            n6 = n7;
                            nArray[n4] = n5;
                            nArray2[n4] = n6;
                            --n4;
                        }
                        n5 = n7;
                    }
                } else {
                    nArray[n7] = -1;
                    nArray2[n7] = -1;
                }
                ++n7;
            }
            n4 = 0;
            while (n4 < n3) {
                if (nArray[n4] != -1) {
                    float f = (float)((dArray4[n4] - dArray4[nArray[n4]]) / (dArray4[nArray2[n4]] - dArray4[nArray[n4]]));
                    float f2 = 1.0f - f;
                    dArray[n][n4] = dArray[n][nArray[n4]] * (double)f2 + dArray[n][nArray2[n4]] * (double)f;
                    dArray2[n][n4] = dArray2[n][nArray[n4]] * (double)f2 + dArray2[n][nArray2[n4]] * (double)f;
                }
                ++n4;
            }
            ++n;
        }
    }

    private void enlargePixels(double[][] dArray, double[][] dArray2) {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        while (n4 < dArray.length - 1) {
            n3 = 0;
            while (n3 < dArray[0].length) {
                if (dArray2[n4][n3] == 0.0) {
                    dArray[n4][n3] = dArray[n4 + 1][n3];
                    dArray2[n4][n3] = dArray2[n4 + 1][n3];
                }
                ++n3;
            }
            ++n4;
        }
        n3 = dArray.length - 1;
        while (n3 > 0) {
            n2 = 0;
            while (n2 < dArray[0].length) {
                if (dArray2[n3][n2] == 0.0) {
                    dArray[n3][n2] = dArray[n3 - 1][n2];
                    dArray2[n3][n2] = dArray2[n3 - 1][n2];
                }
                ++n2;
            }
            --n3;
        }
        n2 = 0;
        while (n2 < dArray[0].length - 1) {
            n = 0;
            while (n < dArray.length) {
                if (dArray2[n][n2] == 0.0) {
                    dArray[n][n2] = dArray[n][n2 + 1];
                    dArray2[n][n2] = dArray2[n][n2 + 1];
                }
                ++n;
            }
            ++n2;
        }
        n = dArray[0].length - 1;
        while (n > 0) {
            int n5 = 0;
            while (n5 < dArray.length) {
                if (dArray2[n5][n] == 0.0) {
                    dArray[n5][n] = dArray[n5][n - 1];
                    dArray2[n5][n] = dArray2[n5][n - 1];
                }
                ++n5;
            }
            --n;
        }
    }

    public boolean isInterpolate() {
        return this.interpolate;
    }

    public void setInterpolate(boolean bl) {
        this.interpolate = bl;
    }
}

