/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.DasIOException;
import edu.uiowa.physics.pw.das.client.DasServer;
import edu.uiowa.physics.pw.das.client.DataSetDescriptorNotAvailableException;
import edu.uiowa.physics.pw.das.client.NoSuchDataSetException;
import edu.uiowa.physics.pw.das.client.StreamDataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.CacheTag;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetUpdateEvent;
import edu.uiowa.physics.pw.das.dataset.DataSetUpdateListener;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.stream.StreamDescriptor;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import edu.uiowa.physics.pw.das.util.URLBuddy;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.EventListenerList;

public abstract class DataSetDescriptor {
    protected Map properties = new HashMap();
    private boolean defaultCaching = true;
    private DataSet cacheDataSet;
    private String dataSetID;
    private CacheTag cacheTag = null;
    private EventListenerList listenerList;
    private static final Pattern CLASS_ID = Pattern.compile("class:([a-zA-Z0-9_\\.]+)(?:\\?(.*))?");
    private static final Pattern NAME_VALUE = Pattern.compile("([_0-9a-zA-Z%+.-]+)=([_0-9a-zA-Z%+.-]+)");
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$dataset$DataSetUpdateListener;
    static /* synthetic */ Class class$java$util$Map;

    protected DataSetDescriptor(String string) {
        this.dataSetID = string;
    }

    protected DataSetDescriptor() {
        this("");
    }

    protected abstract DataSet getDataSetImpl(Datum var1, Datum var2, Datum var3, DasProgressMonitor var4) throws DasException;

    public abstract Units getXUnits();

    public void requestDataSet(Datum datum, Datum datum2, Datum datum3, DasProgressMonitor dasProgressMonitor) {
        DataSetUpdateEvent dataSetUpdateEvent;
        try {
            DataSet dataSet = this.getDataSet(datum, datum2, datum3, dasProgressMonitor);
            dataSetUpdateEvent = new DataSetUpdateEvent(this, dataSet);
        }
        catch (DasException dasException) {
            dataSetUpdateEvent = new DataSetUpdateEvent(this, dasException);
        }
        this.fireDataSetUpdateEvent(dataSetUpdateEvent);
    }

    public DataSet getDataSet(Datum datum, Datum datum2, Datum datum3, DasProgressMonitor dasProgressMonitor) throws DasException {
        if (dasProgressMonitor != null) {
            dasProgressMonitor.started();
        }
        if (this.cacheTag != null && this.defaultCaching && this.cacheTag.start.le(datum) && this.cacheTag.end.ge(datum2) && (this.cacheTag.resolution == null || datum3 != null && this.cacheTag.resolution.le(datum3))) {
            if (dasProgressMonitor != null) {
                dasProgressMonitor.finished();
            }
            return this.cacheDataSet;
        }
        try {
            this.cacheDataSet = this.getDataSetImpl(datum, datum2, datum3, dasProgressMonitor);
            if (this.cacheDataSet != null) {
                this.cacheTag = (CacheTag)this.cacheDataSet.getProperty("cacheTag");
                if (this.cacheTag == null) {
                    this.cacheTag = new CacheTag(datum, datum2, datum3);
                }
            }
            if (dasProgressMonitor != null) {
                dasProgressMonitor.finished();
            }
            return this.cacheDataSet;
        }
        catch (DasException dasException) {
            throw dasException;
        }
        catch (Exception exception) {
            DasExceptionHandler.handle(exception);
            return null;
        }
    }

    protected void setDefaultCaching(boolean bl) {
        this.defaultCaching = bl;
    }

    public void addDataSetUpdateListener(DataSetUpdateListener dataSetUpdateListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(class$edu$uiowa$physics$pw$das$dataset$DataSetUpdateListener == null ? (class$edu$uiowa$physics$pw$das$dataset$DataSetUpdateListener = DataSetDescriptor.class$("edu.uiowa.physics.pw.das.dataset.DataSetUpdateListener")) : class$edu$uiowa$physics$pw$das$dataset$DataSetUpdateListener, dataSetUpdateListener);
    }

    public void removeDataSetUpdateListener(DataSetUpdateListener dataSetUpdateListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.remove(class$edu$uiowa$physics$pw$das$dataset$DataSetUpdateListener == null ? (class$edu$uiowa$physics$pw$das$dataset$DataSetUpdateListener = DataSetDescriptor.class$("edu.uiowa.physics.pw.das.dataset.DataSetUpdateListener")) : class$edu$uiowa$physics$pw$das$dataset$DataSetUpdateListener, dataSetUpdateListener);
    }

    protected void fireDataSetUpdateEvent(DataSetUpdateEvent dataSetUpdateEvent) {
        if (this.listenerList == null) {
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$edu$uiowa$physics$pw$das$dataset$DataSetUpdateListener == null ? DataSetDescriptor.class$("edu.uiowa.physics.pw.das.dataset.DataSetUpdateListener") : class$edu$uiowa$physics$pw$das$dataset$DataSetUpdateListener)) {
                ((DataSetUpdateListener)objectArray[n + 1]).dataSetUpdated(dataSetUpdateEvent);
            }
            n -= 2;
        }
    }

    public String getDataSetID() {
        return this.dataSetID;
    }

    public static DataSetDescriptor create(String string) throws DasException {
        DataSetDescriptor dataSetDescriptor;
        Matcher matcher = CLASS_ID.matcher(string);
        if (matcher.matches()) {
            dataSetDescriptor = DataSetDescriptor.createFromClassName(string, matcher);
        } else {
            try {
                dataSetDescriptor = DataSetDescriptor.createFromServerAddress(new URL(string));
            }
            catch (MalformedURLException malformedURLException) {
                throw new DasIOException(malformedURLException.getMessage());
            }
        }
        dataSetDescriptor.dataSetID = string;
        return dataSetDescriptor;
    }

    private static DataSetDescriptor createFromServerAddress(URL uRL) throws DasException {
        DasServer dasServer = DasServer.create(uRL);
        StreamDescriptor streamDescriptor = dasServer.getStreamDescriptor(uRL);
        return new StreamDataSetDescriptor(streamDescriptor, dasServer.getStandardDataStreamSource(uRL));
    }

    private static DataSetDescriptor createFromClassName(String string, Matcher matcher) throws DasException {
        try {
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            Map map = string3 == null ? Collections.EMPTY_MAP : URLBuddy.parseQueryString(string3);
            Class<?> clazz = Class.forName(string2);
            Method method = clazz.getMethod("newDataSetDescriptor", class$java$util$Map == null ? (class$java$util$Map = DataSetDescriptor.class$("java.util.Map")) : class$java$util$Map);
            if (!Modifier.isStatic(method.getModifiers())) {
                throw new NoSuchDataSetException("newDataSetDescriptor must be static");
            }
            return (DataSetDescriptor)method.invoke(null, map);
        }
        catch (ClassNotFoundException classNotFoundException) {
            DataSetDescriptorNotAvailableException dataSetDescriptorNotAvailableException = new DataSetDescriptorNotAvailableException(classNotFoundException.getMessage());
            dataSetDescriptorNotAvailableException.initCause(classNotFoundException);
            throw dataSetDescriptorNotAvailableException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            DataSetDescriptorNotAvailableException dataSetDescriptorNotAvailableException = new DataSetDescriptorNotAvailableException(noSuchMethodException.getMessage());
            dataSetDescriptorNotAvailableException.initCause(noSuchMethodException);
            throw dataSetDescriptorNotAvailableException;
        }
        catch (InvocationTargetException invocationTargetException) {
            DataSetDescriptorNotAvailableException dataSetDescriptorNotAvailableException = new DataSetDescriptorNotAvailableException(invocationTargetException.getTargetException().getMessage());
            dataSetDescriptorNotAvailableException.initCause(invocationTargetException.getTargetException());
            throw dataSetDescriptorNotAvailableException;
        }
        catch (IllegalAccessException illegalAccessException) {
            DataSetDescriptorNotAvailableException dataSetDescriptorNotAvailableException = new DataSetDescriptorNotAvailableException(illegalAccessException.getMessage());
            dataSetDescriptorNotAvailableException.initCause(illegalAccessException);
            throw dataSetDescriptorNotAvailableException;
        }
    }

    protected void setProperties(Map map) {
        this.properties.putAll(map);
    }

    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

