/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

import edu.uiowa.physics.pw.das.dataset.CacheTag;
import edu.uiowa.physics.pw.das.dataset.ConstantDataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasColorBar;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.graph.SpectrogramRenderer;
import edu.uiowa.physics.pw.das.graph.SymbolLineRenderer;
import javax.swing.JFrame;

public class DataSetUtil {
    public static CacheTag guessCacheTag(DataSet dataSet) {
        Datum datum = dataSet.getXTagDatum(0);
        Datum datum2 = dataSet.getXTagDatum(dataSet.getXLength() - 1);
        Datum datum3 = dataSet.getXTagDatum(1).subtract(datum);
        return new CacheTag(datum, datum2, datum3);
    }

    public static DasAxis guessYAxis(DataSet dataSet) {
        Units units = dataSet.getYUnits();
        return new DasAxis(units.createDatum(-20), units.createDatum(20), 3);
    }

    public static DasAxis guessXAxis(DataSet dataSet) {
        Datum datum = dataSet.getXTagDatum(0);
        Datum datum2 = dataSet.getXTagDatum(dataSet.getXLength() - 1);
        return new DasAxis(datum, datum2, 2);
    }

    public static DasPlot guessPlot(DataSet dataSet) {
        DasAxis dasAxis = DataSetUtil.guessXAxis(dataSet);
        DasAxis dasAxis2 = DataSetUtil.guessYAxis(dataSet);
        DasPlot dasPlot = new DasPlot(dasAxis, dasAxis2);
        if (dataSet instanceof VectorDataSet) {
            SymbolLineRenderer symbolLineRenderer = new SymbolLineRenderer(dataSet);
            dasPlot.addRenderer(symbolLineRenderer);
        } else if (dataSet instanceof TableDataSet) {
            Units units = ((TableDataSet)dataSet).getZUnits();
            DasColorBar dasColorBar = new DasColorBar(units.createDatum(-20), units.createDatum(20), false);
            SpectrogramRenderer spectrogramRenderer = new SpectrogramRenderer(new ConstantDataSetDescriptor(dataSet), dasColorBar);
            dasPlot.addRenderer(spectrogramRenderer);
        }
        return dasPlot;
    }

    public static DasPlot visualize(DataSet dataSet, double d, double d2, double d3, double d4) {
        JFrame jFrame = new JFrame("DataSetUtil.visualize");
        DasCanvas dasCanvas = new DasCanvas(400, 400);
        jFrame.getContentPane().add(dasCanvas);
        DasPlot dasPlot = DataSetUtil.guessPlot(dataSet);
        dasCanvas.add(dasPlot, DasRow.create(dasCanvas), DasColumn.create(dasCanvas));
        Units units = dasPlot.getXAxis().getUnits();
        dasPlot.getXAxis().setDataRange(units.createDatum(d), units.createDatum(d2));
        Units units2 = dasPlot.getYAxis().getUnits();
        dasPlot.getYAxis().setDataRange(units2.createDatum(d3), units2.createDatum(d4));
        jFrame.pack();
        jFrame.setVisible(true);
        jFrame.setDefaultCloseOperation(3);
        return dasPlot;
    }

    public static double[] getXTagArrayDouble(DataSet dataSet, Units units) {
        int n = dataSet.getXLength();
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = dataSet.getXTagDouble(n2, units);
            ++n2;
        }
        return dArray;
    }

    public static Datum guessXTagWidth(DataSet dataSet) {
        if (dataSet.getXLength() > 2) {
            return dataSet.getXTagDatum(2).subtract(dataSet.getXTagDatum(0)).divide(2.0);
        }
        return dataSet.getXUnits().getOffsetUnits().createDatum(0);
    }

    protected static int closest(double[] dArray, double d) {
        if (dArray.length == 0) {
            throw new IllegalArgumentException("array has no elements");
        }
        int n = 0;
        while (n < dArray.length - 1 && dArray[n] < d) {
            ++n;
        }
        while (n > 0 && dArray[n] > d) {
            --n;
        }
        if (n < dArray.length - 2) {
            n = (d - dArray[n]) / (dArray[n + 1] - dArray[n]) < 0.5 ? n : n + 1;
        }
        return n;
    }

    public static int closestColumn(DataSet dataSet, Datum datum) {
        return DataSetUtil.closestColumn(dataSet, datum.doubleValue(datum.getUnits()), datum.getUnits());
    }

    public static int closestColumn(DataSet dataSet, double d, Units units) {
        double[] dArray = DataSetUtil.getXTagArrayDouble(dataSet, units);
        return DataSetUtil.closest(dArray, d);
    }

    public static int getPreviousColumn(DataSet dataSet, Datum datum) {
        int n = DataSetUtil.closestColumn(dataSet, datum);
        if (n > 0 && dataSet.getXTagDatum(n).ge(datum)) {
            return n - 1;
        }
        return n;
    }

    public static int getNextColumn(DataSet dataSet, Datum datum) {
        int n = DataSetUtil.closestColumn(dataSet, datum);
        if (n < dataSet.getXLength() - 1 && dataSet.getXTagDatum(n).le(datum)) {
            return n + 1;
        }
        return n;
    }
}

