/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetUtil;
import edu.uiowa.physics.pw.das.dataset.RebinDescriptor;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.TableUtil;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.dataset.XSliceDataSet;
import edu.uiowa.physics.pw.das.dataset.YSliceDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.Units;

public class NearestNeighborTableDataSet
implements TableDataSet {
    TableDataSet source;
    int[] imap;
    int[][] jmap;
    int[] itableMap;
    RebinDescriptor ddX;
    RebinDescriptor ddY;

    NearestNeighborTableDataSet(TableDataSet tableDataSet, RebinDescriptor rebinDescriptor, RebinDescriptor rebinDescriptor2) {
        this.imap = new int[rebinDescriptor.numberOfBins()];
        if (rebinDescriptor2 == null) {
            if (tableDataSet.tableCount() > 1) {
                throw new IllegalArgumentException();
            }
            this.jmap = new int[tableDataSet.tableCount()][tableDataSet.getYLength(0)];
        } else {
            this.jmap = new int[tableDataSet.tableCount()][rebinDescriptor2.numberOfBins()];
        }
        this.itableMap = new int[rebinDescriptor.numberOfBins()];
        Datum datum = (Datum)tableDataSet.getProperty("xTagWidth");
        Datum datum2 = (Datum)tableDataSet.getProperty("yTagWidth");
        if (datum == null) {
            datum = DataSetUtil.guessXTagWidth(tableDataSet);
        }
        if (datum2 == null) {
            datum2 = TableUtil.guessYTagWidth(tableDataSet);
        }
        this.ddX = rebinDescriptor;
        this.ddY = rebinDescriptor2;
        this.source = tableDataSet;
        double[] dArray = rebinDescriptor.binCenters();
        double[] dArray2 = rebinDescriptor2 == null ? TableUtil.getYTagArrayDouble(tableDataSet, 0, tableDataSet.getYUnits()) : rebinDescriptor2.binCenters();
        int n = -1;
        int n2 = 0;
        while (n2 < this.imap.length) {
            this.imap[n2] = DataSetUtil.closestColumn(tableDataSet, dArray[n2], rebinDescriptor.getUnits());
            Datum datum3 = tableDataSet.getXTagDatum(this.imap[n2]);
            Units units = datum.getUnits();
            if (Math.abs(datum3.subtract(dArray[n2], rebinDescriptor.getUnits()).doubleValue(units)) > datum.doubleValue(units) / 2.0) {
                this.imap[n2] = -1;
            } else {
                int n3;
                this.itableMap[n2] = n3 = tableDataSet.tableOfIndex(this.imap[n2]);
                if (n != n3) {
                    int n4;
                    if (rebinDescriptor2 == null) {
                        n4 = 0;
                        while (n4 < this.jmap[n3].length) {
                            this.jmap[n3][n4] = n4;
                            ++n4;
                        }
                    } else {
                        n4 = 0;
                        while (n4 < this.jmap[n3].length) {
                            this.jmap[n3][n4] = TableUtil.closestRow(tableDataSet, n3, dArray2[n4], rebinDescriptor2.getUnits());
                            Units units2 = datum2.getUnits();
                            if (units2 == Units.percent) {
                                double d = tableDataSet.getYTagDouble(n3, this.jmap[n3][n4], rebinDescriptor2.getUnits());
                                if (dArray2[n4] > d) {
                                    if ((dArray2[n4] - d) * 100.0 / d > datum2.doubleValue(Units.percent)) {
                                        this.jmap[n3][n4] = -1;
                                    }
                                } else if ((d - dArray2[n4]) * 100.0 / dArray2[n4] > datum2.doubleValue(Units.percent)) {
                                    this.jmap[n3][n4] = -1;
                                }
                            } else {
                                Datum datum4 = tableDataSet.getYTagDatum(n3, this.jmap[n3][n4]);
                                if (Math.abs(datum4.subtract(dArray2[n4], rebinDescriptor2.getUnits()).doubleValue(units2)) > datum2.doubleValue(units2)) {
                                    this.jmap[n3][n4] = -1;
                                }
                            }
                            ++n4;
                        }
                    }
                    n = n3;
                }
            }
            ++n2;
        }
    }

    public Datum getDatum(int n, int n2) {
        if (this.imap[n] != -1 && this.jmap[this.itableMap[n]][n2] != -1) {
            return this.source.getDatum(this.imap[n], this.jmap[this.itableMap[n]][n2]);
        }
        return this.source.getZUnits().createDatum(this.source.getZUnits().getFillDouble());
    }

    public double getDouble(int n, int n2, Units units) {
        if (this.imap[n] != -1 && this.jmap[this.itableMap[n]][n2] != -1) {
            return this.source.getDouble(this.imap[n], this.jmap[this.itableMap[n]][n2], units);
        }
        return this.source.getZUnits().getFillDouble();
    }

    public int getInt(int n, int n2, Units units) {
        if (this.imap[n] != -1 && this.jmap[this.itableMap[n]][n2] != -1) {
            return this.source.getInt(this.imap[n], this.jmap[this.itableMap[n]][n2], units);
        }
        return this.source.getZUnits().getFillInt();
    }

    public DataSet getPlanarView(String string) {
        TableDataSet tableDataSet = (TableDataSet)this.source.getPlanarView(string);
        if (tableDataSet != null) {
            return new NearestNeighborTableDataSet(tableDataSet, this.ddX, this.ddY);
        }
        return null;
    }

    public Object getProperty(String string) {
        return this.source.getProperty(string);
    }

    public int getXLength() {
        return this.imap.length;
    }

    public VectorDataSet getXSlice(int n) {
        return new XSliceDataSet(this, n);
    }

    public VectorDataSet getYSlice(int n, int n2) {
        return new YSliceDataSet(this, n, n2);
    }

    public Datum getXTagDatum(int n) {
        return this.ddX.getUnits().createDatum(this.getXTagDouble(n, this.ddX.getUnits()));
    }

    public double getXTagDouble(int n, Units units) {
        return this.ddX.binCenter(n);
    }

    public int getXTagInt(int n, Units units) {
        return (int)this.getXTagDouble(n, units);
    }

    public Units getXUnits() {
        return this.ddX.getUnits();
    }

    public int getYLength(int n) {
        if (this.ddY == null) {
            return this.source.getYLength(n);
        }
        return this.ddY.numberOfBins();
    }

    public Datum getYTagDatum(int n, int n2) {
        if (this.ddY == null) {
            return this.source.getYTagDatum(n, n2);
        }
        return this.ddY.getUnits().createDatum(this.getYTagDouble(n, n2, this.ddY.getUnits()));
    }

    public double getYTagDouble(int n, int n2, Units units) {
        if (this.ddY == null) {
            return this.source.getYTagDouble(n, n2, units);
        }
        return this.ddY.binCenter(n2);
    }

    public int getYTagInt(int n, int n2, Units units) {
        return (int)this.getYTagDouble(n, n2, units);
    }

    public Units getYUnits() {
        if (this.ddY == null) {
            return this.source.getYUnits();
        }
        return this.ddY.getUnits();
    }

    public Units getZUnits() {
        return this.source.getZUnits();
    }

    public int tableCount() {
        return 1;
    }

    public int tableEnd(int n) {
        return this.ddX.numberOfBins();
    }

    public int tableOfIndex(int n) {
        return 0;
    }

    public int tableStart(int n) {
        return 0;
    }

    public String toString() {
        return "NearestNeighborTableDataSet " + TableUtil.toString(this);
    }

    public double[] getDoubleScan(int n, Units units) {
        int n2 = this.getYLength(this.tableOfIndex(n));
        double[] dArray = new double[n2];
        int n3 = 0;
        while (n3 < n2) {
            dArray[n3] = this.getDouble(n, n3, units);
            ++n3;
        }
        return dArray;
    }

    public DatumVector getScan(int n) {
        Units units = this.getZUnits();
        return DatumVector.newDatumVector(this.getDoubleScan(n, units), units);
    }

    public DatumVector getYTags(int n) {
        double[] dArray = new double[this.getYLength(n)];
        Units units = this.getYUnits();
        int n2 = 0;
        while (n2 < dArray.length) {
            dArray[n2] = this.getYTagDouble(n, n2, units);
            ++n2;
        }
        return DatumVector.newDatumVector(dArray, units);
    }
}

