/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetRebinner;
import edu.uiowa.physics.pw.das.dataset.DefaultTableDataSet;
import edu.uiowa.physics.pw.das.dataset.RebinDescriptor;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.datum.Units;
import java.util.Arrays;
import java.util.Collections;

public class PeakTableRebinner
implements DataSetRebinner {
    public DataSet rebin(DataSet dataSet, RebinDescriptor rebinDescriptor, RebinDescriptor rebinDescriptor2) throws IllegalArgumentException {
        Object object;
        double[] dArray;
        if (!(dataSet instanceof TableDataSet)) {
            throw new IllegalArgumentException();
        }
        TableDataSet tableDataSet = (TableDataSet)dataSet;
        long l = System.currentTimeMillis();
        int n = rebinDescriptor == null ? tableDataSet.getXLength() : rebinDescriptor.numberOfBins();
        int n2 = rebinDescriptor2 == null ? tableDataSet.getYLength(0) : rebinDescriptor2.numberOfBins();
        double[][] dArray2 = new double[n][n2];
        double[][] dArray3 = new double[n][n2];
        PeakTableRebinner.peaks(tableDataSet, dArray2, rebinDescriptor, rebinDescriptor2);
        if (rebinDescriptor != null) {
            dArray = rebinDescriptor.binCenters();
        } else {
            dArray = new double[tableDataSet.getXLength()];
            int n3 = 0;
            while (n3 < dArray.length) {
                dArray[n3] = tableDataSet.getXTagDouble(n3, tableDataSet.getXUnits());
                ++n3;
            }
        }
        if (rebinDescriptor2 != null) {
            object = new double[][]{rebinDescriptor2.binCenters()};
        } else {
            object = new double[0][tableDataSet.getYLength(0)];
            int n4 = 0;
            while (n4 < object[0].length) {
                object[0][n4] = tableDataSet.getYTagDouble(0, n4, tableDataSet.getYUnits());
                ++n4;
            }
        }
        double[][][] dArrayArray = new double[][][]{dArray2};
        int[] nArray = new int[]{0};
        Units[] unitsArray = new Units[]{tableDataSet.getZUnits()};
        String[] stringArray = new String[]{""};
        return new DefaultTableDataSet(dArray, tableDataSet.getXUnits(), (double[][])object, tableDataSet.getYUnits(), (double[][][])dArrayArray, unitsArray, stringArray, nArray, Collections.EMPTY_MAP);
    }

    static void peaks(TableDataSet tableDataSet, double[][] dArray, RebinDescriptor rebinDescriptor, RebinDescriptor rebinDescriptor2) {
        int n;
        double[] dArray2;
        if (rebinDescriptor2 != null) {
            dArray2 = rebinDescriptor2.binCenters();
        } else {
            dArray2 = new double[tableDataSet.getYLength(0)];
            n = 0;
            while (n < dArray2.length) {
                dArray2[n] = tableDataSet.getDouble(0, n, tableDataSet.getYUnits());
                ++n;
            }
        }
        n = rebinDescriptor == null ? tableDataSet.getXLength() : rebinDescriptor.numberOfBins();
        int n2 = rebinDescriptor2 == null ? tableDataSet.getYLength(0) : rebinDescriptor2.numberOfBins();
        int n3 = 0;
        while (n3 < dArray.length) {
            Arrays.fill(dArray[n3], Double.NaN);
            ++n3;
        }
        int[] nArray = new int[tableDataSet.getYLength(0)];
        int n4 = 0;
        while (n4 < nArray.length) {
            nArray[n4] = rebinDescriptor2 != null ? rebinDescriptor2.whichBin(tableDataSet.getYTagDouble(0, n4, tableDataSet.getYUnits()), tableDataSet.getYUnits()) : n4;
            ++n4;
        }
        int n5 = 0;
        while (n5 < tableDataSet.getXLength()) {
            int n6 = rebinDescriptor != null ? rebinDescriptor.whichBin(tableDataSet.getXTagDouble(n5, tableDataSet.getXUnits()), tableDataSet.getXUnits()) : n5;
            if (n6 >= 0 && n6 < n) {
                int n7 = 0;
                while (n7 < nArray.length) {
                    if (nArray[n7] >= 0 && nArray[n7] < n2) {
                        double d = tableDataSet.getDouble(n5, n7, tableDataSet.getZUnits());
                        dArray[n6][nArray[n7]] = Double.isNaN(dArray[n6][nArray[n7]]) ? d : Math.max(d, dArray[n6][nArray[n7]]);
                    }
                    ++n7;
                }
            }
            ++n5;
        }
    }
}

