/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetUtil;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;

public class SyncUtil {
    private static int[] calculateImap(DataSet dataSet, DataSet dataSet2) {
        int[] nArray = new int[dataSet2.getXLength()];
        Units units = dataSet.getXUnits();
        Datum datum = (Datum)dataSet.getProperty("xTagWidth");
        if (datum == null) {
            datum = DataSetUtil.guessXTagWidth(dataSet);
        }
        int n = 0;
        while (n < nArray.length) {
            double d = dataSet2.getXTagDouble(n, units);
            nArray[n] = DataSetUtil.closestColumn(dataSet, d, units);
            Datum datum2 = dataSet.getXTagDatum(nArray[n]);
            if (Math.abs(datum2.subtract(d, units).doubleValue(units)) > datum.doubleValue(units) / 2.0) {
                nArray[n] = -1;
            }
            ++n;
        }
        return nArray;
    }

    private static int[] calculateImapForWidthTags(DataSet dataSet, DataSet dataSet2) {
        int[] nArray = new int[dataSet2.getXLength()];
        Units units = dataSet.getXUnits();
        String string = "xTagWidth";
        VectorDataSet vectorDataSet = (VectorDataSet)dataSet.getPlanarView(string);
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = -1;
            Datum datum = dataSet2.getXTagDatum(n);
            Datum datum2 = null;
            int n2 = 0;
            while ((datum2 == null || datum2.le(datum)) && n2 < dataSet.getXLength()) {
                datum2 = dataSet.getXTagDatum(n2);
                Datum datum3 = datum2.add(vectorDataSet.getDatum(n2));
                if (datum2.le(datum) && datum.lt(datum3)) {
                    nArray[n] = n2;
                }
                ++n2;
            }
            ++n;
        }
        return nArray;
    }

    public static DataSet syncronizeNearestNeighbor(DataSet dataSet, DataSet dataSet2) {
        if (dataSet instanceof VectorDataSet) {
            return NearestNeighborVectorDataSet.create((VectorDataSet)dataSet, dataSet2);
        }
        throw new IllegalArgumentException("Unsupported DataSet Type: " + dataSet);
    }

    private static class NearestNeighborVectorDataSet
    implements VectorDataSet {
        VectorDataSet source;
        int[] imap;
        double[] xtags;

        NearestNeighborVectorDataSet(VectorDataSet vectorDataSet, int[] nArray, double[] dArray) {
            this.source = vectorDataSet;
            this.imap = nArray;
            this.xtags = dArray;
        }

        private static NearestNeighborVectorDataSet create(VectorDataSet vectorDataSet, DataSet dataSet) {
            if (vectorDataSet.getPlanarView("xTagWidth") != null) {
                return new NearestNeighborVectorDataSet(vectorDataSet, SyncUtil.calculateImapForWidthTags(vectorDataSet, dataSet), DataSetUtil.getXTagArrayDouble(dataSet, vectorDataSet.getXUnits()));
            }
            return new NearestNeighborVectorDataSet(vectorDataSet, SyncUtil.calculateImap(vectorDataSet, dataSet), DataSetUtil.getXTagArrayDouble(dataSet, vectorDataSet.getXUnits()));
        }

        public Datum getDatum(int n) {
            if (this.imap[n] != -1) {
                return this.source.getDatum(this.imap[n]);
            }
            return this.source.getYUnits().createDatum(this.source.getYUnits().getFillDouble());
        }

        public double getDouble(int n, Units units) {
            if (this.imap[n] != -1) {
                return this.source.getDouble(this.imap[n], units);
            }
            return units.getFillDouble();
        }

        public int getInt(int n, Units units) {
            if (this.imap[n] != -1) {
                return this.source.getInt(this.imap[n], units);
            }
            return units.getFillInt();
        }

        public DataSet getPlanarView(String string) {
            return new NearestNeighborVectorDataSet((VectorDataSet)this.source.getPlanarView(string), this.imap, this.xtags);
        }

        public Object getProperty(String string) {
            return this.source.getProperty(string);
        }

        public int getXLength() {
            return this.imap.length;
        }

        public Datum getXTagDatum(int n) {
            return this.getXUnits().createDatum(this.xtags[n]);
        }

        public double getXTagDouble(int n, Units units) {
            return this.getXUnits().convertDoubleTo(units, this.imap[n]);
        }

        public int getXTagInt(int n, Units units) {
            throw new IllegalArgumentException("not implemented");
        }

        public Units getXUnits() {
            return this.source.getXUnits();
        }

        public Units getYUnits() {
            return this.source.getYUnits();
        }
    }
}

