/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset;

import edu.uiowa.physics.pw.das.dataset.DataSetUtil;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.DatumVector;
import edu.uiowa.physics.pw.das.datum.LocationUnits;
import edu.uiowa.physics.pw.das.datum.TimeUtil;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.stream.DataTransferType;
import edu.uiowa.physics.pw.das.stream.PacketDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamException;
import edu.uiowa.physics.pw.das.stream.StreamProducer;
import edu.uiowa.physics.pw.das.stream.StreamXDescriptor;
import edu.uiowa.physics.pw.das.stream.StreamYScanDescriptor;
import edu.uiowa.physics.pw.das.util.FixedWidthFormatter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.text.DecimalFormat;

public class TableUtil {
    public static double[] getYTagArrayDouble(TableDataSet tableDataSet, int n, Units units) {
        double[] dArray = new double[tableDataSet.getYLength(n)];
        int n2 = 0;
        while (n2 < dArray.length) {
            dArray[n2] = tableDataSet.getYTagDouble(n, n2, units);
            ++n2;
        }
        return dArray;
    }

    public static Datum getLargestYTag(TableDataSet tableDataSet) {
        Datum datum = tableDataSet.getYTagDatum(0, tableDataSet.getYLength(0) - 1);
        int n = 1;
        while (n < tableDataSet.tableCount()) {
            Datum datum2 = tableDataSet.getYTagDatum(n, tableDataSet.getYLength(n) - 1);
            if (datum2.gt(datum)) {
                datum = datum2;
            }
            ++n;
        }
        return datum;
    }

    public static Datum getSmallestYTag(TableDataSet tableDataSet) {
        Datum datum = tableDataSet.getYTagDatum(0, 0);
        int n = 1;
        while (n < tableDataSet.tableCount()) {
            Datum datum2 = tableDataSet.getYTagDatum(n, 0);
            if (datum2.lt(datum)) {
                datum = datum2;
            }
            ++n;
        }
        return datum;
    }

    public static int closestRow(TableDataSet tableDataSet, int n, Datum datum) {
        return TableUtil.closestRow(tableDataSet, n, datum.doubleValue(datum.getUnits()), datum.getUnits());
    }

    public static int closestRow(TableDataSet tableDataSet, int n, double d, Units units) {
        double[] dArray = TableUtil.getYTagArrayDouble(tableDataSet, n, units);
        return DataSetUtil.closest(dArray, d);
    }

    public static Datum closestDatum(TableDataSet tableDataSet, Datum datum, Datum datum2) {
        int n = DataSetUtil.closestColumn(tableDataSet, datum);
        int n2 = TableUtil.closestRow(tableDataSet, tableDataSet.tableOfIndex(n), datum2);
        return tableDataSet.getDatum(n, n2);
    }

    public static int tableIndexAt(TableDataSet tableDataSet, int n) {
        int n2 = 0;
        while (tableDataSet.tableEnd(n2) <= n) {
            ++n2;
        }
        return n2;
    }

    public static Datum guessYTagWidth(TableDataSet tableDataSet) {
        double d = tableDataSet.getYTagDouble(0, 0, tableDataSet.getYUnits());
        double d2 = tableDataSet.getYTagDouble(0, 1, tableDataSet.getYUnits());
        int n = tableDataSet.getYLength(0) - 1;
        double d3 = tableDataSet.getYTagDouble(0, n, tableDataSet.getYUnits());
        if ((d3 - d) / ((d2 - d) * (double)n) > 10.0) {
            return Units.percent.createDatum((d2 / d - 1.0) * 100.0);
        }
        return tableDataSet.getYUnits().createDatum(d2 - d);
    }

    public static double tableMax(TableDataSet tableDataSet) {
        double d = Double.NEGATIVE_INFINITY;
        int n = 0;
        while (n < tableDataSet.tableCount()) {
            int n2 = tableDataSet.getYLength(n);
            int n3 = tableDataSet.tableStart(n);
            while (n3 < tableDataSet.tableEnd(n)) {
                int n4 = 0;
                while (n4 < n2) {
                    if (tableDataSet.getDouble(n3, n4, tableDataSet.getZUnits()) > d) {
                        d = tableDataSet.getDouble(n3, n4, tableDataSet.getZUnits());
                    }
                    ++n4;
                }
                ++n3;
            }
            ++n;
        }
        return d;
    }

    public static String toString(TableDataSet tableDataSet) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(tableDataSet.getYLength(0));
        int n = 1;
        while (n < tableDataSet.tableCount()) {
            stringBuffer.append(", " + tableDataSet.getYLength(n));
            ++n;
        }
        return "[" + tableDataSet.getXLength() + " xTags, " + stringBuffer.toString() + " yTags]";
    }

    public static DatumVector getDatumVector(TableDataSet tableDataSet, int n) {
        Units units = tableDataSet.getZUnits();
        double[] dArray = new double[tableDataSet.getYLength(tableDataSet.tableOfIndex(n))];
        int n2 = 0;
        while (n2 < dArray.length) {
            dArray[n2] = tableDataSet.getDouble(n, n2, units);
            ++n2;
        }
        return DatumVector.newDatumVector(dArray, units);
    }

    public static DatumVector getYTagsDatumVector(TableDataSet tableDataSet, int n) {
        Units units = tableDataSet.getYUnits();
        DatumVector datumVector = DatumVector.newDatumVector(TableUtil.getYTagArrayDouble(tableDataSet, n, units), units);
        return datumVector;
    }

    public static void dumpToAsciiStream(TableDataSet tableDataSet, Datum datum, Datum datum2, OutputStream outputStream) {
        PrintStream printStream = new PrintStream(outputStream);
        Datum datum3 = null;
        Units units = null;
        printStream.print("This is not a das2 stream, even though it looks like it.");
        printStream.print("[00]");
        printStream.println("<stream start=\"" + datum + "\" end=\"" + datum2 + "\" >");
        printStream.println("<comment>Stream creation date: " + TimeUtil.now().toString() + "</comment>");
        printStream.print("</stream>");
        if (tableDataSet.getXUnits() instanceof LocationUnits && (units = ((LocationUnits)(datum3 = datum).getUnits()).getOffsetUnits()) == Units.microseconds) {
            units = Units.seconds;
        }
        printStream.print("[01]<packet>\n");
        printStream.print("<x type=\"asciiTab10\" ");
        if (datum3 != null) {
            printStream.print("base=\"" + datum3 + "\" ");
            printStream.print(" xUnits=\"" + units + "\" ");
        } else {
            printStream.print(" xUnits=\"" + tableDataSet.getXUnits());
        }
        printStream.println(" />");
        String string = "" + tableDataSet.getYTagDatum(0, 0);
        int n = 1;
        while (n < tableDataSet.getYLength(0)) {
            string = string + ", " + tableDataSet.getYTagDatum(0, n);
            ++n;
        }
        printStream.println("<yscan type=\"asciiTab10\" zUnits=\"" + tableDataSet.getZUnits() + "\" yTags=\"" + string + "\"/>");
        printStream.print("</packet>");
        DecimalFormat decimalFormat = new DecimalFormat("00000.000");
        DecimalFormat decimalFormat2 = new DecimalFormat("0.00E00");
        double d = datum2.subtract(datum).doubleValue(units);
        int n2 = 0;
        while (n2 < tableDataSet.getXLength()) {
            double d2 = datum3 != null ? tableDataSet.getXTagDatum(n2).subtract(datum3).doubleValue(units) : tableDataSet.getXTagDouble(n2, tableDataSet.getXUnits());
            if (d2 >= 0.0 && d2 < d) {
                printStream.print(":01:");
                printStream.print(decimalFormat.format(d2) + " ");
                int n3 = tableDataSet.tableOfIndex(n2);
                int n4 = 0;
                while (n4 < tableDataSet.getYLength(n3)) {
                    String string2 = n4 + 1 == tableDataSet.getYLength(n3) ? "\n" : " ";
                    printStream.print(FixedWidthFormatter.format(decimalFormat2.format(tableDataSet.getDouble(n2, n4, tableDataSet.getZUnits())), 9) + string2);
                    ++n4;
                }
            }
            ++n2;
        }
        printStream.close();
    }

    public static void dumpToAsciiStream(TableDataSet tableDataSet, OutputStream outputStream) {
        TableUtil.dumpToAsciiStream(tableDataSet, Channels.newChannel(outputStream));
    }

    public static void dumpToAsciiStream(TableDataSet tableDataSet, WritableByteChannel writableByteChannel) {
        TableUtil.dumpToDas2Stream(tableDataSet, writableByteChannel, true);
    }

    public static void dumpToDas2Stream(TableDataSet tableDataSet, OutputStream outputStream, boolean bl) {
        TableUtil.dumpToDas2Stream(tableDataSet, Channels.newChannel(outputStream), bl);
    }

    public static void dumpToBinaryStream(TableDataSet tableDataSet, OutputStream outputStream) {
        TableUtil.dumpToDas2Stream(tableDataSet, Channels.newChannel(outputStream), false);
    }

    private static void dumpToDas2Stream(TableDataSet tableDataSet, WritableByteChannel writableByteChannel, boolean bl) {
        try {
            DataTransferType dataTransferType;
            DataTransferType dataTransferType2;
            StreamProducer streamProducer = new StreamProducer(writableByteChannel);
            StreamDescriptor streamDescriptor = new StreamDescriptor();
            streamDescriptor.setProperty("start", tableDataSet.getXTagDatum(0).toString());
            streamDescriptor.setProperty("end", tableDataSet.getXTagDatum(tableDataSet.getXLength() - 1));
            if (TimeUtil.now().lt(TimeUtil.createValid("2004-05-19"))) {
                streamDescriptor.setProperty("comment", "This *IS* a das2 stream, and it looks like it.");
            }
            if (bl) {
                dataTransferType2 = DataTransferType.getByName("ascii10");
                dataTransferType = DataTransferType.getByName("ascii24");
            } else {
                dataTransferType2 = DataTransferType.getByName("sun_real4");
                dataTransferType = DataTransferType.getByName("sun_real8");
            }
            streamProducer.streamDescriptor(streamDescriptor);
            DatumVector[] datumVectorArray = new DatumVector[1];
            int n = 0;
            while (n < tableDataSet.tableCount()) {
                StreamXDescriptor streamXDescriptor = new StreamXDescriptor();
                streamXDescriptor.setDataTransferType(dataTransferType);
                streamXDescriptor.setUnits(tableDataSet.getXUnits());
                StreamYScanDescriptor streamYScanDescriptor = new StreamYScanDescriptor();
                streamYScanDescriptor.setDataTransferType(dataTransferType2);
                streamYScanDescriptor.setZUnits(tableDataSet.getZUnits());
                streamYScanDescriptor.setYCoordinates(tableDataSet.getYTags(n));
                PacketDescriptor packetDescriptor = new PacketDescriptor();
                packetDescriptor.setXDescriptor(streamXDescriptor);
                packetDescriptor.addYDescriptor(streamYScanDescriptor);
                streamProducer.packetDescriptor(packetDescriptor);
                int n2 = tableDataSet.tableStart(n);
                while (n2 < tableDataSet.tableEnd(n)) {
                    Datum datum = tableDataSet.getXTagDatum(n2);
                    datumVectorArray[0] = tableDataSet.getScan(n2);
                    streamProducer.packet(packetDescriptor, datum, datumVectorArray);
                    ++n2;
                }
                ++n;
            }
            streamProducer.streamClosed(streamDescriptor);
        }
        catch (StreamException streamException) {
            throw new RuntimeException(streamException);
        }
    }

    public static int getPreviousRow(TableDataSet tableDataSet, int n, Datum datum) {
        int n2 = TableUtil.closestRow(tableDataSet, n, datum);
        if (n2 > 0 && tableDataSet.getYTagDatum(n, n2).gt(datum)) {
            return n2 - 1;
        }
        return n2;
    }

    public static int getNextRow(TableDataSet tableDataSet, int n, Datum datum) {
        int n2 = TableUtil.closestRow(tableDataSet, n, datum);
        if (n2 < tableDataSet.getXLength() - 1 && tableDataSet.getYTagDatum(n, n2).lt(datum)) {
            return n2 + 1;
        }
        return n2;
    }
}

