/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset.test;

import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.VectorDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;

public class OrbitVectorDataSet
implements VectorDataSet {
    static double[][] data;
    private double[][] idata;
    private static OrbitVectorDataSet xview;
    private static OrbitVectorDataSet yview;
    Units xunits;
    Units yunits;
    Units tunits;
    int view;

    private OrbitVectorDataSet(int n) {
        data = new double[3][40];
        int n2 = 0;
        while (n2 < data[0].length) {
            OrbitVectorDataSet.data[0][n2] = 5.0 * Math.sin((double)(n2 * 1 * 2) * Math.PI / 40.0);
            OrbitVectorDataSet.data[1][n2] = 5.0 * Math.cos((double)n2 * 1.55 * 2.0 * Math.PI / 40.0);
            OrbitVectorDataSet.data[2][n2] = n2;
            ++n2;
        }
        this.yunits = this.tunits = Units.dimensionless;
        this.xunits = this.tunits;
        this.view = n;
    }

    public static OrbitVectorDataSet create() {
        return xview;
    }

    public Datum getDatum(int n) {
        return this.yunits.createDatum(this.getDouble(n, this.yunits));
    }

    public double getDouble(int n, Units units) {
        return data[this.view][n];
    }

    public int getInt(int n, Units units) {
        return (int)this.getDouble(n, units);
    }

    public DataSet getPlanarView(String string) {
        if ("x".equals(string)) {
            return xview;
        }
        if ("y".equals(string)) {
            return yview;
        }
        throw new IllegalArgumentException("No such plane");
    }

    public Object getProperty(String string) {
        return null;
    }

    public int getXLength() {
        return data[0].length;
    }

    public Datum getXTagDatum(int n) {
        return this.tunits.createDatum(this.getXTagDouble(n, this.tunits));
    }

    public double getXTagDouble(int n, Units units) {
        return this.tunits.convertDoubleTo(units, data[2][n]);
    }

    public int getXTagInt(int n, Units units) {
        return (int)this.getXTagDouble(n, this.tunits);
    }

    public Units getXUnits() {
        return this.tunits;
    }

    public Units getYUnits() {
        if (this.view == 0) {
            return this.xunits;
        }
        return this.yunits;
    }

    static {
        xview = new OrbitVectorDataSet(0);
        yview = new OrbitVectorDataSet(1);
    }
}

