/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.dataset.test;

import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetDescriptor;
import edu.uiowa.physics.pw.das.dataset.DefaultVectorDataSet;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.util.DasProgressMonitor;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;

public class SineWaveDataSetDescriptor
extends DataSetDescriptor {
    Datum amplitude;
    Datum period;
    Datum phase;

    public SineWaveDataSetDescriptor(Datum datum, Datum datum2) {
        super(null);
        this.amplitude = datum;
        this.period = datum2;
        this.phase = null;
    }

    public DataSet getDataSetImpl(Datum datum, Datum datum2, Datum datum3, DasProgressMonitor dasProgressMonitor) throws DasException {
        Object object;
        int n = (int)(datum2.subtract(datum).doubleValue(datum3.getUnits()) / datum3.doubleValue(datum3.getUnits()));
        int n2 = 5;
        n /= n2;
        if (this.phase == null) {
            this.phase = datum;
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        Units units = this.phase.getUnits();
        Units units2 = this.period.getUnits();
        Units units3 = this.amplitude.getUnits();
        int n3 = 0;
        while (n3 < n) {
            object = datum.add(datum3.multiply(n3 * n2));
            double d = this.amplitude.doubleValue(units3) * Math.sin(Math.PI * 2 * (((Datum)object).subtract(this.phase).doubleValue(units2) / this.period.doubleValue(units2)));
            dArray2[n3] = ((Datum)object).doubleValue(units);
            dArray[n3] = d;
            ++n3;
        }
        object = new DefaultVectorDataSet(dArray2, units, dArray, units3, new HashMap());
        return object;
    }

    public Units getXUnits() {
        return this.period.getUnits();
    }

    public static SineWaveDataSetDescriptor newDataSetDescriptor(Map map) throws DasException {
        String string = (String)map.get("period");
        String string2 = (String)map.get("xUnits");
        String string3 = (String)map.get("amplitude");
        String string4 = (String)map.get("yUnits");
        if (string == null || string3 == null) {
            throw new DasException("period and amplitude must be specified for SineWaveDataSetDescriptors");
        }
        Units units = string2 == null ? Units.dimensionless : Units.getByName(string2);
        Units units2 = string2 == null ? Units.dimensionless : Units.getByName(string4);
        try {
            Datum datum = units.getOffsetUnits().parse(string);
            Datum datum2 = units2.parse(string3);
            return new SineWaveDataSetDescriptor(datum2, datum);
        }
        catch (ParseException parseException) {
            throw new DasException(parseException.getMessage());
        }
    }
}

