/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.datum;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.Units;

public final class DatumVector {
    private final Units units;
    private final Object store;
    private final int offset;
    private final int length;

    private DatumVector(double[] dArray, int n, int n2, Units units) {
        this(dArray, n, n2, units, true);
    }

    private DatumVector(double[] dArray, int n, int n2, Units units, boolean bl) {
        if (bl) {
            this.store = new double[n2];
            int n3 = 0;
            while (n3 < n2) {
                ((double[])this.store)[n3] = dArray[n + n3];
                ++n3;
            }
            n = 0;
        } else {
            this.store = dArray;
        }
        this.offset = n;
        this.units = units;
        this.length = n2;
    }

    public DatumVector getSubVector(int n, int n2) {
        if (n == 0 && n2 == this.length) {
            return this;
        }
        return new DatumVector((double[])this.store, this.offset + n, n2 - n, this.units, false);
    }

    public Datum get(int n) {
        return Datum.create(((double[])this.store)[n + this.offset], this.units);
    }

    public Units getUnits() {
        return this.units;
    }

    public double doubleValue(int n, Units units) {
        return this.units.convertDoubleTo(units, ((double[])this.store)[n + this.offset]);
    }

    public double[] toDoubleArray(Units units) {
        return this.toDoubleArray(null, units);
    }

    public double[] toDoubleArray(double[] dArray, Units units) {
        if (dArray == null || dArray.length < this.length) {
            dArray = new double[this.length];
        }
        System.arraycopy(this.store, this.offset, dArray, 0, this.length);
        return dArray;
    }

    public static DatumVector newDatumVector(double[] dArray, Units units) {
        return DatumVector.newDatumVector(dArray, 0, dArray.length, units);
    }

    public static DatumVector newDatumVector(double[] dArray, int n, int n2, Units units) {
        return new DatumVector(dArray, n, n2, units);
    }

    public int getLength() {
        return this.length;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = 0;
        while (n < this.getLength()) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.get(n).toString());
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

