/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.datum;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.TimeLocationUnits;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.datum.UnitsConverter;
import edu.uiowa.physics.pw.das.datum.format.TimeDatumFormatter;
import edu.uiowa.physics.pw.das.util.DasDie;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.TimeZone;

public final class TimeUtil {
    private static final int[][] daysInMonth = new int[][]{{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31, 0}, {0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31, 0}};
    private static final int[][] dayOffset = new int[][]{{0, 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365}, {0, 0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, 366}};
    public static final int YEAR = 1;
    public static final int MONTH = 2;
    public static final int DAY = 3;
    public static final int HOUR = 4;
    public static final int MINUTE = 5;
    public static final int SECOND = 6;
    public static final int WEEK = 97;
    public static final int QUARTER = 98;

    private TimeUtil() {
    }

    public static int daysInMonth(int n, int n2) {
        return daysInMonth[TimeUtil.isLeapYear(n2) ? 1 : 0][n];
    }

    public static int julday(int n, int n2, int n3) {
        int n4 = 367 * n3 - 7 * (n3 + (n + 9) / 12) / 4 - 3 * ((n3 + (n - 9) / 7) / 100 + 1) / 4 + 275 * n / 9 + n2 + 1721029;
        return n4;
    }

    public static int dayOfYear(int n, int n2, int n3) {
        return n2 + dayOffset[TimeUtil.isLeapYear(n3) ? 1 : 0][n];
    }

    public static double getSecondsSinceMidnight(Datum datum) {
        double d = datum.doubleValue(Units.t2000);
        if (d < 0.0) {
            if ((d %= 86400.0) == 0.0) {
                return 0.0;
            }
            return 86400.0 + d;
        }
        return d % 86400.0;
    }

    public static int getJulianDay(Datum datum) {
        double d = datum.doubleValue(Units.mj1958);
        return (int)Math.floor(d) + 2436205;
    }

    public static Datum toDatum(TimeStruct timeStruct) {
        int n = timeStruct.year;
        int n2 = timeStruct.month;
        int n3 = timeStruct.day;
        int n4 = 367 * n - 7 * (n + (n2 + 9) / 12) / 4 - 3 * ((n + (n2 - 9) / 7) / 100 + 1) / 4 + 275 * n2 / 9 + n3 + 1721029;
        int n5 = timeStruct.hour;
        int n6 = timeStruct.minute;
        double d = timeStruct.seconds + (double)((float)n5 * 3600.0f) + (double)((float)n6 * 60.0f);
        double d2 = UnitsConverter.getConverter(Units.mj1958, Units.us2000).convert((double)(n4 - 2436205) + d / 86400.0);
        return Datum.create(d2, (Units)Units.us2000);
    }

    public static TimeStruct toTimeStruct(Datum datum) {
        int n = TimeUtil.getJulianDay(datum);
        double d = TimeUtil.getSecondsSinceMidnight(datum);
        int n2 = (int)(((double)(n - 1867216) - 0.25) / 36524.25);
        int n3 = n + 1 + n2 - n2 / 4;
        int n4 = n3 + 1524;
        int n5 = 6680 + (int)(((double)(n4 - 2439870) - 122.1) / 365.25);
        int n6 = 365 * n5 + n5 / 4;
        int n7 = (int)((double)(n4 - n6) / 30.6001);
        int n8 = n4 - n6 - (int)(30.6001 * (double)n7);
        int n9 = n7 - 1;
        n9 = (n9 - 1) % 12 + 1;
        int n10 = n5 - 4715;
        int n11 = (int)(d / 3600.0);
        int n12 = (int)((d - (double)n11 * 3600.0) / 60.0);
        double d2 = d - (double)n11 * 3600.0 - (double)n12 * 60.0;
        TimeStruct timeStruct = new TimeStruct();
        timeStruct.year = n10 -= (n10 -= n9 > 2 ? 1 : 0) <= 0 ? 1 : 0;
        timeStruct.month = n9;
        timeStruct.day = n8;
        timeStruct.doy = TimeUtil.dayOfYear(n9, n8, n10);
        timeStruct.hour = n11;
        timeStruct.minute = n12;
        timeStruct.seconds = d2;
        return timeStruct;
    }

    public static boolean isLeapYear(int n) {
        return n % 4 == 0;
    }

    public static TimeStruct carry(TimeStruct timeStruct) {
        int n;
        TimeStruct timeStruct2 = timeStruct;
        if (timeStruct2.seconds >= 60.0) {
            timeStruct2.seconds -= 60.0;
            ++timeStruct2.minute;
        }
        if (timeStruct2.minute >= 60) {
            timeStruct2.minute -= 60;
            ++timeStruct2.hour;
        }
        if (timeStruct2.hour >= 24) {
            timeStruct2.hour -= 24;
            ++timeStruct2.day;
        }
        if (timeStruct2.day > (n = TimeUtil.daysInMonth(timeStruct2.month, timeStruct2.year))) {
            timeStruct2.day -= n;
            ++timeStruct2.month;
        }
        if (timeStruct2.month > 12) {
            timeStruct2.month -= 12;
            ++timeStruct2.year;
        }
        return timeStruct2;
    }

    public static TimeStruct borrow(TimeStruct timeStruct) {
        TimeStruct timeStruct2 = timeStruct;
        if (timeStruct2.seconds < 0.0) {
            timeStruct2.seconds += 60.0;
            --timeStruct2.minute;
        }
        if (timeStruct2.minute < 0) {
            timeStruct2.minute += 60;
            --timeStruct2.hour;
        }
        if (timeStruct2.hour < 0) {
            timeStruct2.hour += 24;
            --timeStruct2.day;
        }
        if (timeStruct2.day < 0 || timeStruct2.month < 1) {
            DasDie.die("Borrow operation not defined for months<1 or days<0");
        }
        if (timeStruct2.day == 0) {
            int n = timeStruct2.month > 1 ? TimeUtil.daysInMonth(timeStruct2.year, timeStruct2.month - 1) : 31;
            timeStruct2.day += n;
            --timeStruct2.month;
        }
        if (timeStruct2.month == 0) {
            timeStruct2.month += 12;
            --timeStruct2.year;
        }
        return timeStruct2;
    }

    public static TimeStruct normalize(TimeStruct timeStruct) {
        return TimeUtil.carry(TimeUtil.borrow(timeStruct));
    }

    public static Datum next(int n, Datum datum) {
        TimeStruct timeStruct = TimeUtil.toTimeStruct(datum);
        switch (n) {
            case 3: {
                ++timeStruct.day;
                break;
            }
            case 2: {
                ++timeStruct.month;
                timeStruct.day = 1;
                break;
            }
            case 98: {
                timeStruct.month = (timeStruct.month - 1 + 3) / 3 * 3 + 1;
                timeStruct.day = 1;
                break;
            }
            case 1: {
                ++timeStruct.year;
                timeStruct.month = 1;
                timeStruct.day = 1;
                break;
            }
        }
        timeStruct.hour = 0;
        timeStruct.minute = 0;
        timeStruct.seconds = 0.0;
        if (timeStruct.month > 12) {
            ++timeStruct.year;
            timeStruct.month -= 12;
        }
        Datum datum2 = TimeUtil.toDatum(timeStruct);
        return datum2;
    }

    public static Datum nextMonth(Datum datum) {
        return TimeUtil.next(2, datum);
    }

    public static Datum prev(int n, Datum datum) {
        TimeStruct timeStruct = TimeUtil.toTimeStruct(datum);
        switch (n) {
            case 1: {
                timeStruct.month = 1;
            }
            case 98: {
                timeStruct.month = (timeStruct.month - 1) / 3 * 3 + 1;
            }
            case 2: {
                timeStruct.day = 1;
            }
            case 3: {
                timeStruct.hour = 0;
            }
            case 4: {
                timeStruct.minute = 0;
            }
            case 5: {
                timeStruct.seconds = 0.0;
            }
            case 6: {
                timeStruct.seconds = (int)timeStruct.seconds;
            }
        }
        Datum datum2 = TimeUtil.toDatum(timeStruct);
        if (datum2.equals(datum)) {
            return TimeUtil.prev(n, datum.subtract(500.0, Units.microseconds));
        }
        return datum2;
    }

    public static Datum now() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        ((Calendar)gregorianCalendar).setTimeZone(TimeZone.getTimeZone("GMT"));
        int n = gregorianCalendar.get(11);
        int n2 = gregorianCalendar.get(12);
        int n3 = gregorianCalendar.get(13);
        int n4 = gregorianCalendar.get(1);
        int n5 = gregorianCalendar.get(6);
        DecimalFormat decimalFormat = new DecimalFormat("000");
        try {
            return TimeUtil.create(n4 + "//" + decimalFormat.format(n5) + " " + n + ":" + n2 + ":" + n3);
        }
        catch (ParseException parseException) {
            throw new IllegalStateException(parseException.getMessage());
        }
    }

    public static double convert(int n, int n2, int n3, int n4, int n5, double d, TimeLocationUnits timeLocationUnits) {
        int n6;
        if (n2 > 0) {
            n6 = TimeUtil.julday(n2, n3, n);
        } else {
            int n7 = 1;
            int n8 = 1;
            n6 = TimeUtil.julday(n7, n8, n);
            n6 += n3 - 1;
        }
        double d2 = (double)(n6 - 2451545) * 8.64E10 + (d += (double)n4 * 3600.0 + (double)n5 * 60.0) * 1000000.0;
        if (timeLocationUnits == Units.us2000) {
            return d2;
        }
        return Units.us2000.convertDoubleTo(timeLocationUnits, d2);
    }

    /*
     * Unable to fully structure code
     */
    public static final TimeStruct parseTime(String var0) throws ParseException {
        var19_1 = new String[]{"january", "febuary", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december"};
        var20_2 = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        var28_3 = new String[10];
        var29_4 = new boolean[7];
        Arrays.fill(var29_4, false);
        var21_5 = " \t/-:,_;";
        var9_6 = var0.indexOf(90);
        if (var9_6 != -1) {
            var0 = var0.substring(0, var9_6);
        }
        if ((var22_7 = var0.indexOf(84)) != -1) {
            var9_6 = var22_7 - 1;
            if (Character.isDigit(var0.charAt(var9_6))) {
                var21_5 = " \t/-T:,_;";
            } else {
                var22_7 = -1;
            }
        }
        if (var22_7 == -1) {
            var27_8 = 0;
            var26_9 = var0.length();
            var24_10 = 0;
            while (var24_10 < var26_9) {
                var9_6 = var21_5.substring(2).indexOf(var0.charAt(var24_10));
                if (var9_6 != -1) {
                    ++var27_8;
                }
                if (var27_8 == 3) {
                    var22_7 = var24_10;
                    break;
                }
                ++var24_10;
            }
        }
        var23_11 = new GregorianCalendar();
        var23_11.setTime(new Date());
        var1_12 = var23_11.get(1);
        var2_13 = 0;
        var3_14 = 0;
        var4_15 = 0;
        var5_16 = 0;
        var6_17 = 0;
        var7_18 = 0.0;
        var37_19 = new StringTokenizer(var0, var21_5);
        if (!var37_19.hasMoreTokens()) {
            throw new ParseException("No tokens in '" + var0 + "'", 0);
        }
        var27_8 = 0;
        while (var27_8 < 10 && var37_19.hasMoreTokens()) {
            var28_3[var27_8] = var37_19.nextToken();
            ++var27_8;
        }
        var29_4[3] = true;
        var29_4[2] = true;
        var29_4[1] = true;
        var29_4[0] = true;
        var34_20 = 0;
        var36_21 = -1;
        var24_10 = 0;
        while (var24_10 < var27_8) {
            block70: {
                block71: {
                    block74: {
                        block72: {
                            block75: {
                                block73: {
                                    block69: {
                                        var36_21 = var0.indexOf(var28_3[var24_10], var36_21 + 1);
                                        if (var22_7 != -1 && var29_4[0] && var36_21 > var22_7) {
                                            var29_4[0] = false;
                                            var29_4[6] = true;
                                            var29_4[5] = true;
                                            var29_4[4] = true;
                                        }
                                        var26_9 = var28_3[var24_10].length();
                                        try {
                                            var32_24 = Double.parseDouble(var28_3[var24_10]);
                                            break block69;
                                        }
                                        catch (NumberFormatException var38_25) {
                                            if (var26_9 < 3 || !var29_4[0]) {
                                                throw new ParseException("Error at token '" + var28_3[var24_10] + "' in '" + var0 + "'", 0);
                                            }
                                            var25_22 = 0;
                                            ** while (var25_22 < 12)
                                        }
lbl-1000:
                                        // 1 sources

                                        {
                                            if (var28_3[var24_10].equalsIgnoreCase(var19_1[var25_22]) || var28_3[var24_10].equalsIgnoreCase(var20_2[var25_22])) {
                                                var2_13 = var25_22 + 1;
                                                var29_4[2] = false;
                                                if (var34_20 <= 0) break;
                                                if (var3_14 > 0) {
                                                    throw new ParseException("Ambiguous dates in token '" + var28_3[var24_10] + "' in '" + var0 + "'", 0);
                                                }
                                                var3_14 = var34_20;
                                                var34_20 = 0;
                                                var29_4[3] = false;
                                                break;
                                            }
                                            ++var25_22;
                                            continue;
                                        }
lbl81:
                                        // 3 sources

                                        if (var29_4[2]) {
                                            throw new ParseException("Error at token '" + var28_3[var24_10] + "' in '" + var0 + "'", 0);
                                        }
                                        break block70;
                                    }
                                    if (Math.IEEEremainder(var32_24, 1.0) != 0.0) {
                                        if (var29_4[6]) {
                                            var7_18 = var32_24;
                                            break;
                                        }
                                        throw new ParseException("Error at token '" + var28_3[var24_10] + "' in '" + var0 + "'", 0);
                                    }
                                    var31_23 = (int)var32_24;
                                    if (var31_23 < 0) {
                                        throw new ParseException("Error at token '" + var28_3[var24_10] + "' in '" + var0 + "'", 0);
                                    }
                                    if (!var29_4[0]) break block71;
                                    if (var31_23 == 0) {
                                        throw new ParseException("m,d, or y can't be 0 in '" + var0 + "'", 0);
                                    }
                                    if (var31_23 <= 31) break block72;
                                    if (!var29_4[1]) break block73;
                                    var1_12 = var31_23;
                                    if (var1_12 < 1000) {
                                        var1_12 += 1900;
                                    }
                                    var29_4[1] = false;
                                    break block74;
                                }
                                if (!var29_4[2]) break block75;
                                var29_4[2] = false;
                                var2_13 = 0;
                                var4_15 = var31_23;
                                var29_4[3] = false;
                                break block74;
                            }
                            throw new ParseException("Error at token '" + var28_3[var24_10] + "' in '" + var0 + "'", 0);
                        }
                        if (var31_23 <= 12) ** GOTO lbl129
                        if (var29_4[3]) {
                            if (var34_20 > 0) {
                                var2_13 = var34_20;
                                var29_4[2] = false;
                            }
                            if (var26_9 == 3) {
                                if (var2_13 > 0) {
                                    throw new ParseException("Error at token '" + var28_3[var24_10] + "' in '" + var0 + "'", 0);
                                }
                                var4_15 = var31_23;
                                var3_14 = 0;
                                var29_4[2] = false;
                            } else {
                                var3_14 = var31_23;
                            }
                            var29_4[3] = false;
                        } else {
                            throw new ParseException("Error at token '" + var28_3[var24_10] + "' in '" + var0 + "'", 0);
lbl129:
                            // 1 sources

                            if (!var29_4[2]) {
                                if (var2_13 > 0) {
                                    var3_14 = var31_23;
                                    var4_15 = 0;
                                } else {
                                    var4_15 = var31_23;
                                    var3_14 = 0;
                                }
                                var29_4[3] = false;
                            } else if (!var29_4[3]) {
                                if (var4_15 > 0) {
                                    throw new ParseException("Error at token '" + var28_3[var24_10] + "' in '" + var0 + "'", 0);
                                }
                                var2_13 = var31_23;
                                var29_4[2] = false;
                            } else if (!var29_4[1]) {
                                if (var26_9 == 3) {
                                    if (var2_13 > 0) {
                                        throw new ParseException("Error at token '" + var28_3[var24_10] + "' in '" + var0 + "'", 0);
                                    }
                                    var4_15 = var31_23;
                                    var3_14 = 0;
                                    var29_4[3] = false;
                                } else {
                                    if (var4_15 > 0) {
                                        throw new ParseException("Error at token '" + var28_3[var24_10] + "' in '" + var0 + "'", 0);
                                    }
                                    var2_13 = var31_23;
                                    if (var34_20 > 0) {
                                        var3_14 = var34_20;
                                        var29_4[3] = false;
                                    }
                                }
                                var29_4[2] = false;
                            } else if (var34_20 > 0) {
                                var2_13 = var34_20;
                                var34_20 = 0;
                                var29_4[2] = false;
                                var3_14 = var31_23;
                                var29_4[3] = false;
                            } else {
                                var34_20 = var31_23;
                            }
                        }
                    }
                    if (!(var29_4[1] || var29_4[2] || var29_4[3])) {
                        var29_4[0] = false;
                        var29_4[6] = true;
                        var29_4[5] = true;
                        var29_4[4] = true;
                    }
                    break block70;
                }
                if (var29_4[4]) {
                    if (var26_9 == 4) {
                        var34_20 = var31_23 / 100;
                        if (var34_20 > 23) {
                            throw new ParseException("Error at token '" + var28_3[var24_10] + "' in '" + var0 + "'", 0);
                        }
                        var5_16 = var34_20;
                        var34_20 = var31_23 % 100;
                        if (var34_20 > 59) {
                            throw new ParseException("Error at token '" + var28_3[var24_10] + "' in '" + var0 + "'", 0);
                        }
                        var6_17 = var34_20;
                        var29_4[5] = false;
                    } else {
                        if (var31_23 > 23) {
                            throw new ParseException("Error at token '" + var28_3[var24_10] + "' in '" + var0 + "'", 0);
                        }
                        var5_16 = var31_23;
                    }
                    var29_4[4] = false;
                } else if (var29_4[5]) {
                    if (var31_23 > 59) {
                        throw new ParseException("Error at token '" + var28_3[var24_10] + "' in '" + var0 + "'", 0);
                    }
                    var6_17 = var31_23;
                    var29_4[5] = false;
                } else if (var29_4[6]) {
                    if (var31_23 > 61) {
                        throw new ParseException("Error at token '" + var28_3[var24_10] + "' in '" + var0 + "'", 0);
                    }
                    var7_18 = var31_23;
                    var29_4[6] = false;
                } else {
                    throw new ParseException("Error at token '" + var28_3[var24_10] + "' in '" + var0 + "'", 0);
                }
            }
            ++var24_10;
        }
        if (var2_13 > 12) {
            throw new ParseException("Month is greater than 12 in '" + var0 + "'", 0);
        }
        if (var2_13 > 0 && var3_14 <= 0) {
            var3_14 = 1;
        }
        v0 = (var1_12 & 3) > 0 ? 0 : (var1_12 % 100 > 0 ? 1 : (var35_27 = var1_12 % 400 > 0 ? 0 : 1));
        if (var2_13 > 0 && var3_14 > 0 && var4_15 == 0) {
            if (var3_14 > TimeUtil.daysInMonth[var35_27][var2_13]) {
                throw new ParseException("day of month too high in '" + var0 + "'", 0);
            }
            var4_15 = TimeUtil.dayOffset[var35_27][var2_13] + var3_14;
        } else if (var4_15 > 0 && var2_13 == 0 && var3_14 == 0) {
            if (var4_15 > 365 + var35_27) {
                throw new ParseException("day of year too high in '" + var0 + "'", 0);
            }
            var24_10 = 2;
            while (var24_10 < 14 && var4_15 > TimeUtil.dayOffset[var35_27][var24_10]) {
                ++var24_10;
            }
            var2_13 = --var24_10;
            var3_14 = var4_15 - TimeUtil.dayOffset[var35_27][var24_10];
        } else {
            throw new ParseException("Need month/day or doy in '" + var0 + "'", 0);
        }
        var38_26 = new TimeStruct();
        var38_26.year = var1_12;
        var38_26.month = var2_13;
        var38_26.day = var3_14;
        var38_26.doy = var4_15;
        var38_26.hour = var5_16;
        var38_26.minute = var6_17;
        var38_26.seconds = var7_18;
        return var38_26;
    }

    public static Datum create(String string) throws ParseException {
        TimeStruct timeStruct = TimeUtil.parseTime(string);
        return TimeUtil.toDatum(timeStruct);
    }

    public static Datum createValid(String string) {
        try {
            return TimeUtil.create(string);
        }
        catch (ParseException parseException) {
            throw new RuntimeException(parseException);
        }
    }

    public static boolean isValidTime(String string) {
        try {
            TimeUtil.create(string);
            return true;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println(TimeUtil.now());
        System.out.println(Datum.create(TimeUtil.convert(2000, 1, 2, 0, 0, 0.0, Units.us2000), (Units)Units.us2000));
        Datum datum = TimeUtil.create("2000-1-1 0:00:33.45");
        System.out.println(datum);
        TimeStruct timeStruct = TimeUtil.toTimeStruct(datum);
        System.out.println(TimeUtil.toDatum(timeStruct));
        TimeDatumFormatter timeDatumFormatter = TimeDatumFormatter.DEFAULT;
        int n = 0;
        while (n < 44) {
            System.out.println(timeDatumFormatter.format(datum) + "\t" + (long)datum.doubleValue(Units.us2000));
            datum = TimeUtil.prev(6, datum);
            ++n;
        }
    }

    public static Datum prevMidnight(Datum datum) {
        return datum.subtract(TimeUtil.getSecondsSinceMidnight(datum), Units.seconds);
    }

    public static final class TimeStruct {
        public int year;
        public int month;
        public int day;
        public int doy;
        public int hour;
        public int minute;
        public double seconds;

        public String toString() {
            return this.year + "/" + this.month + "/" + this.day + " " + this.hour + ":" + this.minute + ":" + this.seconds;
        }
    }
}

