/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.event;

import edu.uiowa.physics.pw.das.DasProperties;
import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetConsumer;
import edu.uiowa.physics.pw.das.dataset.TableDataSet;
import edu.uiowa.physics.pw.das.dataset.TableDataSetConsumer;
import edu.uiowa.physics.pw.das.dataset.TableUtil;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.format.DatumFormatter;
import edu.uiowa.physics.pw.das.datum.format.DefaultDatumFormatterFactory;
import edu.uiowa.physics.pw.das.event.DragRenderer;
import edu.uiowa.physics.pw.das.event.MouseDragEvent;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.DasStackedHistogramPlot;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.ParseException;

public class CrossHairRenderer
implements DragRenderer {
    protected int xInitial;
    protected int yInitial;
    protected DataSet ds;
    protected DasAxis XAxis;
    protected DasAxis YAxis;
    protected DasPlot parent;
    private int ix = 0;
    private int iy = 0;
    private int context;
    private DatumFormatter nfx;
    private DatumFormatter nfy;
    private DatumFormatter nfz;
    private FontMetrics fm;
    private int dxMax = -999999;
    private Rectangle dirtyBounds;
    private Rectangle hDirtyBounds;
    private Rectangle vDirtyBounds;
    private Point crossHairLocation = null;
    private DataSetConsumer dataSetConsumer;

    public CrossHairRenderer(DasPlot dasPlot, DataSetConsumer dataSetConsumer, DasAxis dasAxis, DasAxis dasAxis2) {
        this.XAxis = dasAxis;
        this.YAxis = dasAxis2;
        this.parent = dasPlot;
        this.dataSetConsumer = dataSetConsumer;
        this.dirtyBounds = new Rectangle();
        this.hDirtyBounds = new Rectangle();
        this.vDirtyBounds = new Rectangle();
    }

    public void renderDrag(Graphics graphics, Point point, Point point2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHints(DasProperties.getRenderingHints());
        this.ds = this.dataSetConsumer.getDataSet();
        if (this.crossHairLocation == null) {
            String string;
            Object object;
            Object object2;
            Datum datum = this.XAxis.invTransform(point2.x + this.parent.getX());
            Datum datum2 = this.YAxis.invTransform(point2.y + this.parent.getY());
            this.nfy = datum2.getFormatter();
            this.nfx = datum.getFormatter();
            String string2 = this.nfx.format(datum);
            String string3 = this.nfy.format(datum2);
            String string4 = "";
            if (this.ds instanceof TableDataSet) {
                object2 = (TableDataSet)this.ds;
                object = TableUtil.closestDatum((TableDataSet)object2, datum, datum2);
                try {
                    if (this.dataSetConsumer instanceof TableDataSetConsumer) {
                        this.nfz = ((TableDataSetConsumer)this.dataSetConsumer).getZAxis().getDatumFormatter();
                        this.nfz = DefaultDatumFormatterFactory.getInstance().newFormatter(this.nfz.toString() + "0");
                    } else if (this.parent instanceof DasStackedHistogramPlot) {
                        this.nfz = ((DasStackedHistogramPlot)this.parent).getZAxis().getDatumFormatter();
                        this.nfz = DefaultDatumFormatterFactory.getInstance().newFormatter(this.nfz.toString() + "0");
                    } else {
                        this.nfz = DefaultDatumFormatterFactory.getInstance().newFormatter("0.00");
                    }
                }
                catch (ParseException parseException) {
                    DasProperties.getLogger().severe("failure to create formatter");
                    DasAxis dasAxis = ((TableDataSetConsumer)this.dataSetConsumer).getZAxis();
                    dasAxis.getUnits().getDatumFormatterFactory().defaultFormatter();
                }
                string4 = ((Datum)object).isFill() ? "fill" : this.nfz.format((Datum)object);
                string = "x:" + string2 + " y:" + string3 + " z:" + string4;
            } else {
                string = "x:" + string2 + " y:" + string3;
            }
            this.fm = this.parent.getGraphics().getFontMetrics();
            object2 = graphics2D.getColor();
            graphics2D.setColor(new Color(255, 255, 255, 200));
            object = this.parent.getSize();
            int n = this.fm.stringWidth(string) + 6;
            if (this.dxMax < n) {
                this.dxMax = n;
            }
            int n2 = this.fm.getAscent() + this.fm.getDescent();
            int n3 = point2.x + 3;
            int n4 = point2.y - 3 - n2;
            if (n3 + this.dxMax > ((Dimension)object).width - 3 && point2.x - 3 - n > 0) {
                n3 = point2.x - 3 - n;
            }
            if (n4 < 13) {
                n4 = point2.y + 3;
            }
            this.dirtyBounds.setRect(n3, n4, n, n2);
            graphics2D.fill(this.dirtyBounds);
            graphics2D.setColor(new Color(20, 20, 20));
            graphics2D.drawString(string, n3 + 3, n4 + this.fm.getAscent());
            graphics2D.setColor((Color)object2);
        }
        this.drawCrossHair(graphics2D, point2);
    }

    public MouseDragEvent getMouseDragEvent(Object object, Point point, Point point2, boolean bl) {
        return null;
    }

    private void drawCrossHair(Graphics graphics, Point point) {
        Graphics graphics2 = graphics.create();
        graphics2.setColor(Color.black);
        Dimension dimension = this.parent.getSize();
        this.hDirtyBounds.setBounds(0, point.y, dimension.width, 1);
        graphics2.drawLine(0, point.y, dimension.width, point.y);
        this.vDirtyBounds.setBounds(point.x, 0, 1, dimension.height);
        graphics2.drawLine(point.x, 0, point.x, dimension.height);
        graphics2.dispose();
    }

    public void clear(Graphics graphics) {
        if (this.crossHairLocation != null) {
            this.drawCrossHair(graphics, this.crossHairLocation);
        }
        this.parent.paintImmediately(this.dirtyBounds);
        this.parent.paintImmediately(this.hDirtyBounds);
        this.parent.paintImmediately(this.vDirtyBounds);
        boolean bl = true;
    }

    public boolean isXRangeSelection() {
        return false;
    }

    public boolean isYRangeSelection() {
        return false;
    }

    public boolean isPointSelection() {
        return true;
    }

    public boolean isUpdatingDragSelection() {
        return false;
    }
}

