/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.event;

import edu.uiowa.physics.pw.das.event.DragRenderer;
import edu.uiowa.physics.pw.das.event.Gesture;
import edu.uiowa.physics.pw.das.event.MouseDragEvent;
import edu.uiowa.physics.pw.das.event.MouseRangeGestureSelectionEvent;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.util.DasDie;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public class GesturesRenderer
implements DragRenderer {
    DasCanvasComponent parent;
    Rectangle dirtyBounds;

    public GesturesRenderer(DasCanvasComponent dasCanvasComponent) {
        this.parent = dasCanvasComponent;
        this.dirtyBounds = new Rectangle();
    }

    public MouseDragEvent getMouseDragEvent(Object object, Point point, Point point2, boolean bl) {
        Gesture gesture = null;
        double d = point2.x - point.x;
        double d2 = -1 * (point2.y - point.y);
        double d3 = Math.atan2(d2, d) * 180.0 / Math.PI;
        double d4 = Math.sqrt(d2 * d2 + d * d);
        int n = ((Component)object).getWidth();
        int n2 = ((Component)object).getLocation().x;
        if (d4 < 20.0 && d4 > 4.0) {
            if (point.x - n2 < 10 && point.x - n2 >= 0 && point2.x - n2 < 0) {
                gesture = Gesture.SCANPREV;
            } else if (point.x - n2 > n - 10 && point.x - n2 < n && point2.x - n2 >= n) {
                gesture = Gesture.SCANNEXT;
            } else if (Math.abs(d3) > 160.0) {
                gesture = Gesture.BACK;
            } else if (-110.0 < d3 && d3 < -70.0) {
                gesture = Gesture.ZOOMOUT;
            } else if (Math.abs(d3) < 30.0) {
                gesture = Gesture.FORWARD;
            }
        } else {
            gesture = Gesture.UNDEFINED;
        }
        return new MouseRangeGestureSelectionEvent(object, 0, 0, gesture);
    }

    public void renderDrag(Graphics graphics, Point point, Point point2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d = point2.x - point.x;
        double d2 = -1 * (point2.y - point.y);
        double d3 = Math.atan2(d2, d) * 180.0 / Math.PI;
        double d4 = Math.sqrt(d2 * d2 + d * d);
        int n = this.parent.getWidth();
        int n2 = 0;
        if (d4 > 4.0) {
            Color color = graphics2D.getColor();
            int n3 = 0;
            while (n3 < 2) {
                if (n3 == 0) {
                    graphics2D.setColor(new Color(255, 255, 255, 100));
                    graphics2D.setStroke(new BasicStroke(3.0f, 1, 1));
                } else {
                    graphics2D.setColor(color);
                    graphics2D.setStroke(new BasicStroke());
                }
                if (point.x - n2 < 10 && point.x - n2 >= 0 && point2.x - n2 < 0) {
                    graphics2D.drawLine(point.x, point.y - 5, point.x - 5, point.y);
                    graphics2D.drawLine(point.x - 5, point.y, point.x, point.y + 5);
                    graphics2D.drawLine(point.x, point.y + 5, point.x, point.y - 5);
                    DasDie.println("zoomprev");
                } else if (point.x - n2 > n - 10 && point.x - n2 < n && point2.x - n2 >= n) {
                    graphics2D.drawLine(point.x, point.y - 5, point.x + 5, point.y);
                    graphics2D.drawLine(point.x + 5, point.y, point.x, point.y + 5);
                    graphics2D.drawLine(point.x, point.y + 5, point.x, point.y - 5);
                    DasDie.println("zoomnext");
                } else if (Math.abs(d3) > 160.0) {
                    graphics2D.drawLine(point.x, point.y, point.x - 5, point.y);
                    graphics2D.drawLine(point.x - 5, point.y, point.x - 3, point.y - 2);
                    graphics2D.drawLine(point.x - 5, point.y, point.x - 3, point.y + 2);
                } else if (-110.0 < d3 && d3 < -70.0) {
                    graphics2D.drawLine(point.x, point.y, point.x, point.y + 5);
                    graphics2D.drawLine(point.x - 2, point.y + 3, point.x, point.y + 5);
                    graphics2D.drawLine(point.x + 2, point.y + 3, point.x, point.y + 5);
                } else if (Math.abs(d3) < 30.0) {
                    graphics2D.drawLine(point.x, point.y, point.x + 5, point.y);
                    graphics2D.drawLine(point.x + 5, point.y, point.x + 3, point.y - 2);
                    graphics2D.drawLine(point.x + 5, point.y, point.x + 3, point.y + 2);
                }
                this.dirtyBounds.setRect(point.x - 10, point.y - 10, 20.0, 20.0);
                ++n3;
            }
        }
    }

    public void clear(Graphics graphics) {
        this.parent.paintImmediately(this.dirtyBounds);
    }

    protected Rectangle getDirtyBounds() {
        return this.dirtyBounds;
    }

    public boolean isXRangeSelection() {
        return true;
    }

    public boolean isYRangeSelection() {
        return true;
    }

    public boolean isPointSelection() {
        return false;
    }

    public boolean isUpdatingDragSelection() {
        return false;
    }
}

