/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.event;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.event.DataRangeSelectionEvent;
import edu.uiowa.physics.pw.das.event.DataRangeSelectionListener;
import edu.uiowa.physics.pw.das.event.Gesture;
import edu.uiowa.physics.pw.das.event.HorizontalRangeGesturesRenderer;
import edu.uiowa.physics.pw.das.event.MouseDragEvent;
import edu.uiowa.physics.pw.das.event.MouseModule;
import edu.uiowa.physics.pw.das.event.MouseRangeGestureSelectionEvent;
import edu.uiowa.physics.pw.das.event.MouseRangeSelectionEvent;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.DasSpectrogramPlot;
import edu.uiowa.physics.pw.das.util.DasDie;
import javax.swing.event.EventListenerList;

public class HorizontalRangeSelectorMouseModule
extends MouseModule {
    DasAxis axis;
    private EventListenerList listenerList = null;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener;

    public HorizontalRangeSelectorMouseModule(DasCanvasComponent dasCanvasComponent, DasAxis dasAxis) {
        super(dasCanvasComponent, new HorizontalRangeGesturesRenderer(dasCanvasComponent), "Zoom X");
        if (!dasAxis.isHorizontal()) {
            throw new IllegalArgumentException("Axis orientation is not horizontal");
        }
        this.axis = dasAxis;
    }

    public static HorizontalRangeSelectorMouseModule create(DasPlot dasPlot) {
        DasAxis dasAxis = dasPlot.getXAxis();
        HorizontalRangeSelectorMouseModule horizontalRangeSelectorMouseModule = new HorizontalRangeSelectorMouseModule(dasPlot, dasPlot.getXAxis());
        return horizontalRangeSelectorMouseModule;
    }

    public void mouseRangeSelected(MouseDragEvent mouseDragEvent) {
        MouseRangeSelectionEvent mouseRangeSelectionEvent = (MouseRangeSelectionEvent)mouseDragEvent;
        DasDie.println("" + this.getHotSpots());
        MouseRangeGestureSelectionEvent mouseRangeGestureSelectionEvent = (MouseRangeGestureSelectionEvent)mouseRangeSelectionEvent;
        if (!mouseRangeGestureSelectionEvent.isGesture()) {
            Datum datum;
            Datum datum2 = this.axis.invTransform(mouseRangeSelectionEvent.getMinimum());
            Datum datum3 = this.axis.invTransform(mouseRangeSelectionEvent.getMaximum());
            Datum datum4 = this.axis.findTick(datum2, 0.0, true);
            if (datum4.equals(datum = this.axis.findTick(datum3, 0.0, true))) {
                datum2 = this.axis.findTick(datum2, -1.0, true);
                datum3 = this.axis.findTick(datum3, 1.0, true);
            } else {
                datum2 = datum4;
                datum3 = datum;
            }
            DataRangeSelectionEvent dataRangeSelectionEvent = new DataRangeSelectionEvent(mouseDragEvent.getSource(), datum2, datum3);
            this.fireDataRangeSelectionListenerDataRangeSelected(dataRangeSelectionEvent);
        } else if (mouseRangeGestureSelectionEvent.isBack()) {
            this.axis.setDataRangePrev();
        } else if (mouseRangeGestureSelectionEvent.isZoomOut()) {
            this.axis.setDataRangeZoomOut();
        } else if (mouseRangeGestureSelectionEvent.isForward()) {
            this.axis.setDataRangeForward();
        } else if (mouseRangeGestureSelectionEvent.getGesture() == Gesture.SCANPREV) {
            this.axis.scanPrevious();
        } else if (mouseRangeGestureSelectionEvent.getGesture() == Gesture.SCANNEXT) {
            this.axis.scanNext();
        }
    }

    public synchronized void addDataRangeSelectionListener(DataRangeSelectionListener dataRangeSelectionListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener == null ? (class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener = HorizontalRangeSelectorMouseModule.class$("edu.uiowa.physics.pw.das.event.DataRangeSelectionListener")) : class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener, dataRangeSelectionListener);
    }

    public synchronized void removeDataRangeSelectionListener(DataRangeSelectionListener dataRangeSelectionListener) {
        this.listenerList.remove(class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener == null ? (class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener = HorizontalRangeSelectorMouseModule.class$("edu.uiowa.physics.pw.das.event.DataRangeSelectionListener")) : class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener, dataRangeSelectionListener);
    }

    private void fireDataRangeSelectionListenerDataRangeSelected(DataRangeSelectionEvent dataRangeSelectionEvent) {
        if (this.parent instanceof DasSpectrogramPlot) {
            dataRangeSelectionEvent.setDataSet(((DasSpectrogramPlot)this.parent).getData());
        }
        if (this.listenerList == null) {
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener == null ? HorizontalRangeSelectorMouseModule.class$("edu.uiowa.physics.pw.das.event.DataRangeSelectionListener") : class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener)) {
                ((DataRangeSelectionListener)objectArray[n + 1]).DataRangeSelected(dataRangeSelectionEvent);
            }
            n -= 2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

