/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.event;

import edu.uiowa.physics.pw.das.dataset.DataSet;
import edu.uiowa.physics.pw.das.dataset.DataSetConsumer;
import edu.uiowa.physics.pw.das.dataset.TableDataSetConsumer;
import edu.uiowa.physics.pw.das.event.DataPointSelectionEvent;
import edu.uiowa.physics.pw.das.event.DataPointSelectionListener;
import edu.uiowa.physics.pw.das.event.HorizontalSliceSelectionRenderer;
import edu.uiowa.physics.pw.das.event.MouseModule;
import edu.uiowa.physics.pw.das.event.MousePointSelectionEvent;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.Renderer;
import javax.swing.event.EventListenerList;

public class HorizontalSlicerMouseModule
extends MouseModule {
    private DasAxis xaxis;
    private DasAxis yaxis;
    private TableDataSetConsumer dataSetConsumer;
    private DataPointSelectionEvent de;
    private EventListenerList listenerList = null;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$event$DataPointSelectionListener;

    public HorizontalSlicerMouseModule(DasPlot dasPlot, TableDataSetConsumer tableDataSetConsumer, DasAxis dasAxis, DasAxis dasAxis2) {
        this(dasPlot, (DataSetConsumer)tableDataSetConsumer, dasAxis, dasAxis2);
    }

    protected HorizontalSlicerMouseModule(DasPlot dasPlot, DataSetConsumer dataSetConsumer, DasAxis dasAxis, DasAxis dasAxis2) {
        super(dasPlot, new HorizontalSliceSelectionRenderer(dasPlot), "Horizontal Slice");
        if (!(dataSetConsumer instanceof TableDataSetConsumer)) {
            throw new IllegalArgumentException("dataSetConsumer must be an XTaggedYScanDataSetConsumer");
        }
        this.dataSetConsumer = (TableDataSetConsumer)dataSetConsumer;
        this.xaxis = dasAxis;
        this.yaxis = dasAxis2;
        this.de = new DataPointSelectionEvent(this, null, null);
    }

    public static HorizontalSlicerMouseModule create(DasPlot dasPlot) {
        DasAxis dasAxis = dasPlot.getXAxis();
        DasAxis dasAxis2 = dasPlot.getYAxis();
        return new HorizontalSlicerMouseModule(dasPlot, dasPlot, dasAxis, dasAxis2);
    }

    public static HorizontalSlicerMouseModule create(Renderer renderer) {
        DasPlot dasPlot = renderer.getParent();
        DasAxis dasAxis = dasPlot.getXAxis();
        DasAxis dasAxis2 = dasPlot.getYAxis();
        return new HorizontalSlicerMouseModule(dasPlot, renderer, dasAxis, dasAxis2);
    }

    public void mousePointSelected(MousePointSelectionEvent mousePointSelectionEvent) {
        DataSet dataSet = this.dataSetConsumer.getDataSet();
        this.de.setDataSet(dataSet);
        this.de.set(this.xaxis.invTransform(mousePointSelectionEvent.getX()), this.yaxis.invTransform(mousePointSelectionEvent.getY()));
        this.fireDataPointSelectionListenerDataPointSelected(this.de);
    }

    public synchronized void addDataPointSelectionListener(DataPointSelectionListener dataPointSelectionListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(class$edu$uiowa$physics$pw$das$event$DataPointSelectionListener == null ? (class$edu$uiowa$physics$pw$das$event$DataPointSelectionListener = HorizontalSlicerMouseModule.class$("edu.uiowa.physics.pw.das.event.DataPointSelectionListener")) : class$edu$uiowa$physics$pw$das$event$DataPointSelectionListener, dataPointSelectionListener);
    }

    public synchronized void removeDataPointSelectionListener(DataPointSelectionListener dataPointSelectionListener) {
        this.listenerList.remove(class$edu$uiowa$physics$pw$das$event$DataPointSelectionListener == null ? (class$edu$uiowa$physics$pw$das$event$DataPointSelectionListener = HorizontalSlicerMouseModule.class$("edu.uiowa.physics.pw.das.event.DataPointSelectionListener")) : class$edu$uiowa$physics$pw$das$event$DataPointSelectionListener, dataPointSelectionListener);
    }

    private void fireDataPointSelectionListenerDataPointSelected(DataPointSelectionEvent dataPointSelectionEvent) {
        if (this.listenerList == null) {
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$edu$uiowa$physics$pw$das$event$DataPointSelectionListener == null ? HorizontalSlicerMouseModule.class$("edu.uiowa.physics.pw.das.event.DataPointSelectionListener") : class$edu$uiowa$physics$pw$das$event$DataPointSelectionListener)) {
                ((DataPointSelectionListener)objectArray[n + 1]).DataPointSelected(dataPointSelectionEvent);
            }
            n -= 2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

