/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.event;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.event.Gesture;
import edu.uiowa.physics.pw.das.event.HorizontalRangeGesturesRenderer;
import edu.uiowa.physics.pw.das.event.MouseModule;
import edu.uiowa.physics.pw.das.event.MouseRangeGestureSelectionEvent;
import edu.uiowa.physics.pw.das.event.MouseRangeSelectionEvent;
import edu.uiowa.physics.pw.das.event.TimeRangeSelectionEvent;
import edu.uiowa.physics.pw.das.event.TimeRangeSelectionListener;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.util.DasDie;
import javax.swing.event.EventListenerList;

public class TimeRangeSelectorMouseModule
extends MouseModule {
    DasAxis timeAxis;
    private EventListenerList listenerList = null;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener;

    public String getLabel() {
        return "X Time Zoom";
    }

    public TimeRangeSelectorMouseModule(DasCanvasComponent dasCanvasComponent, DasAxis dasAxis) {
        this.parent = dasCanvasComponent;
        this.dragRenderer = new HorizontalRangeGesturesRenderer(dasCanvasComponent);
        this.timeAxis = dasAxis;
    }

    public static TimeRangeSelectorMouseModule create(DasPlot dasPlot) {
        DasAxis dasAxis = dasPlot.getXAxis();
        TimeRangeSelectorMouseModule timeRangeSelectorMouseModule = null;
        timeRangeSelectorMouseModule = new TimeRangeSelectorMouseModule(dasPlot, dasPlot.getXAxis());
        return timeRangeSelectorMouseModule;
    }

    public void mouseRangeSelected(MouseRangeSelectionEvent mouseRangeSelectionEvent) {
        MouseRangeSelectionEvent mouseRangeSelectionEvent2 = mouseRangeSelectionEvent;
        MouseRangeGestureSelectionEvent mouseRangeGestureSelectionEvent = (MouseRangeGestureSelectionEvent)mouseRangeSelectionEvent2;
        if (!mouseRangeGestureSelectionEvent.isGesture()) {
            Datum datum;
            Datum datum2 = this.timeAxis.invTransform(mouseRangeSelectionEvent2.getMinimum());
            Datum datum3 = this.timeAxis.invTransform(mouseRangeSelectionEvent2.getMaximum());
            Datum datum4 = this.timeAxis.findTick(datum2, 0.0, true);
            if (datum4.equals(datum = this.timeAxis.findTick(datum3, 0.0, true))) {
                datum2 = this.timeAxis.findTick(datum2, -1.0, true);
                datum3 = this.timeAxis.findTick(datum3, 1.0, true);
            } else {
                datum2 = datum4;
                datum3 = datum;
            }
            TimeRangeSelectionEvent timeRangeSelectionEvent = new TimeRangeSelectionEvent(this.parent, datum2, datum3);
            this.fireTimeRangeSelectionListenerTimeRangeSelected(timeRangeSelectionEvent);
        } else if (mouseRangeGestureSelectionEvent.isBack()) {
            this.timeAxis.setDataRangePrev();
        } else if (mouseRangeGestureSelectionEvent.isZoomOut()) {
            this.timeAxis.setDataRangeZoomOut();
        } else if (mouseRangeGestureSelectionEvent.isForward()) {
            this.timeAxis.setDataRangeForward();
        } else if (mouseRangeGestureSelectionEvent.getGesture() == Gesture.SCANPREV) {
            Datum datum = this.timeAxis.getDataMaximum().subtract(this.timeAxis.getDataMinimum()).multiply(0.9);
            Datum datum5 = this.timeAxis.getDataMinimum().subtract(datum);
            Datum datum6 = this.timeAxis.getDataMaximum().subtract(datum);
            TimeRangeSelectionEvent timeRangeSelectionEvent = new TimeRangeSelectionEvent(this.parent, datum5, datum6);
            this.fireTimeRangeSelectionListenerTimeRangeSelected(timeRangeSelectionEvent);
        } else if (mouseRangeGestureSelectionEvent.getGesture() == Gesture.SCANNEXT) {
            Datum datum = this.timeAxis.getDataMaximum().subtract(this.timeAxis.getDataMinimum()).multiply(0.9);
            Datum datum7 = this.timeAxis.getDataMinimum().add(datum);
            Datum datum8 = this.timeAxis.getDataMaximum().add(datum);
            TimeRangeSelectionEvent timeRangeSelectionEvent = new TimeRangeSelectionEvent(this.parent, datum7, datum8);
            this.fireTimeRangeSelectionListenerTimeRangeSelected(timeRangeSelectionEvent);
        } else {
            DasDie.println(mouseRangeGestureSelectionEvent.getGesture());
        }
    }

    public synchronized void addTimeRangeSelectionListener(TimeRangeSelectionListener timeRangeSelectionListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener == null ? (class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener = TimeRangeSelectorMouseModule.class$("edu.uiowa.physics.pw.das.event.TimeRangeSelectionListener")) : class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener, timeRangeSelectionListener);
    }

    public synchronized void removeTimeRangeSelectionListener(TimeRangeSelectionListener timeRangeSelectionListener) {
        this.listenerList.remove(class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener == null ? (class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener = TimeRangeSelectorMouseModule.class$("edu.uiowa.physics.pw.das.event.TimeRangeSelectionListener")) : class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener, timeRangeSelectionListener);
    }

    private void fireTimeRangeSelectionListenerTimeRangeSelected(TimeRangeSelectionEvent timeRangeSelectionEvent) {
        if (this.listenerList == null) {
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener == null ? TimeRangeSelectorMouseModule.class$("edu.uiowa.physics.pw.das.event.TimeRangeSelectionListener") : class$edu$uiowa$physics$pw$das$event$TimeRangeSelectionListener)) {
                DasDie.println("fire event: " + this.getClass().getName() + "-->" + objectArray[n + 1].getClass().getName() + " " + timeRangeSelectionEvent);
                ((TimeRangeSelectionListener)objectArray[n + 1]).TimeRangeSelected(timeRangeSelectionEvent);
            }
            n -= 2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

