/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.event;

import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.event.DataRangeSelectionEvent;
import edu.uiowa.physics.pw.das.event.DataRangeSelectionListener;
import edu.uiowa.physics.pw.das.event.MouseDragEvent;
import edu.uiowa.physics.pw.das.event.MouseModule;
import edu.uiowa.physics.pw.das.event.MouseRangeGestureSelectionEvent;
import edu.uiowa.physics.pw.das.event.MouseRangeSelectionEvent;
import edu.uiowa.physics.pw.das.event.VerticalRangeGesturesRenderer;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import javax.swing.event.EventListenerList;

public class VerticalRangeSelectorMouseModule
extends MouseModule {
    DasAxis axis;
    private EventListenerList listenerList = null;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener;

    public String getLabel() {
        return "Zoom Y";
    }

    public VerticalRangeSelectorMouseModule(DasCanvasComponent dasCanvasComponent, DasAxis dasAxis) {
        if (dasAxis.isHorizontal()) {
            throw new IllegalArgumentException("Axis orientation is not vertical");
        }
        this.parent = dasCanvasComponent;
        this.dragRenderer = new VerticalRangeGesturesRenderer(dasCanvasComponent);
        this.axis = dasAxis;
    }

    public static VerticalRangeSelectorMouseModule create(DasPlot dasPlot) {
        DasAxis dasAxis = dasPlot.getYAxis();
        VerticalRangeSelectorMouseModule verticalRangeSelectorMouseModule = new VerticalRangeSelectorMouseModule(dasPlot, dasPlot.getYAxis());
        return verticalRangeSelectorMouseModule;
    }

    public void mouseRangeSelected(MouseDragEvent mouseDragEvent) {
        MouseRangeSelectionEvent mouseRangeSelectionEvent = (MouseRangeSelectionEvent)mouseDragEvent;
        MouseRangeGestureSelectionEvent mouseRangeGestureSelectionEvent = (MouseRangeGestureSelectionEvent)mouseRangeSelectionEvent;
        if (!mouseRangeGestureSelectionEvent.isGesture()) {
            Datum datum;
            Datum datum2 = this.axis.invTransform(mouseRangeSelectionEvent.getMaximum());
            Datum datum3 = this.axis.invTransform(mouseRangeSelectionEvent.getMinimum());
            Datum datum4 = this.axis.findTick(datum2, 0.0, true);
            if (datum4.equals(datum = this.axis.findTick(datum3, 0.0, true))) {
                datum2 = this.axis.findTick(datum2, -1.0, true);
                datum3 = this.axis.findTick(datum3, 1.0, true);
            } else {
                datum2 = datum4;
                datum3 = datum;
            }
            DataRangeSelectionEvent dataRangeSelectionEvent = new DataRangeSelectionEvent(this.parent, datum2, datum3);
            this.fireDataRangeSelectionListenerDataRangeSelected(dataRangeSelectionEvent);
        } else if (mouseRangeGestureSelectionEvent.isBack()) {
            this.axis.setDataRangePrev();
        } else if (mouseRangeGestureSelectionEvent.isZoomOut()) {
            this.axis.setDataRangeZoomOut();
        } else if (mouseRangeGestureSelectionEvent.isForward()) {
            this.axis.setDataRangeForward();
        }
    }

    public synchronized void addDataRangeSelectionListener(DataRangeSelectionListener dataRangeSelectionListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener == null ? (class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener = VerticalRangeSelectorMouseModule.class$("edu.uiowa.physics.pw.das.event.DataRangeSelectionListener")) : class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener, dataRangeSelectionListener);
    }

    public synchronized void removeDataRangeSelectionListener(DataRangeSelectionListener dataRangeSelectionListener) {
        this.listenerList.remove(class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener == null ? (class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener = VerticalRangeSelectorMouseModule.class$("edu.uiowa.physics.pw.das.event.DataRangeSelectionListener")) : class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener, dataRangeSelectionListener);
    }

    private void fireDataRangeSelectionListenerDataRangeSelected(DataRangeSelectionEvent dataRangeSelectionEvent) {
        if (this.listenerList == null) {
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener == null ? VerticalRangeSelectorMouseModule.class$("edu.uiowa.physics.pw.das.event.DataRangeSelectionListener") : class$edu$uiowa$physics$pw$das$event$DataRangeSelectionListener)) {
                ((DataRangeSelectionListener)objectArray[n + 1]).DataRangeSelected(dataRangeSelectionEvent);
            }
            n -= 2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

