/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasException;
import edu.uiowa.physics.pw.das.DasNameException;
import edu.uiowa.physics.pw.das.DasProperties;
import edu.uiowa.physics.pw.das.DasPropertyException;
import edu.uiowa.physics.pw.das.NameContext;
import edu.uiowa.physics.pw.das.components.propertyeditor.Editable;
import edu.uiowa.physics.pw.das.dasml.FormBase;
import edu.uiowa.physics.pw.das.dasml.FormComponent;
import edu.uiowa.physics.pw.das.dasml.ParsedExpressionException;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.graph.DasColorBar;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasDevicePosition;
import edu.uiowa.physics.pw.das.graph.DasPlot;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.graph.DasSpectrogramPlot;
import edu.uiowa.physics.pw.das.graph.Renderer;
import edu.uiowa.physics.pw.das.graph.SpectrogramRenderer;
import edu.uiowa.physics.pw.das.graph.dnd.TransferableCanvasComponent;
import edu.uiowa.physics.pw.das.util.DasDie;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import edu.uiowa.physics.pw.das.util.DasPNGEncoder;
import edu.uiowa.physics.pw.das.util.DnDSupport;
import edu.uiowa.physics.pw.das.util.Splash;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DasCanvas
extends JLayeredPane
implements Printable,
Editable,
FormComponent {
    public static final Integer DEFAULT_LAYER = JLayeredPane.DEFAULT_LAYER;
    public static final Integer PLOT_LAYER = new Integer(300);
    public static final Integer VERTICAL_AXIS_LAYER = new Integer(400);
    public static final Integer HORIZONTAL_AXIS_LAYER = new Integer(500);
    public static final Integer AXIS_LAYER = VERTICAL_AXIS_LAYER;
    public static final Integer ANNOTATION_LAYER = new Integer(1000);
    public static final Integer GLASS_PANE_LAYER = new Integer(30000);
    private static final Paint PAINT_ROW = new Color(255, 178, 178, 146);
    private static final Paint PAINT_COLUMN = new Color(178, 178, 255, 146);
    private static final Paint PAINT_SELECTION = Color.GRAY;
    private static final Stroke STROKE_DASHED;
    private final GlassPane glassPane;
    private String dasName;
    private JPopupMenu popup;
    private boolean editable;
    List devicePositionList;
    DnDSupport dndSupport;
    private int displayLockCount;
    private Object displayLockObject;
    private static final int R_1024_X_768 = 786432;
    private static final int R_800_X_600 = 480000;
    private static final int R_640_X_480 = 307200;
    private static final int R_320_X_240 = 76800;
    private HashSet horizontalLineSet;
    private HashSet verticalLineSet;
    private HashSet cellSet;

    public DasCanvas() {
        block2: {
            this.devicePositionList = new ArrayList();
            this.displayLockCount = 0;
            this.displayLockObject = new String("DISPLAY_LOCK_OBJECT");
            this.horizontalLineSet = new HashSet();
            this.verticalLineSet = new HashSet();
            this.cellSet = new HashSet();
            LookAndFeel.installColorsAndFont(this, "Panel.background", "Panel.foreground", "Panel.font");
            this.setOpaque(true);
            this.setLayout(new RowColumnLayout());
            this.addComponentListener(this.createResizeListener());
            this.setBackground(Color.white);
            this.setDoubleBuffered(true);
            this.glassPane = new GlassPane();
            this.add((Component)this.glassPane, GLASS_PANE_LAYER);
            if (DasApplication.getDefaultApplication().isHeadless()) break block2;
            this.popup = this.createPopupMenu();
            this.addMouseListener(this.createMouseInputAdapter());
            try {
                this.dndSupport = new CanvasDnDSupport();
            }
            catch (SecurityException securityException) {
                this.dndSupport = new CanvasDnDSupport();
            }
        }
    }

    private MouseInputAdapter createMouseInputAdapter() {
        return new MouseInputAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                DasCanvas.this.popup.show(DasCanvas.this, mouseEvent.getX(), mouseEvent.getY());
            }
        };
    }

    private ActionListener createPopupMenuListener() {
        return new ActionListener(){
            private JFileChooser pngFileChooser;
            private JPanel pngFileNamePanel;
            private JTextField pngFileTextField;

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Das Properties")) {
                    DasProperties.showEditor();
                } else if (string.equals("print")) {
                    Printable printable = DasCanvas.this.getPrintable();
                    PrinterJob printerJob = PrinterJob.getPrinterJob();
                    printerJob.setPrintable(printable);
                    if (printerJob.printDialog()) {
                        try {
                            printerJob.print();
                        }
                        catch (PrinterException printerException) {
                            Object[] objectArray = new Object[]{"Error printing", printerException.getMessage()};
                            JOptionPane.showMessageDialog(null, objectArray, "ERROR", 0);
                        }
                    }
                } else if (string.equals("toPng")) {
                    Object object;
                    if (this.pngFileNamePanel == null) {
                        this.pngFileNamePanel = new JPanel();
                        this.pngFileNamePanel.setLayout(new BoxLayout(this.pngFileNamePanel, 0));
                        this.pngFileTextField = new JTextField(32);
                        this.pngFileTextField.setMaximumSize(this.pngFileTextField.getPreferredSize());
                        this.pngFileChooser = new JFileChooser();
                        this.pngFileChooser.setApproveButtonText("Select File");
                        this.pngFileChooser.setDialogTitle("Write to PNG");
                        object = new JButton("Browse");
                        ((AbstractButton)object).setActionCommand("pngBrowse");
                        ((AbstractButton)object).addActionListener(this);
                        this.pngFileNamePanel.add(this.pngFileTextField);
                        this.pngFileNamePanel.add((Component)object);
                    }
                    this.pngFileTextField.setText(this.pngFileChooser.getCurrentDirectory().getPath());
                    object = new String[]{"Save as PNG", "Cancel"};
                    int n = JOptionPane.showOptionDialog(DasCanvas.this, this.pngFileNamePanel, "Write to PNG", 0, 3, null, (Object[])object, "Ok");
                    if (n == 0) {
                        DasCanvas dasCanvas = DasCanvas.this;
                        try {
                            dasCanvas.writeToPng(this.pngFileTextField.getText());
                        }
                        catch (IOException iOException) {
                            DasExceptionHandler.handle(iOException);
                        }
                    }
                } else if (string.equals("about")) {
                    int n = JOptionPane.showConfirmDialog(DasCanvas.this, "release version " + Splash.getVersion(), "about das2", -1);
                } else if (string.equals("refresh")) {
                    DasCanvas.this.setSize(DasCanvas.this.getWidth() + 1, DasCanvas.this.getHeight() + 1);
                    DasCanvas.this.setSize(DasCanvas.this.getWidth(), DasCanvas.this.getHeight());
                } else if (string.equals("pngBrowse")) {
                    int n = this.pngFileChooser.showDialog(DasCanvas.this, "Select File");
                    if (n == 0) {
                        this.pngFileTextField.setText(this.pngFileChooser.getSelectedFile().getPath());
                    }
                } else {
                    DasDie.println("" + string);
                }
            }
        };
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        ActionListener actionListener = this.createPopupMenuListener();
        JMenuItem jMenuItem = new JMenuItem("Das Properties");
        jMenuItem.addActionListener(actionListener);
        jMenuItem.setToolTipText("edit global properties");
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        JMenuItem jMenuItem2 = new JMenuItem("print...");
        jMenuItem2.setActionCommand("print");
        jMenuItem2.addActionListener(actionListener);
        jMenuItem2.setToolTipText("print entire canvas");
        jPopupMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("save as PNG...");
        jMenuItem3.setActionCommand("toPng");
        jMenuItem3.setToolTipText("save canvas to png image file");
        jMenuItem3.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem3);
        jPopupMenu.addSeparator();
        JMenuItem jMenuItem4 = new JMenuItem("about");
        jMenuItem4.setActionCommand("about");
        jMenuItem4.setToolTipText("version info, etc");
        jMenuItem4.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem4);
        jPopupMenu.addSeparator();
        JMenuItem jMenuItem5 = new JMenuItem("refresh");
        jMenuItem5.setActionCommand("refresh");
        jMenuItem5.setToolTipText("force redraw");
        jMenuItem5.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem5);
        jPopupMenu.addSeparator();
        jMenuItem5 = new JMenuItem("close");
        jMenuItem5.addActionListener(actionListener);
        jMenuItem5.setToolTipText("close this popup");
        jPopupMenu.add(jMenuItem5);
        return jPopupMenu;
    }

    public Component getGlassPane() {
        return this.glassPane;
    }

    public List getDevicePositionList() {
        return Collections.unmodifiableList(this.devicePositionList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void lockDisplay(Object object) {
        Object object2 = this.displayLockObject;
        synchronized (object2) {
            ++this.displayLockCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void freeDisplay(Object object) {
        Object object2 = this.displayLockObject;
        synchronized (object2) {
            --this.displayLockCount;
            if (this.displayLockCount == 0) {
                this.displayLockObject.notifyAll();
            }
        }
    }

    public DasCanvas(int n, int n2) {
        this();
        this.setPreferredSize(new Dimension(n, n2));
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    protected void paintComponent(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n != 0) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d = this.getWidth();
        double d2 = this.getHeight();
        double d3 = pageFormat.getImageableWidth();
        double d4 = pageFormat.getImageableHeight();
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        double d5 = Math.max(d, d2);
        double d6 = Math.min(d, d2);
        double d7 = Math.max(d3, d4);
        double d8 = Math.min(d3, d4);
        double d9 = d7 / d5;
        double d10 = d8 / d6;
        double d11 = Math.min(d9, d10);
        graphics2D.scale(d11, d11);
        if (d == d5 ^ d3 == d7) {
            graphics2D.rotate(1.5707963267948966);
            graphics2D.translate(0.0, -d2);
        }
        this.print(graphics2D);
        return 0;
    }

    public Printable getPrintable() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void writeToPng(String string) throws IOException {
        block8: {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            Image image = this.getImage(this.getWidth(), this.getHeight());
            DasPNGEncoder dasPNGEncoder = new DasPNGEncoder();
            dasPNGEncoder.addText("Creation Time", new Date().toString());
            dasPNGEncoder.write((BufferedImage)image, fileOutputStream);
            Object var7_5 = null;
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
            break block8;
            {
                catch (IOException iOException) {
                    Object var7_6 = null;
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(int n, int n2) {
        this.setPreferredWidth(n);
        this.setPreferredHeight(n2);
        if ("true".equals(System.getProperty("java.awt.headless"))) {
            this.addNotify();
            this.setSize(this.getPreferredSize());
            this.validate();
        }
        final BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        if (EventQueue.isDispatchThread()) {
            this.writeToImageImmediately(bufferedImage);
        } else {
            try {
                BufferedImage bufferedImage2 = bufferedImage;
                synchronized (bufferedImage2) {
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            DasCanvas.this.writeToImageImmediately(bufferedImage);
                            Image image = bufferedImage;
                            synchronized (image) {
                                bufferedImage.notifyAll();
                            }
                        }
                    });
                    bufferedImage.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeToImageImmediately(Image image) {
        try {
            Object object = this.displayLockObject;
            synchronized (object) {
                if (this.displayLockCount != 0) {
                    this.displayLockObject.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.print(image.getGraphics());
    }

    public void add(DasCanvasComponent dasCanvasComponent, DasRow dasRow, DasColumn dasColumn) {
        if (dasCanvasComponent.getRow() == null || dasCanvasComponent.getRow().getParent() != this) {
            dasCanvasComponent.setRow(dasRow);
        }
        if (dasCanvasComponent.getColumn() == null || dasCanvasComponent.getColumn().getParent() != this) {
            dasCanvasComponent.setColumn(dasColumn);
        }
        this.add(dasCanvasComponent);
    }

    protected void addImpl(Component component, Object object, int n) {
        if (component == null) {
            DasDie.println("NULL COMPONENT");
            Thread.dumpStack();
            return;
        }
        if (n < 0) {
            n = 0;
        }
        if (component instanceof DasPlot) {
            ((DasPlot)component).putClientProperty("layeredContainerLayer", PLOT_LAYER);
        } else if (component instanceof DasAxis) {
            ((DasAxis)component).putClientProperty("layeredContainerLayer", AXIS_LAYER);
        } else if (component instanceof JComponent) {
            ((JComponent)component).putClientProperty("layeredContainerLayer", DEFAULT_LAYER);
        }
        super.addImpl(component, object, n);
        if (component instanceof DasCanvasComponent) {
            ((DasCanvasComponent)component).installComponent();
        }
    }

    public void setPreferredWidth(int n) {
        Dimension dimension = this.getPreferredSize();
        dimension.width = n;
        this.setPreferredSize(dimension);
    }

    public void setPreferredHeight(int n) {
        Dimension dimension = this.getPreferredSize();
        dimension.height = n;
        this.setPreferredSize(dimension);
    }

    public Font getBaseFont() {
        return this.getFont();
    }

    private ComponentListener createResizeListener() {
        return new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                int n;
                int n2 = DasCanvas.this.getWidth();
                int n3 = n2 * (n = DasCanvas.this.getHeight());
                Font font = n3 >= 633216 ? DasCanvas.this.getFont().deriveFont(18.0f) : (n3 >= 393600 ? DasCanvas.this.getFont().deriveFont(14.0f) : (n3 >= 192000 ? DasCanvas.this.getFont().deriveFont(12.0f) : (n3 >= 38400 ? DasCanvas.this.getFont().deriveFont(8.0f) : DasCanvas.this.getFont().deriveFont(6.0f))));
                DasCanvas.this.setFont(font);
            }
        };
    }

    public Element getDOMElement(Document document) {
        Renderer[] rendererArray;
        Object object;
        Serializable serializable;
        Object object2;
        Element element = document.createElement("canvas");
        Dimension dimension = this.getPreferredSize();
        element.setAttribute("name", this.getDasName());
        element.setAttribute("width", Integer.toString(dimension.width));
        element.setAttribute("height", Integer.toString(dimension.height));
        int n = 0;
        while (n < this.devicePositionList.size()) {
            object2 = this.devicePositionList.get(n);
            if (object2 instanceof DasRow) {
                serializable = (DasRow)object2;
                element.appendChild(((DasRow)serializable).getDOMElement(document));
            } else if (object2 instanceof DasColumn) {
                serializable = (DasColumn)object2;
                element.appendChild(((DasColumn)serializable).getDOMElement(document));
            }
            ++n;
        }
        object2 = this.getComponents();
        serializable = new LinkedHashMap();
        int n2 = 0;
        while (n2 < ((Component[])object2).length) {
            if (object2[n2] instanceof DasAxis) {
                DasAxis dasAxis = (DasAxis)object2[n2];
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < ((Component[])object2).length) {
            if (object2[n3] instanceof DasColorBar) {
                DasColorBar dasColorBar = (DasColorBar)object2[n3];
                serializable.put(dasColorBar.getDasName(), dasColorBar.getDOMElement(document));
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < ((Component[])object2).length) {
            if (object2[n4] instanceof DasSpectrogramPlot) {
                object = (DasSpectrogramPlot)object2[n4];
                serializable.remove(((DasPlot)object).getXAxis().getDasName());
                serializable.remove(((DasPlot)object).getYAxis().getDasName());
                serializable.remove(((DasSpectrogramPlot)object).getColorBar().getDasName());
                serializable.put(((DasCanvasComponent)object).getDasName(), ((DasSpectrogramPlot)object).getDOMElement(document));
            } else if (object2[n4] instanceof DasPlot) {
                object = (DasPlot)object2[n4];
                serializable.remove(((DasPlot)object).getXAxis().getDasName());
                serializable.remove(((DasPlot)object).getYAxis().getDasName());
                rendererArray = ((DasPlot)object).getRenderers();
                int n5 = 0;
                while (n5 < rendererArray.length) {
                    if (rendererArray[n5] instanceof SpectrogramRenderer) {
                        SpectrogramRenderer spectrogramRenderer = (SpectrogramRenderer)rendererArray[n5];
                        serializable.remove(spectrogramRenderer.getColorBar().getDasName());
                    }
                    ++n5;
                }
                serializable.put(((DasCanvasComponent)object).getDasName(), ((DasPlot)object).getDOMElement(document));
            }
            ++n4;
        }
        object = serializable.values().iterator();
        while (object.hasNext()) {
            rendererArray = (Renderer[])object.next();
            if (rendererArray == null) continue;
            element.appendChild((Node)rendererArray);
        }
        return element;
    }

    public static DasCanvas processCanvasElement(Element element, FormBase formBase) throws DasPropertyException, DasNameException, DasException, ParsedExpressionException, ParseException {
        try {
            String string = element.getAttribute("name");
            int n = Integer.parseInt(element.getAttribute("width"));
            int n2 = Integer.parseInt(element.getAttribute("height"));
            DasApplication dasApplication = formBase.getDasApplication();
            NameContext nameContext = dasApplication.getNameContext();
            DasCanvas dasCanvas = new DasCanvas(n, n2);
            NodeList nodeList = element.getChildNodes();
            int n3 = nodeList.getLength();
            int n4 = 0;
            while (n4 < n3) {
                Node node = nodeList.item(n4);
                if (node instanceof Element) {
                    Serializable serializable;
                    String string2 = node.getNodeName();
                    if (string2.equals("row")) {
                        serializable = DasRow.processRowElement((Element)node, dasCanvas, formBase);
                    } else if (string2.equals("column")) {
                        serializable = DasColumn.processColumnElement((Element)node, dasCanvas, formBase);
                    } else if (string2.equals("axis")) {
                        serializable = DasAxis.processAxisElement((Element)node, formBase);
                        dasCanvas.add((Component)serializable);
                    } else if (string2.equals("timeaxis")) {
                        serializable = DasAxis.processTimeaxisElement((Element)node, formBase);
                        dasCanvas.add((Component)serializable);
                    } else if (string2.equals("attachedaxis")) {
                        serializable = DasAxis.processAttachedaxisElement((Element)node, formBase);
                        dasCanvas.add((Component)serializable);
                    } else if (string2.equals("colorbar")) {
                        serializable = DasColorBar.processColorbarElement((Element)node, formBase);
                        dasCanvas.add((Component)serializable);
                    } else if (string2.equals("spectrogram")) {
                        serializable = DasSpectrogramPlot.processSpectrogramElement((Element)node, formBase);
                        dasCanvas.add((Component)serializable);
                    } else if (string2.equals("plot")) {
                        serializable = DasPlot.processPlotElement((Element)node, formBase);
                        dasCanvas.add((Component)serializable);
                    }
                }
                ++n4;
            }
            dasCanvas.setDasName(string);
            nameContext.put(string, dasCanvas);
            return dasCanvas;
        }
        catch (DasPropertyException dasPropertyException) {
            if (!element.getAttribute("name").equals("")) {
                dasPropertyException.setObjectName(element.getAttribute("name"));
            }
            throw dasPropertyException;
        }
    }

    public static DasCanvas createFormCanvas(String string, int n, int n2) {
        DasCanvas dasCanvas = new DasCanvas(n, n2);
        if (string == null) {
            string = "canvas_" + Integer.toHexString(System.identityHashCode(dasCanvas));
        }
        try {
            dasCanvas.setDasName(string);
        }
        catch (DasNameException dasNameException) {
            DasExceptionHandler.handle(dasNameException);
        }
        return dasCanvas;
    }

    public DasCanvasComponent getCanvasComponentAt(int n, int n2) {
        Component[] componentArray = this.getComponents();
        int n3 = 1;
        while (n3 < componentArray.length) {
            DasCanvasComponent dasCanvasComponent;
            Component component = componentArray[n3];
            if (component instanceof DasCanvasComponent && (dasCanvasComponent = (DasCanvasComponent)component).getActiveRegion().contains(n, n2)) {
                return dasCanvasComponent;
            }
            ++n3;
        }
        return null;
    }

    public void remove(int n) {
        Component component = this.getComponent(n);
        super.remove(n);
        if (component instanceof DasCanvasComponent) {
            ((DasCanvasComponent)component).uninstallComponent();
        }
    }

    public HotLine getLineAt(int n, int n2) {
        HotLine hotLine;
        Iterator iterator = this.horizontalLineSet.iterator();
        while (iterator.hasNext()) {
            hotLine = (HotLine)iterator.next();
            if (n2 < hotLine.position - 1 || n2 > hotLine.position + 1) continue;
            return hotLine;
        }
        iterator = this.verticalLineSet.iterator();
        while (iterator.hasNext()) {
            hotLine = (HotLine)iterator.next();
            if (n < hotLine.position - 1 || n > hotLine.position + 1) continue;
            return hotLine;
        }
        return null;
    }

    public Cell getCellAt(int n, int n2) {
        Cell cell = null;
        Point point = null;
        Point point2 = null;
        Iterator iterator = this.cellSet.iterator();
        while (iterator.hasNext()) {
            Cell cell2 = (Cell)iterator.next();
            Rectangle rectangle = cell2.rc;
            if (!rectangle.contains(n, n2)) continue;
            if (cell == null) {
                cell = cell2;
                continue;
            }
            if (point == null) {
                point = new Point();
                point2 = new Point();
            }
            if (cell.rc.contains(rectangle)) {
                cell = cell2;
                continue;
            }
            point.setLocation(cell.rc.x + cell.rc.width / 2, cell.rc.y + cell.rc.height / 2);
            point2.setLocation(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
            int n3 = DasCanvas.distanceSquared(n, n2, point.x, point.y);
            int n4 = DasCanvas.distanceSquared(n, n2, point2.x, point2.y);
            if (n4 < n3) {
                cell = cell2;
                continue;
            }
            if (n4 != n3 || rectangle.width * rectangle.height >= cell.rc.width * cell.rc.height) continue;
            cell = cell2;
        }
        return cell;
    }

    private static int distanceSquared(int n, int n2, int n3, int n4) {
        return (n3 - n) * (n3 - n) + (n4 - n2) * (n4 - n2);
    }

    void addDevicePosition(DasDevicePosition dasDevicePosition) {
        this.devicePositionList.add(dasDevicePosition);
        if (dasDevicePosition instanceof DasRow) {
            this.addRow((DasRow)dasDevicePosition);
        } else if (dasDevicePosition instanceof DasColumn) {
            this.addColumn((DasColumn)dasDevicePosition);
        }
    }

    private void addRow(DasRow dasRow) {
        HotLine hotLine = new HotLine(dasRow, -1);
        HotLine hotLine2 = new HotLine(dasRow, 1);
        this.horizontalLineSet.add(hotLine);
        this.horizontalLineSet.add(hotLine2);
        Iterator iterator = this.devicePositionList.iterator();
        while (iterator.hasNext()) {
            DasDevicePosition dasDevicePosition = (DasDevicePosition)iterator.next();
            if (!(dasDevicePosition instanceof DasColumn)) continue;
            DasColumn dasColumn = (DasColumn)dasDevicePosition;
            this.cellSet.add(new Cell(dasRow, dasColumn));
        }
    }

    private void addColumn(DasColumn dasColumn) {
        HotLine hotLine = new HotLine(dasColumn, -1);
        HotLine hotLine2 = new HotLine(dasColumn, 1);
        this.verticalLineSet.add(hotLine);
        this.verticalLineSet.add(hotLine2);
        Iterator iterator = this.devicePositionList.iterator();
        while (iterator.hasNext()) {
            DasDevicePosition dasDevicePosition = (DasDevicePosition)iterator.next();
            if (!(dasDevicePosition instanceof DasRow)) continue;
            DasRow dasRow = (DasRow)dasDevicePosition;
            this.cellSet.add(new Cell(dasRow, dasColumn));
        }
    }

    public void removepwDevicePosition(DasDevicePosition dasDevicePosition) {
        this.devicePositionList.remove(dasDevicePosition);
        if (dasDevicePosition instanceof DasRow) {
            this.removeRow((DasRow)dasDevicePosition);
        } else if (dasDevicePosition instanceof DasColumn) {
            this.removeColumn((DasColumn)dasDevicePosition);
        }
    }

    private void removeRow(DasRow dasRow) {
        Object object;
        Iterator iterator = this.horizontalLineSet.iterator();
        while (iterator.hasNext()) {
            object = (HotLine)iterator.next();
            if (((HotLine)object).devicePosition != dasRow) continue;
            iterator.remove();
        }
        object = this.cellSet.iterator();
        while (object.hasNext()) {
            Cell cell = (Cell)object.next();
            if (cell.row != dasRow) continue;
            object.remove();
        }
    }

    private void removeColumn(DasColumn dasColumn) {
        Object object;
        Iterator iterator = this.verticalLineSet.iterator();
        while (iterator.hasNext()) {
            object = (HotLine)iterator.next();
            if (((HotLine)object).devicePosition != dasColumn) continue;
            iterator.remove();
        }
        object = this.cellSet.iterator();
        while (object.hasNext()) {
            Cell cell = (Cell)object.next();
            if (cell.column != dasColumn) continue;
            object.remove();
        }
    }

    public FormBase getForm() {
        Container container = this.getParent();
        if (container instanceof FormComponent) {
            return ((FormComponent)((Object)container)).getForm();
        }
        return null;
    }

    public boolean getEditingMode() {
        return this.editable;
    }

    public void setEditingMode(boolean bl) {
        if (this.editable == bl) {
            return;
        }
        this.editable = bl;
        this.revalidate();
    }

    public DnDSupport getDnDSupport() {
        return this.dndSupport;
    }

    public boolean startDrag(int n, int n2, int n3, MouseEvent mouseEvent) {
        int n4 = 0;
        while (n4 < this.getComponentCount()) {
            if (this.getComponent(n4).getBounds().contains(n, n2)) {
                this.dndSupport.startDrag(n, n2, n3, mouseEvent);
                return true;
            }
            ++n4;
        }
        return false;
    }

    public String getDasName() {
        return this.dasName;
    }

    public void setDasName(String string) throws DasNameException {
        if (string.equals(this.dasName)) {
            return;
        }
        String string2 = this.dasName;
        this.dasName = string;
        DasApplication dasApplication = this.getDasApplication();
        if (dasApplication != null) {
            dasApplication.getNameContext().put(string, this);
            if (string2 != null) {
                dasApplication.getNameContext().remove(string2);
            }
        }
        this.firePropertyChange("name", string2, string);
    }

    public void deregisterComponent() {
        DasApplication dasApplication = this.getDasApplication();
        if (dasApplication != null) {
            Serializable serializable;
            NameContext nameContext = dasApplication.getNameContext();
            Iterator iterator = this.devicePositionList.iterator();
            while (iterator.hasNext()) {
                DasDevicePosition dasDevicePosition = (DasDevicePosition)iterator.next();
                try {
                    if (nameContext.get(dasDevicePosition.getDasName()) != dasDevicePosition) continue;
                    nameContext.remove(dasDevicePosition.getDasName());
                }
                catch (DasPropertyException dasPropertyException) {
                    IllegalStateException illegalStateException = new IllegalStateException(dasPropertyException.toString());
                    illegalStateException.initCause(dasPropertyException);
                    throw illegalStateException;
                }
                catch (InvocationTargetException invocationTargetException) {
                    IllegalStateException illegalStateException = new IllegalStateException(invocationTargetException.toString());
                    illegalStateException.initCause(invocationTargetException);
                    throw illegalStateException;
                }
            }
            int n = 0;
            while (n < this.getComponentCount()) {
                Component component = this.getComponent(n);
                if (component instanceof DasCanvasComponent) {
                    serializable = (DasCanvasComponent)component;
                    try {
                        if (nameContext.get(((DasCanvasComponent)serializable).getDasName()) == serializable) {
                            nameContext.remove(((DasCanvasComponent)serializable).getDasName());
                        }
                    }
                    catch (DasPropertyException dasPropertyException) {
                        IllegalStateException illegalStateException = new IllegalStateException(dasPropertyException.toString());
                        illegalStateException.initCause(dasPropertyException);
                        throw illegalStateException;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        IllegalStateException illegalStateException = new IllegalStateException(invocationTargetException.toString());
                        illegalStateException.initCause(invocationTargetException);
                        throw illegalStateException;
                    }
                }
                ++n;
            }
            try {
                if (nameContext.get(this.getDasName()) == this) {
                    nameContext.remove(this.getDasName());
                }
            }
            catch (DasPropertyException dasPropertyException) {
                serializable = new IllegalStateException(dasPropertyException.toString());
                ((Throwable)serializable).initCause(dasPropertyException);
                throw serializable;
            }
            catch (InvocationTargetException invocationTargetException) {
                IllegalStateException illegalStateException = new IllegalStateException(invocationTargetException.toString());
                illegalStateException.initCause(invocationTargetException);
                throw illegalStateException;
            }
        }
    }

    public DasApplication getDasApplication() {
        Container container = this.getParent();
        if (container instanceof FormComponent) {
            return ((FormComponent)((Object)container)).getDasApplication();
        }
        return null;
    }

    public void registerComponent() throws DasException {
        try {
            DasApplication dasApplication = this.getDasApplication();
            if (dasApplication != null) {
                NameContext nameContext = dasApplication.getNameContext();
                Iterator iterator = this.devicePositionList.iterator();
                while (iterator.hasNext()) {
                    DasDevicePosition dasDevicePosition = (DasDevicePosition)iterator.next();
                    nameContext.put(dasDevicePosition.getDasName(), dasDevicePosition);
                }
                int n = 0;
                while (n < this.getComponentCount()) {
                    Component component = this.getComponent(n);
                    if (component instanceof DasCanvasComponent) {
                        DasCanvasComponent dasCanvasComponent = (DasCanvasComponent)component;
                        nameContext.put(dasCanvasComponent.getDasName(), dasCanvasComponent);
                    }
                    ++n;
                }
                nameContext.put(this.getDasName(), this);
            }
        }
        catch (DasNameException dasNameException) {
            this.deregisterComponent();
            throw dasNameException;
        }
    }

    static {
        float f = 3.0f;
        int n = 2;
        int n2 = 0;
        float[] fArray = new float[]{f * 4.0f, f * 4.0f};
        STROKE_DASHED = new BasicStroke(f, n, n2, f, fArray, 0.0f);
    }

    public static class Cell
    implements PropertyChangeListener {
        Rectangle rc;
        DasRow row;
        DasColumn column;

        Cell(DasRow dasRow, DasColumn dasColumn) {
            this.row = dasRow;
            this.column = dasColumn;
            this.rc = new Rectangle();
            dasRow.addPropertyChangeListener("dMinimum", this);
            dasRow.addPropertyChangeListener("dMaximum", this);
            dasColumn.addPropertyChangeListener("dMinimum", this);
            dasColumn.addPropertyChangeListener("dMaximum", this);
            this.rc.x = (int)Math.floor((double)dasColumn.getDMinimum() + 0.5);
            this.rc.y = (int)Math.floor((double)dasRow.getDMinimum() + 0.5);
            this.rc.width = (int)Math.floor((double)dasColumn.getDMaximum() + 0.5) - this.rc.x;
            this.rc.height = (int)Math.floor((double)dasRow.getDMaximum() + 0.5) - this.rc.y;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == this.row) {
                this.rc.y = (int)Math.floor((double)this.row.getDMinimum() + 0.5);
                this.rc.height = (int)Math.floor((double)this.row.getDMaximum() + 0.5) - this.rc.y;
            } else {
                this.rc.x = (int)Math.floor((double)this.column.getDMinimum() + 0.5);
                this.rc.width = (int)Math.floor((double)this.column.getDMaximum() + 0.5) - this.rc.x;
            }
        }

        public boolean equals(Object object) {
            if (object instanceof Cell) {
                Cell cell = (Cell)object;
                return cell.row == this.row && cell.column == this.column;
            }
            return false;
        }

        public String toString() {
            return "{" + this.row.getDasName() + " x " + this.column.getDasName() + ": " + this.rc.toString() + "}";
        }

        public Rectangle getCellBounds() {
            return new Rectangle(this.rc);
        }

        public Rectangle getCellBounds(Rectangle rectangle) {
            if (rectangle == null) {
                return this.getCellBounds();
            }
            rectangle.setBounds(this.rc);
            return rectangle;
        }

        public DasRow getRow() {
            return this.row;
        }

        public DasColumn getColumn() {
            return this.column;
        }
    }

    public static class HotLine
    implements PropertyChangeListener {
        public static final int MIN = -1;
        public static final int NONE = 0;
        public static final int MAX = 1;
        int position;
        DasDevicePosition devicePosition;
        int minOrMax;

        HotLine(DasDevicePosition dasDevicePosition, int n) {
            this.devicePosition = dasDevicePosition;
            this.minOrMax = n;
            this.refresh();
            dasDevicePosition.addPropertyChangeListener(n == -1 ? "dMinimum" : "dMaximum", this);
        }

        void refresh() {
            this.position = this.minOrMax == -1 ? (int)Math.floor((double)this.devicePosition.getDMinimum() + 0.5) : (int)Math.floor((double)this.devicePosition.getDMaximum() + 0.5);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.refresh();
        }

        public boolean equals(Object object) {
            if (object instanceof HotLine) {
                HotLine hotLine = (HotLine)object;
                return hotLine.devicePosition == this.devicePosition && hotLine.minOrMax == this.minOrMax;
            }
            return false;
        }

        public int hashCode() {
            return this.minOrMax * this.devicePosition.hashCode();
        }

        public String toString() {
            return "{" + this.devicePosition.getDasName() + (this.minOrMax == -1 ? ", MIN, " : ", MAX, ") + this.position + "}";
        }

        public DasDevicePosition getDevicePosition() {
            return this.devicePosition;
        }

        public int getMinOrMax() {
            return this.minOrMax;
        }
    }

    private static class GlassPane
    extends JPanel
    implements MouseInputListener,
    KeyListener {
        boolean blocking = false;
        boolean accepting = false;
        Rectangle target;

        public GlassPane() {
            this.setOpaque(false);
            this.setLayout(null);
        }

        DasCanvas getCanvas() {
            return (DasCanvas)this.getParent();
        }

        void setBlocking(boolean bl) {
            if (bl != this.blocking) {
                this.blocking = bl;
                if (bl) {
                    this.addMouseListener(this);
                    this.addMouseMotionListener(this);
                } else {
                    this.removeMouseListener(this);
                    this.removeMouseMotionListener(this);
                }
                this.repaint();
            }
        }

        void setAccepting(boolean bl) {
            if (bl != this.accepting) {
                this.accepting = bl;
                this.repaint();
            }
        }

        protected void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            if (this.blocking) {
                this.paintLoading(graphics2D);
            }
            if (((DasCanvas)this.getParent()).getEditingMode()) {
                this.paintRowColumn(graphics2D);
            }
            if (this.accepting && this.target != null) {
                this.paintDnDTarget(graphics2D);
            }
        }

        private void paintRowColumn(Graphics2D graphics2D) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            DasCanvas dasCanvas = this.getCanvas();
            Iterator iterator = dasCanvas.devicePositionList.iterator();
            while (iterator.hasNext()) {
                Paint paint;
                int n;
                int n2;
                int n3;
                int n4;
                DasDevicePosition dasDevicePosition = (DasDevicePosition)iterator.next();
                double d = dasDevicePosition.getMinimum();
                double d2 = dasDevicePosition.getMaximum();
                int n5 = dasCanvas.getWidth();
                int n6 = dasCanvas.getHeight();
                if (dasDevicePosition instanceof DasRow) {
                    n4 = 0;
                    n3 = n5;
                    n2 = (int)Math.floor(d * (double)n6 + 0.5);
                    n = (int)Math.floor(d2 * (double)n6 + 0.5) - n2;
                    paint = PAINT_ROW;
                } else {
                    n4 = (int)Math.floor(d * (double)n5 + 0.5);
                    n3 = (int)Math.floor(d2 * (double)n5 + 0.5) - n4;
                    n2 = 0;
                    n = n6;
                    paint = PAINT_COLUMN;
                }
                graphics2D.setPaint(paint);
                graphics2D.fillRect(n4, n2, n3, n);
            }
        }

        private void paintDnDTarget(Graphics2D graphics2D) {
            graphics2D.setStroke(STROKE_DASHED);
            graphics2D.setPaint(PAINT_SELECTION);
            graphics2D.drawRect(this.target.x + 1, this.target.y + 1, this.target.width - 2, this.target.height - 2);
        }

        private void paintLoading(Graphics2D graphics2D) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            graphics2D.setColor(new Color(-587202561, true));
            Rectangle rectangle = graphics2D.getClipBounds();
            if (rectangle == null) {
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            } else {
                graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }

    private class CanvasDnDSupport
    extends DnDSupport {
        private List acceptList = Arrays.asList(TransferableCanvasComponent.PLOT_FLAVOR, TransferableCanvasComponent.AXIS_FLAVOR, TransferableCanvasComponent.COLORBAR_FLAVOR);

        CanvasDnDSupport() {
            super(DasCanvas.this, 3, null);
        }

        private Rectangle getAxisRectangle(Rectangle rectangle, Rectangle rectangle2, int n, int n2) {
            if (rectangle2 == null) {
                rectangle2 = new Rectangle();
            }
            int n3 = this.getAxisOrientation(rectangle, n, n2);
            switch (n3) {
                case 1: {
                    rectangle2.width = rectangle.width;
                    rectangle2.height = 3 * DasCanvas.this.getFont().getSize();
                    rectangle2.x = rectangle.x;
                    rectangle2.y = rectangle.y - rectangle2.height;
                    break;
                }
                case 4: {
                    rectangle2.width = 3 * DasCanvas.this.getFont().getSize();
                    rectangle2.height = rectangle.height;
                    rectangle2.x = rectangle.x + rectangle.width;
                    rectangle2.y = rectangle.y;
                    break;
                }
                case 3: {
                    rectangle2.width = 3 * DasCanvas.this.getFont().getSize();
                    rectangle2.height = rectangle.height;
                    rectangle2.x = rectangle.x - rectangle2.width;
                    rectangle2.y = rectangle.y;
                    break;
                }
                case 2: {
                    rectangle2.width = rectangle.width;
                    rectangle2.height = 3 * DasCanvas.this.getFont().getSize();
                    rectangle2.x = rectangle.x;
                    rectangle2.y = rectangle.y + rectangle.height;
                    break;
                }
                default: {
                    throw new RuntimeException("invalid orientation: " + n3);
                }
            }
            return rectangle2;
        }

        private int getAxisOrientation(Rectangle rectangle, int n, int n2) {
            boolean bl;
            int n3 = (n - rectangle.x) * rectangle.height;
            int n4 = (n2 - rectangle.y) * rectangle.width;
            int n5 = rectangle.width * rectangle.height;
            boolean bl2 = bl = n3 + n4 < n5;
            return n3 > n4 ? (bl ? 1 : 4) : (bl ? 3 : 2);
        }

        protected int canAccept(DataFlavor[] dataFlavorArray, int n, int n2, int n3) {
            DasCanvas.this.glassPane.setAccepting(true);
            List<DataFlavor> list = Arrays.asList(dataFlavorArray);
            Cell cell = DasCanvas.this.getCellAt(n, n2);
            Rectangle rectangle = cell == null ? null : cell.getCellBounds();
            Rectangle rectangle2 = ((DasCanvas)DasCanvas.this).glassPane.target;
            if (list.contains(TransferableCanvasComponent.COLORBAR_FLAVOR)) {
                return n3;
            }
            if (list.contains(TransferableCanvasComponent.AXIS_FLAVOR)) {
                if (!(rectangle2 == rectangle || rectangle2 != null && rectangle2.equals(rectangle))) {
                    if (rectangle2 != null) {
                        DasCanvas.this.glassPane.repaint(rectangle2.x - 1, rectangle2.y - 1, rectangle2.width + 2, rectangle2.height + 2);
                    }
                    if (rectangle != null) {
                        rectangle2 = ((DasCanvas)DasCanvas.this).glassPane.target = this.getAxisRectangle(rectangle, rectangle2, n, n2);
                        DasCanvas.this.glassPane.repaint(rectangle2.x - 1, rectangle2.y - 1, rectangle2.width + 2, rectangle2.height + 2);
                    } else {
                        ((DasCanvas)DasCanvas.this).glassPane.target = null;
                    }
                }
                return n3;
            }
            if (list.contains(TransferableCanvasComponent.CANVAS_COMPONENT_FLAVOR)) {
                if (!(rectangle2 == rectangle || rectangle2 != null && rectangle2.equals(rectangle))) {
                    if (rectangle2 != null) {
                        DasCanvas.this.glassPane.repaint(rectangle2.x - 1, rectangle2.y - 1, rectangle2.width + 2, rectangle2.height + 2);
                    }
                    rectangle2 = ((DasCanvas)DasCanvas.this).glassPane.target = rectangle;
                    if (rectangle != null) {
                        DasCanvas.this.glassPane.repaint(rectangle2.x - 1, rectangle2.y - 1, rectangle2.width + 2, rectangle2.height + 2);
                    }
                }
                return n3;
            }
            return -1;
        }

        protected void done() {
            DasCanvas.this.glassPane.setAccepting(false);
            if (((DasCanvas)DasCanvas.this).glassPane.target != null) {
                Rectangle rectangle = ((DasCanvas)DasCanvas.this).glassPane.target;
                ((DasCanvas)DasCanvas.this).glassPane.target = null;
                DasCanvas.this.glassPane.repaint(rectangle.x - 1, rectangle.y - 1, rectangle.width + 2, rectangle.height + 2);
            }
        }

        protected boolean importData(Transferable transferable, int n, int n2, int n3) {
            boolean bl;
            block6: {
                bl = false;
                try {
                    Cell cell;
                    if (transferable.isDataFlavorSupported(TransferableCanvasComponent.COLORBAR_FLAVOR)) {
                        Cell cell2 = DasCanvas.this.getCellAt(n, n2);
                        if (cell2 == null) break block6;
                        DasCanvasComponent dasCanvasComponent = (DasCanvasComponent)transferable.getTransferData(TransferableCanvasComponent.CANVAS_COMPONENT_FLAVOR);
                        dasCanvasComponent.setRow(cell2.getRow());
                        dasCanvasComponent.setColumn(cell2.getColumn());
                        DasCanvas.this.add(dasCanvasComponent);
                        DasCanvas.this.revalidate();
                        bl = true;
                        break block6;
                    }
                    if (transferable.isDataFlavorSupported(TransferableCanvasComponent.AXIS_FLAVOR)) {
                        Cell cell3 = DasCanvas.this.getCellAt(n, n2);
                        if (cell3 == null) break block6;
                        DasAxis dasAxis = (DasAxis)transferable.getTransferData(TransferableCanvasComponent.AXIS_FLAVOR);
                        dasAxis.setRow(cell3.getRow());
                        dasAxis.setColumn(cell3.getColumn());
                        Rectangle rectangle = cell3.getCellBounds();
                        int n4 = this.getAxisOrientation(rectangle, n, n2);
                        dasAxis.setOrientation(n4);
                        DasCanvas.this.add(dasAxis);
                        DasCanvas.this.revalidate();
                        bl = true;
                        break block6;
                    }
                    if (transferable.isDataFlavorSupported(TransferableCanvasComponent.CANVAS_COMPONENT_FLAVOR) && (cell = DasCanvas.this.getCellAt(n, n2)) != null) {
                        DasCanvasComponent dasCanvasComponent = (DasCanvasComponent)transferable.getTransferData(TransferableCanvasComponent.CANVAS_COMPONENT_FLAVOR);
                        dasCanvasComponent.setRow(cell.getRow());
                        dasCanvasComponent.setColumn(cell.getColumn());
                        DasCanvas.this.add(dasCanvasComponent);
                        DasCanvas.this.revalidate();
                        bl = true;
                    }
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (IOException iOException) {}
            }
            return bl;
        }

        protected Transferable getTransferable(int n, int n2, int n3) {
            DasCanvasComponent dasCanvasComponent = DasCanvas.this.getCanvasComponentAt(n, n2);
            if (dasCanvasComponent instanceof DasColorBar) {
                return new TransferableCanvasComponent((DasColorBar)dasCanvasComponent);
            }
            if (dasCanvasComponent instanceof DasAxis) {
                return new TransferableCanvasComponent((DasAxis)dasCanvasComponent);
            }
            if (dasCanvasComponent instanceof DasPlot) {
                return new TransferableCanvasComponent((DasPlot)dasCanvasComponent);
            }
            return null;
        }

        protected void exportDone(Transferable transferable, int n) {
        }
    }

    protected static class RowColumnLayout
    implements LayoutManager {
        protected RowColumnLayout() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void layoutContainer(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                int n = container.getComponentCount();
                int n2 = 0;
                while (n2 < n) {
                    Component component = container.getComponent(n2);
                    if (component instanceof DasCanvasComponent) {
                        ((DasCanvasComponent)component).update();
                    } else if (component == ((DasCanvas)container).glassPane) {
                        Dimension dimension = container.getSize();
                        component.setBounds(0, 0, dimension.width, dimension.height);
                    }
                    ++n2;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension minimumLayoutSize(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                int n = container.getComponentCount();
                Rectangle rectangle = new Rectangle(0, 0, 0, 0);
                int n2 = 0;
                while (n2 < n) {
                    rectangle.add(container.getComponent(n2).getBounds());
                    ++n2;
                }
                return new Dimension(rectangle.width, rectangle.height);
            }
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }
    }
}

