/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasNameException;
import edu.uiowa.physics.pw.das.DasPropertyException;
import edu.uiowa.physics.pw.das.NameContext;
import edu.uiowa.physics.pw.das.components.propertyeditor.Enumeration;
import edu.uiowa.physics.pw.das.dasml.FormBase;
import edu.uiowa.physics.pw.das.datum.Datum;
import edu.uiowa.physics.pw.das.datum.TimeUtil;
import edu.uiowa.physics.pw.das.datum.Units;
import edu.uiowa.physics.pw.das.graph.AttachedColumn;
import edu.uiowa.physics.pw.das.graph.DasAxis;
import edu.uiowa.physics.pw.das.graph.DasCanvasComponent;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.util.DasExceptionHandler;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.text.ParseException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DasColorBar
extends DasAxis {
    private BufferedImage image;
    private Type type;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$graph$DasRow;
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$graph$DasColumn;

    public DasColorBar(Datum datum, Datum datum2, boolean bl) {
        this(datum, datum2, 4, bl);
    }

    public DasColorBar(Datum datum, Datum datum2, int n, boolean bl) {
        super(datum, datum2, n, bl);
        this.setLayout(new ColorBarLayoutManager());
        this.setType(Type.COLOR_WEDGE);
    }

    public int itransform(double d, Units units) {
        int n = this.type.getColorCount();
        int n2 = this.transform(d, units, 0, n);
        if (units.isFill(d)) {
            return Color.LIGHT_GRAY.getRGB();
        }
        n2 = n2 < 0 ? 0 : n2;
        n2 = n2 >= n ? n - 1 : n2;
        return this.type.getRGB(n2);
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        if (this.type == type) {
            return;
        }
        Type type2 = this.type;
        this.type = type;
        this.image = null;
        this.markDirty();
        this.update();
        this.firePropertyChange("type", type2, type);
    }

    protected void paintComponent(Graphics graphics) {
        int n = Math.round(this.getColumn().getDMinimum());
        int n2 = Math.round(this.getRow().getDMinimum());
        int n3 = Math.round(this.getColumn().getDMaximum()) - n;
        int n4 = Math.round(this.getRow().getDMaximum()) - n2;
        if (this.image == null || this.image.getWidth() != n3 || this.image.getHeight() != n4) {
            this.image = this.isHorizontal() ? this.type.getHorizontalScaledImage(n3, n4) : this.type.getVerticalScaledImage(n3, n4);
        }
        graphics.translate(-this.getX(), -this.getY());
        if (!this.isHorizontal()) {
            ++n2;
        }
        graphics.drawImage(this.image, n, n2, this);
        graphics.translate(this.getX(), this.getY());
        super.paintComponent(graphics);
    }

    protected Rectangle getAxisBounds() {
        int n = Math.round(this.getColumn().getDMinimum());
        int n2 = Math.round(this.getRow().getDMinimum());
        int n3 = Math.round(this.getColumn().getDMaximum()) - n;
        int n4 = Math.round(this.getRow().getDMaximum()) - n2;
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        Rectangle rectangle2 = super.getAxisBounds();
        rectangle2.add(rectangle);
        return rectangle2;
    }

    public static DasColumn getColorBarColumn(DasColumn dasColumn) {
        return new AttachedColumn(dasColumn, 1.05, 1.1);
    }

    static DasColorBar processColorbarElement(Element element, FormBase formBase) throws DasPropertyException, DasNameException, ParseException {
        Object object;
        Object object2;
        String string;
        Datum datum;
        Datum datum2;
        Object object3;
        Object object4;
        String string2 = element.getAttribute("name");
        boolean bl = element.getAttribute("log").equals("true");
        String string3 = element.getAttribute("units");
        if (string3 == null) {
            string3 = "";
        }
        if (string3.equals("TIME")) {
            object4 = element.getAttribute("dataMinimum");
            object3 = element.getAttribute("dataMaximum");
            datum2 = object4 == null || ((String)object4).equals("") ? TimeUtil.create("1979-02-26") : TimeUtil.create((String)object4);
            datum = object3 == null || ((String)object3).equals("") ? TimeUtil.create("1979-02-27") : TimeUtil.create((String)object3);
        } else {
            object4 = Units.getByName(string3);
            object3 = element.getAttribute("dataMinimum");
            string = element.getAttribute("dataMaximum");
            datum2 = object3 == null || ((String)object3).equals("") ? Datum.create(1.0, (Units)object4) : Datum.create(Double.parseDouble((String)object3), (Units)object4);
            datum = string == null || string.equals("") ? Datum.create(10.0, (Units)object4) : Datum.create(Double.parseDouble(string), (Units)object4);
        }
        int n = DasAxis.parseOrientationString(element.getAttribute("orientation"));
        object3 = new DasColorBar(datum2, datum, n, bl);
        string = element.getAttribute("row");
        if (!string.equals("")) {
            object2 = (DasRow)formBase.checkValue(string, class$edu$uiowa$physics$pw$das$graph$DasRow == null ? (class$edu$uiowa$physics$pw$das$graph$DasRow = DasColorBar.class$("edu.uiowa.physics.pw.das.graph.DasRow")) : class$edu$uiowa$physics$pw$das$graph$DasRow, "<row>");
            ((DasCanvasComponent)object3).setRow((DasRow)object2);
        }
        if (!((String)(object2 = element.getAttribute("column"))).equals("")) {
            object = (DasColumn)formBase.checkValue((String)object2, class$edu$uiowa$physics$pw$das$graph$DasColumn == null ? (class$edu$uiowa$physics$pw$das$graph$DasColumn = DasColorBar.class$("edu.uiowa.physics.pw.das.graph.DasColumn")) : class$edu$uiowa$physics$pw$das$graph$DasColumn, "<column>");
            ((DasCanvasComponent)object3).setColumn((DasColumn)object);
        }
        ((DasAxis)object3).setLabel(element.getAttribute("label"));
        ((DasAxis)object3).setOppositeAxisVisible(!element.getAttribute("oppositeAxisVisible").equals("false"));
        ((DasAxis)object3).setTickLabelsVisible(!element.getAttribute("tickLabelsVisible").equals("false"));
        ((DasColorBar)object3).setType(Type.parse(element.getAttribute("type")));
        ((DasCanvasComponent)object3).setDasName(string2);
        object = formBase.getDasApplication();
        NameContext nameContext = ((DasApplication)object).getNameContext();
        nameContext.put(string2, object3);
        return object3;
    }

    public Element getDOMElement(Document document) {
        Element element = document.createElement("colorbar");
        String string = this.getDataMinimum().toString();
        element.setAttribute("dataMinimum", string);
        String string2 = this.getDataMaximum().toString();
        element.setAttribute("dataMaximum", string2);
        element.setAttribute("name", this.getDasName());
        element.setAttribute("row", this.getRow().getDasName());
        element.setAttribute("column", this.getColumn().getDasName());
        element.setAttribute("label", this.getLabel());
        element.setAttribute("log", Boolean.toString(this.isLog()));
        element.setAttribute("tickLabelsVisible", Boolean.toString(this.areTickLabelsVisible()));
        element.setAttribute("oppositeAxisVisible", Boolean.toString(this.isOppositeAxisVisible()));
        element.setAttribute("animated", Boolean.toString(this.isAnimated()));
        element.setAttribute("orientation", DasAxis.orientationToString(this.getOrientation()));
        element.setAttribute("type", this.getType().toString());
        return element;
    }

    public static DasColorBar createNamedColorBar(String string) {
        DasColorBar dasColorBar = new DasColorBar(Datum.create(1.0, Units.dimensionless), Datum.create(10.0, Units.dimensionless), false);
        if (string == null) {
            string = "colorbar_" + Integer.toHexString(System.identityHashCode(dasColorBar));
        }
        try {
            dasColorBar.setDasName(string);
        }
        catch (DasNameException dasNameException) {
            DasExceptionHandler.handle(dasNameException);
        }
        return dasColorBar;
    }

    public Shape getActiveRegion() {
        int n = Math.round(this.getColumn().getDMinimum());
        int n2 = Math.round(this.getRow().getDMinimum());
        int n3 = Math.round(this.getColumn().getDMaximum()) - n;
        int n4 = Math.round(this.getRow().getDMaximum()) - n2;
        Rectangle rectangle = this.primaryInputPanel.getBounds();
        rectangle.translate(this.getX(), this.getY());
        Rectangle rectangle2 = new Rectangle(n, n2, n3, n4);
        rectangle.add(rectangle2);
        if (this.isOppositeAxisVisible()) {
            Rectangle rectangle3 = this.secondaryInputPanel.getBounds();
            rectangle3.translate(this.getX(), this.getY());
            rectangle.add(rectangle3);
        }
        return rectangle;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static final class Type
    implements Enumeration {
        public static final Type COLOR_WEDGE = new Type("color_wedge");
        public static final Type GRAYSCALE = new Type("grayscale");
        public static final Type INVERSE_GRAYSCALE = new Type("inverse_grayscale");
        private BufferedImage image;
        private int[] colorTable;
        private final String desc;
        private Icon icon;

        private Type(String string) {
            this.desc = string;
        }

        public Icon getListIcon() {
            this.maybeInitializeIcon();
            return this.icon;
        }

        public void maybeInitializeIcon() {
            if (this.icon == null) {
                this.icon = new ImageIcon(this.getVerticalScaledImage(24, 24));
            }
        }

        public String toString() {
            return this.desc;
        }

        public int getColorCount() {
            this.maybeInitializeColorTable();
            return this.colorTable.length;
        }

        public int getRGB(int n) {
            this.maybeInitializeColorTable();
            return this.colorTable[n];
        }

        public BufferedImage getHorizontalScaledImage(int n, int n2) {
            this.maybeInitializeImage();
            BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.scale((double)n / (double)this.colorTable.length, n2);
            affineTransform.rotate(-1.5707963267948966);
            affineTransform.translate(-1.0, 0.0);
            AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
            affineTransformOp.filter(this.image, bufferedImage);
            return bufferedImage;
        }

        public BufferedImage getVerticalScaledImage(int n, int n2) {
            this.maybeInitializeImage();
            BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.scale(n, -((double)n2) / (double)this.colorTable.length);
            affineTransform.translate(0.0, -((double)this.colorTable.length));
            AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
            affineTransformOp.filter(this.image, bufferedImage);
            return bufferedImage;
        }

        private void maybeInitializeImage() {
            if (this.image == null) {
                this.maybeInitializeColorTable();
                this.image = new BufferedImage(1, this.colorTable.length, 1);
                this.image.setRGB(0, 0, 1, this.colorTable.length, this.colorTable, 0, 1);
            }
        }

        private void maybeInitializeColorTable() {
            if (this.colorTable == null) {
                if (this == COLOR_WEDGE) {
                    this.initializeColorWedge();
                } else if (this == GRAYSCALE) {
                    this.initializeGrayScale();
                } else if (this == INVERSE_GRAYSCALE) {
                    this.initializeInverseGrayScale();
                }
            }
        }

        private void initializeColorWedge() {
            int[] nArray = new int[]{0, 30, 63, 126, 162, 192, 221, 255};
            int[] nArray2 = new int[]{0, 0, 0, 0, 255, 255, 255, 255};
            int[] nArray3 = new int[]{0, 0, 255, 255, 255, 185, 84, 0};
            int[] nArray4 = new int[]{137, 255, 255, 0, 0, 0, 0, 0};
            this.colorTable = new int[256];
            int n = 0;
            int n2 = 0;
            while (n2 < this.colorTable.length) {
                if (n2 > nArray[n + 1]) {
                    ++n;
                }
                double d = (double)(n2 - nArray[n]) / (double)(nArray[n + 1] - nArray[n]);
                double d2 = ((double)nArray2[n] * (1.0 - d) + (double)nArray2[n + 1] * d) / 255.0;
                double d3 = ((double)nArray3[n] * (1.0 - d) + (double)nArray3[n + 1] * d) / 255.0;
                double d4 = ((double)nArray4[n] * (1.0 - d) + (double)nArray4[n + 1] * d) / 255.0;
                this.colorTable[n2] = new Color((float)d2, (float)d3, (float)d4).getRGB();
                ++n2;
            }
            this.colorTable[0] = this.colorTable[0] & 0xFFFFFF00 | 1;
        }

        private void initializeInverseGrayScale() {
            this.colorTable = new int[256];
            int n = 0;
            while (n < 256) {
                this.colorTable[n] = 0xFF000000 | n << 16 | n << 8 | n;
                ++n;
            }
        }

        private void initializeGrayScale() {
            this.colorTable = new int[256];
            int n = 255;
            while (n >= 0) {
                this.colorTable[255 - n] = 0xFF000000 | n << 16 | n << 8 | n;
                --n;
            }
        }

        public static Type parse(String string) {
            if (string.equals("color_wedge")) {
                return COLOR_WEDGE;
            }
            if (string.equals("grayscale")) {
                return GRAYSCALE;
            }
            if (string.equals("inverse_grayscale")) {
                return INVERSE_GRAYSCALE;
            }
            throw new IllegalArgumentException("invalid DasColorBar.Type string: " + string);
        }
    }

    protected class ColorBarLayoutManager
    extends DasAxis.AxisLayoutManager {
        protected ColorBarLayoutManager() {
        }

        public void layoutContainer(Container container) {
            super.layoutContainer(container);
            int n = Math.round(DasColorBar.this.getColumn().getDMinimum());
            int n2 = Math.round(DasColorBar.this.getRow().getDMinimum());
            int n3 = Math.round(DasColorBar.this.getColumn().getDMaximum()) - n;
            int n4 = Math.round(DasColorBar.this.getRow().getDMaximum()) - n2;
            Rectangle rectangle = new Rectangle(n - DasColorBar.this.getX(), n2 - DasColorBar.this.getY(), n3, n4);
            Rectangle rectangle2 = DasColorBar.this.primaryInputPanel.getBounds();
            rectangle2.add(rectangle);
            DasColorBar.this.primaryInputPanel.setBounds(rectangle2);
        }
    }
}

