/*
 * Decompiled with CFR 0.152.
 */
package edu.uiowa.physics.pw.das.graph;

import edu.uiowa.physics.pw.das.DasApplication;
import edu.uiowa.physics.pw.das.DasNameException;
import edu.uiowa.physics.pw.das.components.propertyeditor.Editable;
import edu.uiowa.physics.pw.das.graph.DasCanvas;
import edu.uiowa.physics.pw.das.graph.DasColumn;
import edu.uiowa.physics.pw.das.graph.DasRow;
import edu.uiowa.physics.pw.das.graph.event.DasUpdateEvent;
import edu.uiowa.physics.pw.das.graph.event.DasUpdateListener;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import javax.swing.event.EventListenerList;

public abstract class DasDevicePosition
implements Editable,
Serializable {
    protected transient DasCanvas parent;
    private double minimum;
    private double maximum;
    private String dasName;
    private transient PropertyChangeSupport propertyChangeDelegate;
    protected EventListenerList listenerList = new EventListenerList();
    static /* synthetic */ Class class$edu$uiowa$physics$pw$das$graph$event$DasUpdateListener;

    public DasDevicePosition(DasCanvas dasCanvas, double d, double d2) {
        if (dasCanvas == null) {
            boolean bl;
            boolean bl2 = bl = this instanceof DasColumn.NullDasColumn || this instanceof DasRow.NullDasRow;
            if (!bl) {
                throw new IllegalArgumentException("parent cannot be null, absolute rows and columns are no longer allowed. Jun 26, 03");
            }
        }
        this.parent = dasCanvas;
        this.minimum = d;
        this.maximum = d2;
        this.dasName = "dp_" + Integer.toString(this.hashCode());
        this.propertyChangeDelegate = new PropertyChangeSupport(this);
        if (dasCanvas != null) {
            dasCanvas.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent componentEvent) {
                    DasDevicePosition.this.firePropertyChange("dMinimum", 0.0, (double)DasDevicePosition.this.getDMinimum());
                    DasDevicePosition.this.firePropertyChange("dMaximum", 0.0, (double)DasDevicePosition.this.getDMaximum());
                    DasDevicePosition.this.fireUpdate();
                }
            });
            dasCanvas.addDevicePosition(this);
        }
    }

    public void setDasName(String string) throws DasNameException {
        if (string.equals(this.dasName)) {
            return;
        }
        String string2 = this.dasName;
        this.dasName = string;
        DasApplication dasApplication = this.parent.getDasApplication();
        if (dasApplication != null) {
            dasApplication.getNameContext().put(string, this);
            if (string2 != null) {
                dasApplication.getNameContext().remove(string2);
            }
        }
        this.firePropertyChange("name", string2, string);
    }

    public String getDasName() {
        return this.dasName;
    }

    public int getDMinimum() {
        return (int)(this.minimum * (double)this.getDeviceSize());
    }

    public int getDMaximum() {
        return (int)(this.maximum * (double)this.getDeviceSize());
    }

    public double getMinimum() {
        return this.minimum;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public void setPosition(double d, double d2) {
        double d3 = this.minimum;
        double d4 = this.maximum;
        this.minimum = Math.min(d, d2);
        this.maximum = Math.max(d2, d2);
        if (d3 != this.minimum) {
            this.firePropertyChange("minimum", d3, this.minimum);
            this.firePropertyChange("dMinimum", d3 * (double)this.getDeviceSize(), (double)this.getDMinimum());
        }
        if (d4 != this.maximum) {
            this.firePropertyChange("maximum", d4, this.maximum);
            this.firePropertyChange("dMaximum", d4 * (double)this.getDeviceSize(), (double)this.getDMaximum());
        }
        this.fireUpdate();
    }

    public void setDPosition(int n, int n2) {
        this.setPosition((double)n / (double)this.getDeviceSize(), (double)n2 / (double)this.getDeviceSize());
    }

    public void setMaximum(double d) {
        if (d == this.maximum) {
            return;
        }
        if (d < this.minimum) {
            this.setPosition(d, this.minimum);
        } else {
            double d2 = this.maximum;
            this.maximum = d;
            this.firePropertyChange("maximum", d2, d);
            this.firePropertyChange("dMaximum", d2 * (double)this.getDeviceSize(), (double)this.getDMaximum());
            this.fireUpdate();
        }
    }

    public void setDMaximum(int n) {
        this.setMaximum((double)n / (double)this.getDeviceSize());
    }

    public void setMinimum(double d) {
        if (d == this.minimum) {
            return;
        }
        if (d > this.maximum) {
            this.setPosition(this.maximum, d);
        } else {
            double d2 = this.minimum;
            this.minimum = d;
            this.firePropertyChange("minimum", d2, d);
            this.firePropertyChange("dMinimum", d2 * (double)this.getDeviceSize(), (double)this.getDMinimum());
            this.fireUpdate();
        }
    }

    public void setDMinimum(int n) {
        this.setMinimum((double)n / (double)this.getDeviceSize());
    }

    public void translate(double d) {
        this.setPosition(this.minimum + d, this.maximum + d);
    }

    public void dTranslate(int n) {
        this.setDPosition(this.getDMinimum() + n, this.getDMaximum() + n);
    }

    public DasCanvas getParent() {
        return this.parent;
    }

    public void setParent(DasCanvas dasCanvas) {
        this.parent = dasCanvas;
        this.fireUpdate();
    }

    public void addpwUpdateListener(DasUpdateListener dasUpdateListener) {
        this.listenerList.add(class$edu$uiowa$physics$pw$das$graph$event$DasUpdateListener == null ? (class$edu$uiowa$physics$pw$das$graph$event$DasUpdateListener = DasDevicePosition.class$("edu.uiowa.physics.pw.das.graph.event.DasUpdateListener")) : class$edu$uiowa$physics$pw$das$graph$event$DasUpdateListener, dasUpdateListener);
    }

    public void removepwUpdateListener(DasUpdateListener dasUpdateListener) {
        this.listenerList.remove(class$edu$uiowa$physics$pw$das$graph$event$DasUpdateListener == null ? (class$edu$uiowa$physics$pw$das$graph$event$DasUpdateListener = DasDevicePosition.class$("edu.uiowa.physics.pw.das.graph.event.DasUpdateListener")) : class$edu$uiowa$physics$pw$das$graph$event$DasUpdateListener, dasUpdateListener);
    }

    protected void fireUpdate() {
        DasUpdateEvent dasUpdateEvent = new DasUpdateEvent(this);
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$edu$uiowa$physics$pw$das$graph$event$DasUpdateListener == null ? DasDevicePosition.class$("edu.uiowa.physics.pw.das.graph.event.DasUpdateListener") : class$edu$uiowa$physics$pw$das$graph$event$DasUpdateListener)) {
                ((DasUpdateListener)objectArray[n + 1]).update(dasUpdateEvent);
            }
            n -= 2;
        }
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeDelegate.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeDelegate.addPropertyChangeListener(string, propertyChangeListener);
    }

    protected void firePropertyChange(String string, boolean bl, boolean bl2) {
        this.firePropertyChange(string, bl ? Boolean.TRUE : Boolean.FALSE, bl2 ? Boolean.TRUE : Boolean.FALSE);
    }

    protected void firePropertyChange(String string, int n, int n2) {
        this.firePropertyChange(string, new Integer(n), new Integer(n2));
    }

    protected void firePropertyChange(String string, long l, long l2) {
        this.firePropertyChange(string, new Long(l), new Long(l2));
    }

    protected void firePropertyChange(String string, float f, float f2) {
        this.firePropertyChange(string, new Float(f), new Float(f2));
    }

    protected void firePropertyChange(String string, double d, double d2) {
        this.firePropertyChange(string, new Double(d), new Double(d2));
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.propertyChangeDelegate.firePropertyChange(string, object, object2);
    }

    protected abstract int getDeviceSize();

    public static Rectangle toRectangle(DasRow dasRow, DasColumn dasColumn) {
        int n = dasColumn.getDMinimum();
        int n2 = dasRow.getDMinimum();
        return new Rectangle(n, n2, dasColumn.getDMaximum() - n, dasRow.getDMaximum() - n2);
    }

    public String toString() {
        return this.getClass().getName() + "[minimum=" + this.getDMinimum() + " maximum=" + this.getDMaximum() + "]";
    }

    public boolean contains(int n) {
        return this.getDMinimum() <= n && n <= this.getDMaximum();
    }

    public int getDMiddle() {
        return (this.getDMinimum() + this.getDMaximum()) / 2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

